/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.mapbox.android.telemetry.ConfigurationChangeHandler;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.EnvironmentResolver;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

class ConfigurationClient
implements Callback {
    private static final String ACCESS_TOKEN_QUERY_PARAMETER = "access_token";
    private static final String CHINA_CONFIG_ENDPOINT = "api.mapbox.cn";
    private static final String COM_CONFIG_ENDPOINT = "api.mapbox.com";
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final Map<Environment, String> ENDPOINTS = new HashMap<Environment, String>(){
        {
            this.put(Environment.COM, ConfigurationClient.COM_CONFIG_ENDPOINT);
            this.put(Environment.STAGING, ConfigurationClient.COM_CONFIG_ENDPOINT);
            this.put(Environment.CHINA, ConfigurationClient.CHINA_CONFIG_ENDPOINT);
        }
    };
    private static final String EVENT_CONFIG_SEGMENT = "events-config";
    private static final String HTTPS_SCHEME = "https";
    private static final String LOG_TAG = "ConfigurationClient";
    private static final String MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP = "mapboxConfigSyncTimestamp";
    private static final String USER_AGENT_REQUEST_HEADER = "User-Agent";
    private final String accessToken;
    private final OkHttpClient client;
    private final Context context;
    private final List<ConfigurationChangeHandler> handlers;
    private final String userAgent;

    ConfigurationClient(Context context, String string2, String string3, OkHttpClient okHttpClient) {
        this.context = context;
        this.userAgent = string2;
        this.accessToken = string3;
        this.client = okHttpClient;
        this.handlers = new CopyOnWriteArrayList<ConfigurationChangeHandler>();
    }

    private static String determineConfigEndpoint(Context object) {
        block4: {
            EnvironmentResolver environmentResolver = new EnvironmentChain().setup();
            object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
            if (object == null) break block4;
            try {
                if (((ApplicationInfo)object).metaData != null) {
                    object = environmentResolver.obtainServerInformation(((ApplicationInfo)object).metaData);
                    object = ENDPOINTS.get((Object)((ServerInformation)object).getEnvironment());
                    return object;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)LOG_TAG, (String)nameNotFoundException.getMessage());
            }
        }
        return COM_CONFIG_ENDPOINT;
    }

    private static HttpUrl generateRequestUrl(Context context, String string2) {
        return new HttpUrl.Builder().scheme(HTTPS_SCHEME).host(ConfigurationClient.determineConfigEndpoint(context)).addPathSegment(EVENT_CONFIG_SEGMENT).addQueryParameter(ACCESS_TOKEN_QUERY_PARAMETER, string2).build();
    }

    private void saveTimestamp() {
        SharedPreferences.Editor editor = TelemetryUtils.obtainSharedPreferences(this.context).edit();
        editor.putLong(MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP, System.currentTimeMillis());
        editor.apply();
    }

    void addHandler(ConfigurationChangeHandler configurationChangeHandler) {
        this.handlers.add(configurationChangeHandler);
    }

    public void onFailure(Call call, IOException iOException) {
        this.saveTimestamp();
    }

    public void onResponse(Call object, Response response) throws IOException {
        this.saveTimestamp();
        if (response == null) {
            return;
        }
        if ((response = response.body()) == null) {
            return;
        }
        for (ConfigurationChangeHandler configurationChangeHandler : this.handlers) {
            if (configurationChangeHandler == null) continue;
            configurationChangeHandler.onUpdate(response.string());
        }
    }

    boolean shouldUpdate() {
        long l = TelemetryUtils.obtainSharedPreferences(this.context).getLong(MAPBOX_CONFIG_SYNC_KEY_TIMESTAMP, 0L);
        boolean bl = System.currentTimeMillis() - l >= 86400000L;
        return bl;
    }

    void update() {
        HttpUrl httpUrl = ConfigurationClient.generateRequestUrl(this.context, this.accessToken);
        httpUrl = new Request.Builder().url(httpUrl).header(USER_AGENT_REQUEST_HEADER, this.userAgent).build();
        this.client.newCall((Request)httpUrl).enqueue((Callback)this);
    }
}

