/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

public class LocationEvent
extends Event
implements Parcelable {
    public static final Parcelable.Creator<LocationEvent> CREATOR;
    private static final String LOCATION = "location";
    private static final String OPERATING_SYSTEM;
    private static final String SOURCE_MAPBOX = "mapbox";
    @SerializedName(value="horizontalAccuracy")
    private Float accuracy;
    @SerializedName(value="altitude")
    private Double altitude;
    @SerializedName(value="applicationState")
    private String applicationState;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="lat")
    private final double latitude;
    @SerializedName(value="lng")
    private final double longitude;
    @SerializedName(value="operatingSystem")
    private String operatingSystem;
    @SerializedName(value="sessionId")
    private final String sessionId;
    @SerializedName(value="source")
    private String source;

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Android - ");
        stringBuilder.append(Build.VERSION.RELEASE);
        OPERATING_SYSTEM = stringBuilder.toString();
        CREATOR = new Parcelable.Creator<LocationEvent>(){

            public LocationEvent createFromParcel(Parcel parcel) {
                return new LocationEvent(parcel);
            }

            public LocationEvent[] newArray(int n) {
                return new LocationEvent[n];
            }
        };
    }

    private LocationEvent(Parcel object) {
        Object var2_2 = null;
        this.altitude = null;
        this.accuracy = null;
        this.event = object.readString();
        this.created = object.readString();
        this.source = object.readString();
        this.sessionId = object.readString();
        this.latitude = object.readDouble();
        this.longitude = object.readDouble();
        Double d = object.readByte() == 0 ? null : Double.valueOf(object.readDouble());
        this.altitude = d;
        this.operatingSystem = object.readString();
        this.applicationState = object.readString();
        object = object.readByte() == 0 ? var2_2 : Float.valueOf(object.readFloat());
        this.accuracy = object;
    }

    public LocationEvent(String string2, double d, double d2, String string3) {
        this.altitude = null;
        this.accuracy = null;
        this.event = LOCATION;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.source = SOURCE_MAPBOX;
        this.sessionId = string2;
        this.latitude = d;
        this.longitude = d2;
        this.operatingSystem = OPERATING_SYSTEM;
        this.applicationState = string3;
    }

    public int describeContents() {
        return 0;
    }

    Float getAccuracy() {
        return this.accuracy;
    }

    Double getAltitude() {
        return this.altitude;
    }

    String getEvent() {
        return this.event;
    }

    double getLatitude() {
        return this.latitude;
    }

    double getLongitude() {
        return this.longitude;
    }

    String getOperatingSystem() {
        return this.operatingSystem;
    }

    String getSource() {
        return this.source;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.LOCATION;
    }

    public void setAccuracy(Float f) {
        this.accuracy = f;
    }

    public void setAltitude(Double d) {
        this.altitude = d;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.event);
        parcel.writeString(this.created);
        parcel.writeString(this.source);
        parcel.writeString(this.sessionId);
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.longitude);
        if (this.altitude == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeDouble(this.altitude.doubleValue());
        }
        parcel.writeString(this.operatingSystem);
        parcel.writeString(this.applicationState);
        if (this.accuracy == null) {
            parcel.writeByte((byte)0);
        } else {
            parcel.writeByte((byte)1);
            parcel.writeFloat(this.accuracy.floatValue());
        }
    }
}

