/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.mapbox.android.core.crashreporter.CrashReport;
import com.mapbox.android.core.crashreporter.CrashReportFactory;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.errors.ErrorUtils;
import java.util.Map;
import java.util.Set;

public class MapboxCrashReporter {
    private final CrashReportFactory crashReportFactory;
    private final MapboxTelemetry telemetry;

    MapboxCrashReporter(MapboxTelemetry mapboxTelemetry, CrashReportFactory crashReportFactory) {
        this.telemetry = mapboxTelemetry;
        this.crashReportFactory = crashReportFactory;
    }

    public MapboxCrashReporter(MapboxTelemetry mapboxTelemetry, String string2, String string3, Set<String> set) {
        this.telemetry = mapboxTelemetry;
        this.crashReportFactory = new CrashReportFactory(MapboxTelemetry.applicationContext, string2, string3, set);
    }

    CrashEvent parseReportAsEvent(CrashReport crashReport) {
        return ErrorUtils.parseJsonCrashEvent(crashReport.toJson());
    }

    public boolean reportError(Throwable throwable) {
        return this.reportError(throwable, null);
    }

    public boolean reportError(Throwable object, Map<String, String> map) {
        if ((object = this.crashReportFactory.createReportForNonFatal((Throwable)object, map)) != null) {
            object = this.parseReportAsEvent((CrashReport)object);
            return this.telemetry.pushToQueue((Event)object);
        }
        return false;
    }
}

