/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.ComServerInformation;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentChain;
import com.mapbox.android.telemetry.Logger;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryClient;
import com.mapbox.android.telemetry.TelemetryClientSettings;
import com.mapbox.android.telemetry.TelemetryUtils;

class TelemetryClientFactory {
    private static final String LOG_TAG = "TelemetryClientFactory";
    private static final String RETRIEVING_APP_META_DATA_ERROR_MESSAGE = "Failed when retrieving app meta-data: %s";
    private final String accessToken;
    private final CertificateBlacklist certificateBlacklist;
    private final Logger logger;
    private final String userAgent;

    TelemetryClientFactory(String string2, String string3, Logger logger, CertificateBlacklist certificateBlacklist) {
        this.accessToken = string2;
        this.userAgent = string3;
        this.logger = logger;
        this.certificateBlacklist = certificateBlacklist;
    }

    private TelemetryClient buildClientFrom(ServerInformation serverInformation, Context context) {
        Environment environment = serverInformation.getEnvironment();
        if (1.$SwitchMap$com$mapbox$android$telemetry$Environment[environment.ordinal()] != 1) {
            if (!TelemetryUtils.isEmpty(serverInformation.getHostname())) {
                return this.buildTelemetryClientCustom(serverInformation, this.certificateBlacklist, context);
            }
            return this.buildTelemetryClient(environment, this.certificateBlacklist, context);
        }
        return this.buildTelemetryClientCustom(serverInformation, this.certificateBlacklist, context);
    }

    private TelemetryClient buildTelemetryClient(Environment environment, CertificateBlacklist certificateBlacklist, Context object) {
        String string2 = this.accessToken;
        String string3 = this.userAgent;
        String string4 = TelemetryUtils.createReformedFullUserAgent(object);
        object = new TelemetryClientSettings.Builder((Context)object).environment(environment).build();
        Logger logger = this.logger;
        boolean bl = environment == Environment.CHINA;
        return new TelemetryClient(string2, string3, string4, (TelemetryClientSettings)object, logger, certificateBlacklist, bl);
    }

    private TelemetryClient buildTelemetryClientCustom(ServerInformation serverInformation, CertificateBlacklist certificateBlacklist, Context object) {
        TelemetryClientSettings telemetryClientSettings = new TelemetryClientSettings.Builder((Context)object).environment(serverInformation.getEnvironment()).baseUrl(TelemetryClientSettings.configureUrlHostname(serverInformation.getHostname())).build();
        String string2 = serverInformation.getAccessToken();
        if (string2 == null) {
            string2 = this.accessToken;
        }
        String string3 = this.userAgent;
        String string4 = TelemetryUtils.createReformedFullUserAgent(object);
        object = this.logger;
        boolean bl = serverInformation.getEnvironment() == Environment.CHINA;
        return new TelemetryClient(string2, string3, string4, telemetryClientSettings, (Logger)object, certificateBlacklist, bl);
    }

    TelemetryClient obtainTelemetryClient(Context context) {
        block4: {
            Object object = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (object == null) break block4;
            try {
                if (object.metaData != null) {
                    EnvironmentChain environmentChain = new EnvironmentChain();
                    object = this.buildClientFrom(environmentChain.setup().obtainServerInformation(object.metaData), context);
                    return object;
                }
            }
            catch (Exception exception) {
                this.logger.error(LOG_TAG, String.format(RETRIEVING_APP_META_DATA_ERROR_MESSAGE, exception.getMessage()));
            }
        }
        return this.buildTelemetryClient(Environment.COM, this.certificateBlacklist, context);
    }

    TelemetryClient obtainTelemetryClient(Environment object, Context context) {
        block5: {
            if (object == Environment.CHINA) {
                return this.buildTelemetryClient((Environment)((Object)object), this.certificateBlacklist, context);
            }
            object = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (object == null) break block5;
            try {
                if (((ApplicationInfo)object).metaData != null) {
                    ComServerInformation comServerInformation = new ComServerInformation();
                    object = this.buildClientFrom(comServerInformation.obtainServerInformation(((ApplicationInfo)object).metaData), context);
                    return object;
                }
            }
            catch (Exception exception) {
                this.logger.error(LOG_TAG, String.format(RETRIEVING_APP_META_DATA_ERROR_MESSAGE, exception.getMessage()));
            }
        }
        return this.buildTelemetryClient(Environment.COM, this.certificateBlacklist, context);
    }
}

