/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import com.mapbox.android.telemetry.CertificateBlacklist;
import com.mapbox.android.telemetry.CertificatePinnerFactory;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.GzipRequestInterceptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

class TelemetryClientSettings {
    private static final Map<Environment, String> HOSTS = new HashMap<Environment, String>(){
        {
            this.put(Environment.STAGING, "api-events-staging.tilestream.net");
            this.put(Environment.COM, "events.mapbox.com");
            this.put(Environment.CHINA, "events.mapbox.cn");
        }
    };
    private static final String HTTPS_SCHEME = "https";
    private final HttpUrl baseUrl;
    private final OkHttpClient client;
    private final Context context;
    private boolean debugLoggingEnabled;
    private Environment environment;
    private final HostnameVerifier hostnameVerifier;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager x509TrustManager;

    TelemetryClientSettings(Builder builder) {
        this.context = builder.context;
        this.environment = builder.environment;
        this.client = builder.client;
        this.baseUrl = builder.baseUrl;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.x509TrustManager = builder.x509TrustManager;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.debugLoggingEnabled = builder.debugLoggingEnabled;
    }

    private OkHttpClient configureHttpClient(CertificateBlacklist certificateBlacklist, Interceptor[] interceptorArray) {
        CertificatePinnerFactory certificatePinnerFactory = new CertificatePinnerFactory();
        certificatePinnerFactory = this.client.newBuilder().retryOnConnectionFailure(true).certificatePinner(certificatePinnerFactory.provideCertificatePinnerFor(this.environment, certificateBlacklist));
        certificateBlacklist = ConnectionSpec.MODERN_TLS;
        certificateBlacklist = certificatePinnerFactory.connectionSpecs(Arrays.asList(certificateBlacklist, ConnectionSpec.COMPATIBLE_TLS));
        if (interceptorArray != null) {
            int n = interceptorArray.length;
            for (int i = 0; i < n; ++i) {
                certificateBlacklist.addInterceptor(interceptorArray[i]);
            }
        }
        if (this.isSocketFactoryUnset(this.sslSocketFactory, this.x509TrustManager)) {
            certificateBlacklist.sslSocketFactory(this.sslSocketFactory, this.x509TrustManager);
            certificateBlacklist.hostnameVerifier(this.hostnameVerifier);
        }
        return certificateBlacklist.build();
    }

    static HttpUrl configureUrlHostname(String string2) {
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(HTTPS_SCHEME);
        builder.host(string2);
        return builder.build();
    }

    private boolean isSocketFactoryUnset(SSLSocketFactory sSLSocketFactory, X509TrustManager x509TrustManager) {
        boolean bl = sSLSocketFactory != null && x509TrustManager != null;
        return bl;
    }

    OkHttpClient getAttachmentClient(CertificateBlacklist certificateBlacklist) {
        return this.configureHttpClient(certificateBlacklist, null);
    }

    HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    OkHttpClient getClient(CertificateBlacklist certificateBlacklist, int n) {
        return this.configureHttpClient(certificateBlacklist, new Interceptor[]{new GzipRequestInterceptor()});
    }

    Environment getEnvironment() {
        return this.environment;
    }

    boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }

    Builder toBuilder() {
        return new Builder(this.context).environment(this.environment).client(this.client).baseUrl(this.baseUrl).sslSocketFactory(this.sslSocketFactory).x509TrustManager(this.x509TrustManager).hostnameVerifier(this.hostnameVerifier).debugLoggingEnabled(this.debugLoggingEnabled);
    }

    static final class Builder {
        HttpUrl baseUrl = null;
        OkHttpClient client;
        Context context;
        boolean debugLoggingEnabled = false;
        Environment environment = Environment.COM;
        HostnameVerifier hostnameVerifier = null;
        SSLSocketFactory sslSocketFactory = null;
        X509TrustManager x509TrustManager = null;

        Builder(Context context) {
            this.client = new OkHttpClient();
            this.context = context;
        }

        Builder baseUrl(HttpUrl httpUrl) {
            if (httpUrl != null) {
                this.baseUrl = httpUrl;
            }
            return this;
        }

        TelemetryClientSettings build() {
            if (this.baseUrl == null) {
                this.baseUrl = TelemetryClientSettings.configureUrlHostname((String)HOSTS.get((Object)this.environment));
            }
            return new TelemetryClientSettings(this);
        }

        Builder client(OkHttpClient okHttpClient) {
            if (okHttpClient != null) {
                this.client = okHttpClient;
            }
            return this;
        }

        Builder debugLoggingEnabled(boolean bl) {
            this.debugLoggingEnabled = bl;
            return this;
        }

        Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        Builder sslSocketFactory(SSLSocketFactory sSLSocketFactory) {
            this.sslSocketFactory = sSLSocketFactory;
            return this;
        }

        Builder x509TrustManager(X509TrustManager x509TrustManager) {
            this.x509TrustManager = x509TrustManager;
            return this;
        }
    }
}

