/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

public class TelemetryEnabler {
    private static final String KEY_META_DATA_ENABLED = "com.mapbox.EnableEvents";
    static final String MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE = "mapboxTelemetryState";
    private static final Map<String, State> STATES;
    static final Map<State, Boolean> TELEMETRY_STATES;
    private State currentTelemetryState = State.ENABLED;
    private boolean isFromPreferences = true;

    static {
        TELEMETRY_STATES = new HashMap<State, Boolean>(){
            {
                this.put(State.ENABLED, true);
                this.put(State.DISABLED, false);
            }
        };
        STATES = new HashMap<String, State>(){
            {
                this.put(State.ENABLED.name(), State.ENABLED);
                this.put(State.DISABLED.name(), State.DISABLED);
            }
        };
    }

    TelemetryEnabler(boolean bl) {
        this.isFromPreferences = bl;
    }

    public static boolean isEventsEnabled(Context context) {
        block4: {
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (context == null) break block4;
            try {
                if (context.metaData != null) {
                    boolean bl = context.metaData.getBoolean(KEY_META_DATA_ENABLED, true);
                    return bl;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        return true;
    }

    public static State retrieveTelemetryStateFromPreferences() {
        if (MapboxTelemetry.applicationContext == null) {
            return STATES.get(State.ENABLED.name());
        }
        String string2 = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext).getString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, State.ENABLED.name());
        return STATES.get(string2);
    }

    public static State updateTelemetryState(State state) {
        if (MapboxTelemetry.applicationContext == null) {
            return state;
        }
        SharedPreferences.Editor editor = TelemetryUtils.obtainSharedPreferences(MapboxTelemetry.applicationContext).edit();
        editor.putString(MAPBOX_SHARED_PREFERENCE_KEY_TELEMETRY_STATE, state.name());
        editor.apply();
        return state;
    }

    State obtainTelemetryState() {
        if (this.isFromPreferences) {
            return TelemetryEnabler.retrieveTelemetryStateFromPreferences();
        }
        return this.currentTelemetryState;
    }

    State updatePreferences(State state) {
        if (this.isFromPreferences) {
            return TelemetryEnabler.updateTelemetryState(state);
        }
        this.currentTelemetryState = state;
        return state;
    }

    public static final class State
    extends Enum<State> {
        private static final /* synthetic */ State[] $VALUES;
        public static final /* enum */ State DISABLED;
        public static final /* enum */ State ENABLED;

        static {
            State state;
            State state2;
            ENABLED = state2 = new State();
            DISABLED = state = new State();
            $VALUES = new State[]{state2, state};
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }
    }
}

