/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.errors;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.mapbox.android.core.FileUtils;
import com.mapbox.android.telemetry.CrashEvent;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.TelemetryListener;
import com.mapbox.android.telemetry.errors.ErrorUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class ErrorReporterClient {
    private static final String CRASH_REPORTER_CLIENT_USER_AGENT = "mapbox-android-crash";
    private static final String LOG_TAG = "CrashReporterClient";
    private final HashSet<String> crashHashSet = new HashSet();
    private File[] crashReports;
    private final HashMap<CrashEvent, File> eventFileHashMap = new HashMap();
    private int fileCursor;
    private boolean isDebug;
    private final SharedPreferences sharedPreferences;
    private final MapboxTelemetry telemetry;

    ErrorReporterClient(SharedPreferences sharedPreferences, MapboxTelemetry mapboxTelemetry, File[] fileArray) {
        this.sharedPreferences = sharedPreferences;
        this.telemetry = mapboxTelemetry;
        this.crashReports = fileArray;
        this.fileCursor = 0;
        this.isDebug = false;
    }

    static ErrorReporterClient create(Context context) {
        return new ErrorReporterClient(context.getSharedPreferences("MapboxCrashReporterPrefs", 0), new MapboxTelemetry(context, "", String.format("%s/%s", CRASH_REPORTER_CLIENT_USER_AGENT, "8.1.0-okhttp3")), new File[0]);
    }

    private void setupTelemetryListener(final AtomicBoolean atomicBoolean, final CountDownLatch countDownLatch) {
        this.telemetry.addTelemetryListener(new TelemetryListener(){

            @Override
            public void onHttpFailure(String string2) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Response: ");
                stringBuilder.append(string2);
                Log.d((String)ErrorReporterClient.LOG_TAG, (String)stringBuilder.toString());
                countDownLatch.countDown();
                ErrorReporterClient.this.telemetry.removeTelemetryListener(this);
            }

            @Override
            public void onHttpResponse(boolean bl, int n) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Response: ");
                stringBuilder.append(n);
                Log.d((String)ErrorReporterClient.LOG_TAG, (String)stringBuilder.toString());
                atomicBoolean.set(bl);
                countDownLatch.countDown();
                ErrorReporterClient.this.telemetry.removeTelemetryListener(this);
            }
        });
    }

    ErrorReporterClient debug(boolean bl) {
        this.isDebug = bl;
        return this;
    }

    boolean delete(CrashEvent object) {
        boolean bl = (object = this.eventFileHashMap.get(object)) != null && ((File)object).delete();
        return bl;
    }

    boolean hasNextEvent() {
        boolean bl = this.fileCursor < this.crashReports.length;
        return bl;
    }

    boolean isDuplicate(CrashEvent crashEvent) {
        return this.crashHashSet.contains(crashEvent.getHash());
    }

    boolean isEnabled() {
        try {
            boolean bl = this.sharedPreferences.getBoolean("mapbox.crash.enable", true);
            return bl;
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)exception.toString());
            return false;
        }
    }

    ErrorReporterClient loadFrom(File fileArray) {
        this.fileCursor = 0;
        fileArray = FileUtils.listAllFiles((File)fileArray);
        this.crashReports = fileArray;
        Arrays.sort(fileArray, new FileUtils.LastModifiedComparator());
        return this;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CrashEvent nextEvent() {
        Throwable throwable2222222;
        if (!this.hasNextEvent()) {
            throw new IllegalStateException("No more events can be read");
        }
        File file = this.crashReports[this.fileCursor];
        CrashEvent crashEvent = ErrorUtils.parseJsonCrashEvent(FileUtils.readFromFile(file));
        if (crashEvent.isValid()) {
            this.eventFileHashMap.put(crashEvent, file);
        }
        ++this.fileCursor;
        return crashEvent;
        {
            catch (Throwable throwable2222222) {
            }
            catch (FileNotFoundException fileNotFoundException) {}
            {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("File cannot be read: ");
                stringBuilder.append(fileNotFoundException.toString());
                IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                throw illegalStateException;
            }
        }
        ++this.fileCursor;
        throw throwable2222222;
    }

    boolean send(CrashEvent crashEvent) {
        if (!crashEvent.isValid()) {
            return false;
        }
        return this.sendSync(crashEvent, new AtomicBoolean(this.isDebug), new CountDownLatch(1));
    }

    boolean sendSync(CrashEvent crashEvent, AtomicBoolean atomicBoolean, CountDownLatch countDownLatch) {
        this.setupTelemetryListener(atomicBoolean, countDownLatch);
        this.telemetry.push(crashEvent);
        try {
            countDownLatch.await(10L, TimeUnit.SECONDS);
            return atomicBoolean.get();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        finally {
            if (atomicBoolean.get()) {
                this.crashHashSet.add(crashEvent.getHash());
            }
        }
    }
}

