/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.location;

import com.mapbox.android.telemetry.TelemetryUtils;

public class SessionIdentifier {
    private static final int DEFAULT_ROTATION_HOURS = 24;
    private static final long HOURS_TO_MILLISECONDS = 3600000L;
    private long lastSessionIdUpdate;
    private final long rotationInterval;
    private String sessionId = null;

    public SessionIdentifier() {
        this(86400000L);
    }

    @Deprecated
    public SessionIdentifier(int n) {
        this.rotationInterval = (long)n * 3600000L;
    }

    public SessionIdentifier(long l) {
        this.rotationInterval = l;
    }

    public long getInterval() {
        return this.rotationInterval;
    }

    String getSessionId() {
        if (System.currentTimeMillis() - this.lastSessionIdUpdate >= this.rotationInterval || this.sessionId == null) {
            this.sessionId = TelemetryUtils.obtainUniversalUniqueIdentifier();
            this.lastSessionIdUpdate = System.currentTimeMillis();
        }
        return this.sessionId;
    }
}

