/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics;

import com.mapbox.android.core.metrics.AbstractCompositeMetrics;
import com.mapbox.android.core.metrics.Metrics;
import com.mapbox.android.core.metrics.MetricsImpl;

public class TelemetryMetrics
extends AbstractCompositeMetrics {
    public static final String EVENTS_FAILED = "eventCountFailed";
    public static final String EVENTS_TOTAL = "eventCountTotal";
    static final String MOBILE_BYTES_RX = "cellDataReceived";
    static final String MOBILE_BYTES_TX = "cellDataSent";
    static final String WIFI_BYTES_RX = "wifiDataReceived";
    static final String WIFI_BYTES_TX = "wifiDataSent";

    public TelemetryMetrics(long l) {
        super(l);
    }

    private static boolean isValidNetworkType(int n) {
        boolean bl = n >= 0 && n <= 17;
        return bl;
    }

    public void addRxBytesForType(int n, long l) {
        if (TelemetryMetrics.isValidNetworkType(n)) {
            String string2 = n == 1 ? WIFI_BYTES_RX : MOBILE_BYTES_RX;
            this.add(string2, l);
        }
    }

    public void addTxBytesForType(int n, long l) {
        if (TelemetryMetrics.isValidNetworkType(n)) {
            String string2 = n == 1 ? WIFI_BYTES_TX : MOBILE_BYTES_TX;
            this.add(string2, l);
        }
    }

    @Override
    protected Metrics nextMetrics(long l, long l2) {
        return new MetricsImpl(l, l2);
    }
}

