/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.mapbox.android.telemetry.metrics.TelemetryMetrics;

public class NetworkUsageMetricsCollector {
    private static final int TYPE_NONE = -1;
    private final ConnectivityManager connectivityManager;
    private final TelemetryMetrics metrics;

    public NetworkUsageMetricsCollector(Context context, TelemetryMetrics telemetryMetrics) {
        this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.metrics = telemetryMetrics;
    }

    private int getActiveNetworkType() {
        NetworkInfo networkInfo = this.connectivityManager.getActiveNetworkInfo();
        int n = networkInfo == null ? -1 : networkInfo.getType();
        return n;
    }

    void addRxBytes(long l) {
        this.metrics.addRxBytesForType(this.getActiveNetworkType(), l);
    }

    void addTxBytes(long l) {
        this.metrics.addTxBytesForType(this.getActiveNetworkType(), l);
    }
}

