/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.provider;

import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.util.Log;
import com.mapbox.android.core.crashreporter.MapboxUncaughtExceptionHanlder;
import com.mapbox.android.telemetry.MapboxTelemetryService;
import com.mapbox.android.telemetry.TelemetryEnabler;
import com.mapbox.android.telemetry.errors.TokenChangeBroadcastReceiver;
import com.mapbox.android.telemetry.location.LocationCollectionClient;
import java.util.concurrent.TimeUnit;

public class MapboxTelemetryInitProvider
extends ContentProvider {
    private static final String EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY = "com.mapbox.android.telemetry.provider.mapboxtelemetryinitprovider";
    private static final String TAG = "MbxTelemInitProvider";
    MapboxTelemetryService telemetryService = null;
    private final ServiceConnection telemetryServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName object, IBinder iBinder) {
            if (iBinder instanceof MapboxTelemetryService.Binder) {
                object = (MapboxTelemetryService.Binder)iBinder;
                MapboxTelemetryInitProvider.this.telemetryService = ((MapboxTelemetryService.Binder)((Object)object)).getService();
            } else {
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid type of MapboxTelemetryService.Binder=");
                ((StringBuilder)object).append(iBinder);
                Log.w((String)MapboxTelemetryInitProvider.TAG, (String)((StringBuilder)object).toString());
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            MapboxTelemetryInitProvider.this.telemetryService = null;
        }
    };

    private static void checkContentProviderAuthority(ProviderInfo providerInfo) {
        if (providerInfo != null) {
            if (!EMPTY_APPLICATION_ID_PROVIDER_AUTHORITY.equals(providerInfo.authority)) {
                return;
            }
            throw new IllegalStateException("Incorrect provider authority in manifest. Most likely due to a missing applicationId variable in application's build.gradle.");
        }
        throw new IllegalStateException("MapboxTelemetryInitProvider: ProviderInfo cannot be null.");
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        MapboxTelemetryInitProvider.checkContentProviderAuthority(providerInfo);
        super.attachInfo(context, providerInfo);
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        return 0;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        return null;
    }

    public boolean onCreate() {
        Context context;
        block6: {
            block5: {
                try {
                    context = this.getContext();
                    if (context != null) break block5;
                }
                catch (Throwable throwable) {
                    Log.e((String)TAG, (String)throwable.toString());
                    return false;
                }
                Log.e((String)TAG, (String)"Failed to initialize: context is null");
                return false;
            }
            if (TelemetryEnabler.isEventsEnabled(context)) break block6;
            Log.i((String)TAG, (String)"telemetry is disabled, skip initialization.");
            return false;
        }
        Intent intent = new Intent(context, MapboxTelemetryService.class);
        context.bindService(intent, this.telemetryServiceConnection, 1);
        TokenChangeBroadcastReceiver.register(context);
        MapboxUncaughtExceptionHanlder.install(context, "com.mapbox.android.telemetry", "8.1.0-okhttp3");
        LocationCollectionClient.install(context, TimeUnit.HOURS.toMillis(24L));
        return true;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return null;
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return 0;
    }
}

