/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5;

import com.mapbox.api.directions.v5.MapboxDirections;
import com.mapbox.api.directions.v5.models.DirectionsResponse;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.api.directions.v5.models.RouteOptions;
import com.mapbox.api.directions.v5.utils.ParseUtils;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;
import retrofit2.Response;

class DirectionsResponseFactory {
    private final MapboxDirections mapboxDirections;

    DirectionsResponseFactory(MapboxDirections mapboxDirections) {
        this.mapboxDirections = mapboxDirections;
    }

    private List<DirectionsRoute> generateRouteOptions(Response<DirectionsResponse> response) {
        Object object = ((DirectionsResponse)response.body()).routes();
        ArrayList<DirectionsRoute> arrayList = new ArrayList<DirectionsRoute>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(((DirectionsRoute)object.next()).toBuilder().routeOptions(RouteOptions.builder().profile(this.mapboxDirections.profile()).coordinates(this.mapboxDirections.coordinates()).waypointIndicesList(ParseUtils.parseToIntegers(this.mapboxDirections.waypointIndices())).waypointNamesList(ParseUtils.parseToStrings(this.mapboxDirections.waypointNames())).waypointTargetsList(ParseUtils.parseToPoints(this.mapboxDirections.waypointTargets())).continueStraight(this.mapboxDirections.continueStraight()).annotationsList(ParseUtils.parseToStrings(this.mapboxDirections.annotation())).approachesList(ParseUtils.parseToStrings(this.mapboxDirections.approaches())).bearingsList(ParseUtils.parseToListOfListOfDoubles(this.mapboxDirections.bearing())).alternatives(this.mapboxDirections.alternatives()).language(this.mapboxDirections.language()).radiusesList(ParseUtils.parseToDoubles(this.mapboxDirections.radius())).user(this.mapboxDirections.user()).voiceInstructions(this.mapboxDirections.voiceInstructions()).bannerInstructions(this.mapboxDirections.bannerInstructions()).roundaboutExits(this.mapboxDirections.roundaboutExits()).geometries(this.mapboxDirections.geometries()).overview(this.mapboxDirections.overview()).steps(this.mapboxDirections.steps()).exclude(this.mapboxDirections.exclude()).voiceUnits(this.mapboxDirections.voiceUnits()).accessToken(this.mapboxDirections.accessToken()).requestUuid(((DirectionsResponse)response.body()).uuid()).baseUrl(this.mapboxDirections.baseUrl()).walkingOptions(this.mapboxDirections.walkingOptions()).build()).build());
        }
        return arrayList;
    }

    private boolean isNotSuccessful(Response<DirectionsResponse> response) {
        boolean bl = !response.isSuccessful() || response.body() == null || ((DirectionsResponse)response.body()).routes().isEmpty();
        return bl;
    }

    Response<DirectionsResponse> generate(Response<DirectionsResponse> response) {
        if (this.isNotSuccessful(response)) {
            return response;
        }
        return Response.success((Object)((DirectionsResponse)response.body()).toBuilder().routes(this.generateRouteOptions(response)).build(), (okhttp3.Response)new Response.Builder().code(200).message("OK").protocol(response.raw().protocol()).headers(response.headers()).request(response.raw().request()).build());
    }
}

