/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.models.;
import com.mapbox.api.directions.v5.models.AutoValue_StepManeuver;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.geojson.Point;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class StepManeuver
extends DirectionsJsonObject {
    public static final String ARRIVE = "arrive";
    public static final String CONTINUE = "continue";
    public static final String DEPART = "depart";
    public static final String END_OF_ROAD = "end of road";
    public static final String EXIT_ROTARY = "exit rotary";
    public static final String EXIT_ROUNDABOUT = "exit roundabout";
    public static final String FORK = "fork";
    public static final String MERGE = "merge";
    public static final String NEW_NAME = "new name";
    public static final String NOTIFICATION = "notification";
    public static final String OFF_RAMP = "off ramp";
    public static final String ON_RAMP = "on ramp";
    public static final String ROTARY = "rotary";
    public static final String ROUNDABOUT = "roundabout";
    public static final String ROUNDABOUT_TURN = "roundabout turn";
    public static final String TURN = "turn";

    public static Builder builder() {
        return new .AutoValue_StepManeuver.Builder();
    }

    public static StepManeuver fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, StepManeuver.class);
    }

    public static TypeAdapter<StepManeuver> typeAdapter(Gson gson) {
        return new AutoValue_StepManeuver.GsonTypeAdapter(gson);
    }

    @SerializedName(value="bearing_after")
    public abstract Double bearingAfter();

    @SerializedName(value="bearing_before")
    public abstract Double bearingBefore();

    public abstract Integer exit();

    public abstract String instruction();

    public Point location() {
        return Point.fromLngLat(this.rawLocation()[0], this.rawLocation()[1]);
    }

    public abstract String modifier();

    @SerializedName(value="location")
    protected abstract double[] rawLocation();

    public abstract Builder toBuilder();

    public abstract String type();

    public static abstract class Builder {
        public abstract Builder bearingAfter(Double var1);

        public abstract Builder bearingBefore(Double var1);

        public abstract StepManeuver build();

        public abstract Builder exit(Integer var1);

        public abstract Builder instruction(String var1);

        public abstract Builder modifier(String var1);

        public abstract Builder rawLocation(double[] var1);

        public abstract Builder type(String var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StepManeuverType {
    }
}

