/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.utils;

import com.mapbox.geojson.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FormatUtils {
    public static String formatApproaches(List<String> list) {
        if (list != null && !list.isEmpty()) {
            for (String string2 : list) {
                if (string2 == null || string2.equals("unrestricted") || string2.equals("curb") || string2.isEmpty()) continue;
                return null;
            }
            return FormatUtils.join(";", list);
        }
        return null;
    }

    public static String formatBearings(List<List<Double>> object) {
        if (object != null && !object.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (List)object.next();
                if (object2 == null) {
                    arrayList.add(null);
                    continue;
                }
                if (object2.size() == 2) {
                    Double d = (Double)object2.get(0);
                    object2 = (Double)object2.get(1);
                    if (d != null && object2 != null) {
                        if (!(d < 0.0 || d > 360.0 || (Double)object2 < 0.0 || (Double)object2 > 360.0)) {
                            arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(d), FormatUtils.formatCoordinate((Double)object2)));
                            continue;
                        }
                        throw new RuntimeException("Angle and tolerance have to be from 0 to 360.");
                    }
                    arrayList.add(null);
                    continue;
                }
                throw new RuntimeException("Bearing size should be 2.");
            }
            return FormatUtils.join(";", arrayList);
        }
        return null;
    }

    public static String formatCoordinate(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
        return String.format(Locale.US, "%s", decimalFormat.format(d));
    }

    public static String formatCoordinates(List<Point> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Point> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(((Point)object).longitude()), FormatUtils.formatCoordinate(((Point)object).latitude())));
        }
        return FormatUtils.join(";", arrayList);
    }

    public static String formatDistributions(List<Integer[]> object) {
        if (object != null && !object.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Integer[] integerArray = (Integer[])object.next();
                if (integerArray.length == 0) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(integerArray[0].intValue()), FormatUtils.formatCoordinate(integerArray[1].intValue())));
            }
            return FormatUtils.join(";", arrayList);
        }
        return null;
    }

    public static String formatPointsList(List<Point> object) {
        if (object != null && !object.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<Point> iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (object == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(((Point)object).longitude()), FormatUtils.formatCoordinate(((Point)object).latitude())));
            }
            return FormatUtils.join(";", arrayList);
        }
        return null;
    }

    public static String formatRadiuses(List<Double> object) {
        if (object != null && object.size() != 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            object = object.iterator();
            while (object.hasNext()) {
                Double d = (Double)object.next();
                if (d == null) {
                    arrayList.add(null);
                    continue;
                }
                if (d == Double.POSITIVE_INFINITY) {
                    arrayList.add("unlimited");
                    continue;
                }
                arrayList.add(String.format(Locale.US, "%s", FormatUtils.formatCoordinate(d)));
            }
            return FormatUtils.join(";", arrayList);
        }
        return null;
    }

    public static String formatWaypointNames(List<String> list) {
        if (list != null && !list.isEmpty()) {
            return FormatUtils.join(";", list);
        }
        return null;
    }

    public static String join(CharSequence charSequence, List<?> list) {
        return FormatUtils.join(charSequence, list, false);
    }

    public static String join(CharSequence charSequence, List<?> list, boolean bl) {
        if (list != null) {
            int n = list.size();
            int n2 = 1;
            if (n >= 1) {
                int n3;
                int n4 = n = list.size() - 1;
                if (bl) {
                    n3 = list.size() - 1;
                    while (true) {
                        n4 = n--;
                        if (n3 < 0) break;
                        if (list.get(n3) != null) {
                            n4 = n;
                            break;
                        }
                        --n3;
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                n3 = n2;
                for (n = 0; n <= n4; ++n) {
                    if (n3 != 0) {
                        n3 = 0;
                    } else {
                        stringBuilder.append(charSequence);
                    }
                    Object obj = list.get(n);
                    if (obj == null) continue;
                    stringBuilder.append(obj);
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }
}

