/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.utils;

import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParseUtils {
    private static final String COMMA = ",";
    private static final String SEMICOLON = ";";
    private static final String UNLIMITED = "unlimited";

    public static List<Double> parseToDoubles(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (String string2 : stringArray.split(SEMICOLON, -1)) {
            if (string2 == null) continue;
            if (string2.isEmpty()) {
                arrayList.add(null);
                continue;
            }
            if (string2.equals(UNLIMITED)) {
                arrayList.add(Double.POSITIVE_INFINITY);
                continue;
            }
            arrayList.add(Double.valueOf(string2));
        }
        return arrayList;
    }

    public static List<Integer> parseToIntegers(String string22) {
        if (string22 == null) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string22 : string22.split(SEMICOLON)) {
            if (string22 == null) continue;
            if (string22.isEmpty()) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(Integer.valueOf(string22));
        }
        return arrayList;
    }

    public static List<List<Double>> parseToListOfListOfDoubles(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<List<Double>> arrayList = new ArrayList<List<Double>>();
        for (String string2 : stringArray.split(SEMICOLON, -1)) {
            if (string2.isEmpty()) {
                arrayList.add(null);
                continue;
            }
            String[] stringArray2 = string2.split(COMMA);
            if (stringArray2.length != 2) continue;
            arrayList.add(Arrays.asList(Double.valueOf(stringArray2[0]), Double.valueOf(stringArray2[1])));
        }
        return arrayList;
    }

    public static List<Point> parseToPoints(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (String string2 : stringArray.split(SEMICOLON, -1)) {
            if (string2 == null) continue;
            if (string2.isEmpty()) {
                arrayList.add(null);
                continue;
            }
            String[] stringArray2 = string2.split(COMMA);
            arrayList.add(Point.fromLngLat(Double.valueOf(stringArray2[0]), Double.valueOf(stringArray2[1])));
        }
        return arrayList;
    }

    public static List<String> parseToStrings(String string2) {
        return ParseUtils.parseToStrings(string2, SEMICOLON);
    }

    public static List<String> parseToStrings(String stringArray, String string22) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string22 : stringArray.split(string22, -1)) {
            if (string22 == null) continue;
            if (string22.isEmpty()) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(string22);
        }
        return arrayList;
    }
}

