/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.routetiles.v1;

import com.mapbox.api.routetiles.v1.AutoValue_MapboxRouteTiles;
import com.mapbox.api.routetiles.v1.RouteTilesService;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.geojson.BoundingBox;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;

public abstract class MapboxRouteTiles
extends MapboxService<ResponseBody, RouteTilesService> {
    protected MapboxRouteTiles() {
        super(RouteTilesService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxRouteTiles.Builder().baseUrl("https://api.mapbox.com");
    }

    private String formatBoundingBox(BoundingBox boundingBox) {
        return String.format(Locale.US, "%f,%f;%f,%f", boundingBox.west(), boundingBox.south(), boundingBox.east(), boundingBox.north());
    }

    abstract String accessToken();

    @Override
    protected abstract String baseUrl();

    abstract BoundingBox boundingBox();

    abstract String clientAppName();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected OkHttpClient getOkHttpClient() {
        synchronized (this) {
            HttpLoggingInterceptor httpLoggingInterceptor;
            if (this.okHttpClient != null) return this.okHttpClient;
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.isEnableDebug()) {
                httpLoggingInterceptor = new HttpLoggingInterceptor();
                httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                builder.addInterceptor((Interceptor)httpLoggingInterceptor);
            }
            if ((httpLoggingInterceptor = this.interceptor()) != null) {
                builder.addInterceptor((Interceptor)httpLoggingInterceptor);
            }
            if ((httpLoggingInterceptor = this.networkInterceptor()) != null) {
                builder.addNetworkInterceptor((Interceptor)httpLoggingInterceptor);
            }
            this.okHttpClient = builder.build();
            return this.okHttpClient;
        }
    }

    @Override
    protected Call<ResponseBody> initializeCall() {
        return ((RouteTilesService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent(this.clientAppName()), this.formatBoundingBox(this.boundingBox()), this.version(), this.accessToken());
    }

    abstract Interceptor interceptor();

    abstract Interceptor networkInterceptor();

    public abstract Builder toBuilder();

    abstract String version();

    public static abstract class Builder {
        public abstract Builder accessToken(String var1);

        abstract MapboxRouteTiles autoBuild();

        public abstract Builder baseUrl(String var1);

        public abstract Builder boundingBox(BoundingBox var1);

        public MapboxRouteTiles build() {
            MapboxRouteTiles mapboxRouteTiles = this.autoBuild();
            if (MapboxUtils.isAccessTokenValid(mapboxRouteTiles.accessToken())) {
                return mapboxRouteTiles;
            }
            throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
        }

        public abstract Builder clientAppName(String var1);

        public abstract Builder interceptor(Interceptor var1);

        public abstract Builder networkInterceptor(Interceptor var1);

        public abstract Builder version(String var1);
    }
}

