/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.speech.v1;

import com.mapbox.api.speech.v1.AutoValue_MapboxSpeech;
import com.mapbox.api.speech.v1.SpeechService;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.TextUtils;
import java.util.logging.Logger;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;

public abstract class MapboxSpeech
extends MapboxService<ResponseBody, SpeechService> {
    private static final Logger LOGGER = Logger.getLogger(MapboxSpeech.class.getName());

    protected MapboxSpeech() {
        super(SpeechService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxSpeech.Builder().baseUrl("https://api.mapbox.com");
    }

    abstract String accessToken();

    @Override
    protected abstract String baseUrl();

    abstract Cache cache();

    @Override
    public OkHttpClient getOkHttpClient() {
        synchronized (this) {
            OkHttpClient.Builder builder;
            if (this.okHttpClient == null) {
                builder = new OkHttpClient.Builder();
                if (this.isEnableDebug()) {
                    HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
                    httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                    builder.addInterceptor((Interceptor)httpLoggingInterceptor);
                }
                if (this.cache() != null) {
                    builder.cache(this.cache());
                }
                if (this.interceptor() != null) {
                    builder.addInterceptor(this.interceptor());
                }
                if (this.networkInterceptor() != null) {
                    builder.addNetworkInterceptor(this.networkInterceptor());
                }
                this.okHttpClient = builder.build();
            }
            builder = this.okHttpClient;
            return builder;
        }
    }

    @Override
    protected Call<ResponseBody> initializeCall() {
        return ((SpeechService)this.getService()).getCall(this.instruction(), this.textType(), this.language(), this.outputType(), this.accessToken());
    }

    abstract String instruction();

    abstract Interceptor interceptor();

    abstract String language();

    abstract Interceptor networkInterceptor();

    abstract String outputType();

    abstract String textType();

    public static abstract class Builder {
        public abstract Builder accessToken(String var1);

        abstract MapboxSpeech autoBuild();

        public abstract Builder baseUrl(String var1);

        public MapboxSpeech build() {
            MapboxSpeech mapboxSpeech = this.autoBuild();
            if (!TextUtils.isEmpty(mapboxSpeech.instruction())) {
                return mapboxSpeech;
            }
            throw new ServicesException("Non-null, non-empty instruction text is required.");
        }

        public abstract Builder cache(Cache var1);

        public abstract Builder instruction(String var1);

        public abstract Builder interceptor(Interceptor var1);

        public abstract Builder language(String var1);

        public abstract Builder networkInterceptor(Interceptor var1);

        public abstract Builder outputType(String var1);

        public abstract Builder textType(String var1);
    }
}

