/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.staticmap.v1;

import com.mapbox.api.staticmap.v1.AutoValue_MapboxStaticMap;
import com.mapbox.api.staticmap.v1.models.StaticMarkerAnnotation;
import com.mapbox.api.staticmap.v1.models.StaticPolylineAnnotation;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import okhttp3.HttpUrl;

public abstract class MapboxStaticMap {
    private static final String BEFORE_LAYER = "before_layer";
    private static final String CAMERA_AUTO = "auto";

    public static Builder builder() {
        return new AutoValue_MapboxStaticMap.Builder().styleId("streets-v11").baseUrl("https://api.mapbox.com").user("mapbox").cameraPoint(Point.fromLngLat(0.0, 0.0)).cameraAuto(false).attribution(true).width(250).logo(true).attribution(true).retina(true).height(250).cameraZoom(0.0).cameraPitch(0.0).cameraBearing(0.0).precision(0).retina(false);
    }

    private String generateLocationPathSegment() {
        if (this.precision() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(TextUtils.formatCoordinate(this.cameraPoint().longitude(), this.precision()));
            arrayList.add(TextUtils.formatCoordinate(this.cameraPoint().latitude(), this.precision()));
            arrayList.add(TextUtils.formatCoordinate(this.cameraZoom(), this.precision()));
            arrayList.add(TextUtils.formatCoordinate(this.cameraBearing(), this.precision()));
            arrayList.add(TextUtils.formatCoordinate(this.cameraPitch(), this.precision()));
            return TextUtils.join(",", arrayList.toArray());
        }
        return String.format(Locale.US, "%f,%f,%f,%f,%f", this.cameraPoint().longitude(), this.cameraPoint().latitude(), this.cameraZoom(), this.cameraBearing(), this.cameraPitch());
    }

    private String generateSizePathSegment() {
        Locale locale = Locale.US;
        int n = this.width();
        int n2 = this.height();
        String string2 = this.retina() ? "@2x" : "";
        return String.format(locale, "%dx%d%s", n, n2, string2);
    }

    abstract String accessToken();

    abstract boolean attribution();

    abstract String baseUrl();

    abstract String beforeLayer();

    abstract boolean cameraAuto();

    abstract double cameraBearing();

    abstract double cameraPitch();

    abstract Point cameraPoint();

    abstract double cameraZoom();

    abstract GeoJson geoJson();

    abstract int height();

    abstract boolean logo();

    abstract int precision();

    abstract boolean retina();

    abstract List<StaticMarkerAnnotation> staticMarkerAnnotations();

    abstract List<StaticPolylineAnnotation> staticPolylineAnnotations();

    abstract String styleId();

    public HttpUrl url() {
        String[] stringArray;
        HttpUrl.Builder builder = HttpUrl.parse((String)this.baseUrl()).newBuilder().addPathSegment("styles").addPathSegment("v1").addPathSegment(this.user()).addPathSegment(this.styleId()).addPathSegment("static").addQueryParameter("access_token", this.accessToken());
        Object object = new ArrayList<String>();
        if (this.staticMarkerAnnotations() != null) {
            stringArray = new ArrayList(this.staticMarkerAnnotations().size());
            Iterator<StaticMarkerAnnotation> object2 = this.staticMarkerAnnotations().iterator();
            while (object2.hasNext()) {
                stringArray.add(object2.next().url());
            }
            object.addAll(stringArray);
        }
        if (this.staticPolylineAnnotations() != null) {
            stringArray = new String[this.staticPolylineAnnotations().size()];
            for (StaticPolylineAnnotation staticPolylineAnnotation : this.staticPolylineAnnotations()) {
                stringArray[this.staticPolylineAnnotations().indexOf((Object)staticPolylineAnnotation)] = staticPolylineAnnotation.url();
            }
            object.addAll(Arrays.asList(stringArray));
        }
        if (this.geoJson() != null) {
            object.add(String.format(Locale.US, "geojson(%s)", this.geoJson().toJson()));
        }
        if (!object.isEmpty()) {
            builder.addPathSegment(TextUtils.join(",", object.toArray()));
        }
        object = this.cameraAuto() ? CAMERA_AUTO : this.generateLocationPathSegment();
        builder.addPathSegment((String)object);
        if (this.beforeLayer() != null) {
            builder.addQueryParameter(BEFORE_LAYER, this.beforeLayer());
        }
        if (!this.attribution()) {
            builder.addQueryParameter("attribution", "false");
        }
        if (!this.logo()) {
            builder.addQueryParameter("logo", "false");
        }
        builder.addPathSegment(this.generateSizePathSegment());
        return builder.build();
    }

    abstract String user();

    abstract int width();

    public static abstract class Builder {
        public abstract Builder accessToken(String var1);

        public abstract Builder attribution(boolean var1);

        abstract MapboxStaticMap autoBuild();

        public abstract Builder baseUrl(String var1);

        public abstract Builder beforeLayer(String var1);

        public MapboxStaticMap build() {
            MapboxStaticMap mapboxStaticMap = this.autoBuild();
            if (MapboxUtils.isAccessTokenValid(mapboxStaticMap.accessToken())) {
                if (!mapboxStaticMap.styleId().isEmpty()) {
                    return mapboxStaticMap;
                }
                throw new ServicesException("You need to set a map style.");
            }
            throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
        }

        public abstract Builder cameraAuto(boolean var1);

        public abstract Builder cameraBearing(double var1);

        public abstract Builder cameraPitch(double var1);

        public abstract Builder cameraPoint(Point var1);

        public abstract Builder cameraZoom(double var1);

        public abstract Builder geoJson(GeoJson var1);

        public abstract Builder height(int var1);

        public abstract Builder logo(boolean var1);

        public abstract Builder precision(int var1);

        public abstract Builder retina(boolean var1);

        public abstract Builder staticMarkerAnnotations(List<StaticMarkerAnnotation> var1);

        public abstract Builder staticPolylineAnnotations(List<StaticPolylineAnnotation> var1);

        public abstract Builder styleId(String var1);

        public abstract Builder user(String var1);

        public abstract Builder width(int var1);
    }
}

