/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.staticmap.v1.models;

import com.mapbox.api.staticmap.v1.models.AutoValue_StaticMarkerAnnotation;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ColorUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.util.Locale;

public abstract class StaticMarkerAnnotation {
    public static Builder builder() {
        return new AutoValue_StaticMarkerAnnotation.Builder().name("pin-m");
    }

    abstract String color();

    abstract String iconUrl();

    abstract String label();

    abstract Point lnglat();

    abstract String name();

    public abstract Builder toBuilder();

    public String url() {
        if (this.iconUrl() != null) {
            return String.format(Locale.US, "url-%s(%f,%f)", this.iconUrl(), this.lnglat().longitude(), this.lnglat().latitude());
        }
        String string2 = this.color() != null && !TextUtils.isEmpty(this.label()) ? String.format(Locale.US, "%s-%s+%s", this.name(), this.label(), this.color()) : (!TextUtils.isEmpty(this.label()) ? String.format(Locale.US, "%s-%s", this.name(), this.label()) : (this.color() != null ? String.format(Locale.US, "%s+%s", this.name(), this.color()) : this.name()));
        return String.format(Locale.US, "%s(%f,%f)", string2, this.lnglat().longitude(), this.lnglat().latitude());
    }

    public static abstract class Builder {
        abstract StaticMarkerAnnotation autoBuild();

        public StaticMarkerAnnotation build() {
            StaticMarkerAnnotation staticMarkerAnnotation = this.autoBuild();
            if (staticMarkerAnnotation.lnglat() != null) {
                return staticMarkerAnnotation;
            }
            throw new ServicesException("A Static map marker requires a defined longitude and latitude coordinate.");
        }

        public Builder color(int n, int n2, int n3) {
            return this.color(ColorUtils.toHexString(n, n2, n3));
        }

        public abstract Builder color(String var1);

        public abstract Builder iconUrl(String var1);

        public abstract Builder label(String var1);

        public abstract Builder lnglat(Point var1);

        public abstract Builder name(String var1);
    }
}

