/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.tilequery;

import com.google.gson.GsonBuilder;
import com.mapbox.api.tilequery.AutoValue_MapboxTilequery;
import com.mapbox.api.tilequery.TilequeryService;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxTilequery
extends MapboxService<FeatureCollection, TilequeryService> {
    private Call<List<FeatureCollection>> batchCall;

    protected MapboxTilequery() {
        super(TilequeryService.class);
    }

    public static Builder builder() {
        return new AutoValue_MapboxTilequery.Builder().baseUrl("https://api.mapbox.com");
    }

    private Call<List<FeatureCollection>> getBatchCall() {
        Call<List<FeatureCollection>> call = this.batchCall;
        if (call != null) {
            return call;
        }
        this.batchCall = call = ((TilequeryService)this.getService()).getBatchCall(this.tilesetIds(), this.query(), this.accessToken(), this.radius(), this.limit(), this.dedupe(), this.geometry(), this.layers());
        return call;
    }

    abstract String accessToken();

    @Override
    protected abstract String baseUrl();

    public void cancelBatchCall() {
        this.getBatchCall().cancel();
    }

    public Call<List<FeatureCollection>> cloneBatchCall() {
        return this.getBatchCall().clone();
    }

    abstract Boolean dedupe();

    public void enqueueBatchCall(Callback<List<FeatureCollection>> callback) {
        this.getBatchCall().enqueue(callback);
    }

    public Response<List<FeatureCollection>> executeBatchCall() throws IOException {
        return this.getBatchCall().execute();
    }

    abstract String geometry();

    @Override
    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create());
    }

    @Override
    protected Call<FeatureCollection> initializeCall() {
        return ((TilequeryService)this.getService()).getCall(this.tilesetIds(), this.query(), this.accessToken(), this.radius(), this.limit(), this.dedupe(), this.geometry(), this.layers());
    }

    abstract String layers();

    abstract Integer limit();

    abstract String query();

    abstract Integer radius();

    abstract String tilesetIds();

    public static abstract class Builder {
        public abstract Builder accessToken(String var1);

        abstract MapboxTilequery autoBuild();

        public abstract Builder baseUrl(String var1);

        public MapboxTilequery build() {
            MapboxTilequery mapboxTilequery = this.autoBuild();
            if (MapboxUtils.isAccessTokenValid(mapboxTilequery.accessToken())) {
                if (!mapboxTilequery.query().isEmpty()) {
                    return mapboxTilequery;
                }
                throw new ServicesException("A query with latitude and longitude values is required.");
            }
            throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
        }

        public abstract Builder dedupe(Boolean var1);

        public abstract Builder geometry(String var1);

        public abstract Builder layers(String var1);

        public abstract Builder limit(Integer var1);

        public Builder query(Point point) {
            this.query(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(point.longitude()), TextUtils.formatCoordinate(point.latitude())));
            String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(point.longitude()), TextUtils.formatCoordinate(point.latitude()));
            return this;
        }

        public abstract Builder query(String var1);

        public abstract Builder radius(Integer var1);

        public abstract Builder tilesetIds(String var1);
    }
}

