/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class MapboxService<T, S> {
    protected static final int MAX_URL_SIZE = 8192;
    private Call<T> call;
    private Call.Factory callFactory;
    private boolean enableDebug;
    protected OkHttpClient okHttpClient;
    private Retrofit retrofit;
    private S service;
    private final Class<S> serviceType;

    public MapboxService(Class<S> clazz) {
        this.serviceType = clazz;
    }

    protected abstract String baseUrl();

    public void cancelCall() {
        this.getCall().cancel();
    }

    public Call<T> cloneCall() {
        return this.getCall().clone();
    }

    public void enableDebug(boolean bl) {
        this.enableDebug = bl;
    }

    public void enqueueCall(Callback<T> callback) {
        this.getCall().enqueue(callback);
    }

    public Response<T> executeCall() throws IOException {
        return this.getCall().execute();
    }

    protected Call<T> getCall() {
        if (this.call == null) {
            this.call = this.initializeCall();
        }
        return this.call;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder();
    }

    protected OkHttpClient getOkHttpClient() {
        synchronized (this) {
            OkHttpClient okHttpClient;
            if (this.okHttpClient == null) {
                if (this.isEnableDebug()) {
                    okHttpClient = new HttpLoggingInterceptor();
                    okHttpClient.setLevel(HttpLoggingInterceptor.Level.BASIC);
                    OkHttpClient.Builder builder = new OkHttpClient.Builder();
                    builder.addInterceptor((Interceptor)okHttpClient);
                    this.okHttpClient = builder.build();
                } else {
                    this.okHttpClient = okHttpClient = new OkHttpClient();
                }
            }
            okHttpClient = this.okHttpClient;
            return okHttpClient;
        }
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    protected S getService() {
        Object object = this.service;
        if (object != null) {
            return object;
        }
        object = new Retrofit.Builder().baseUrl(this.baseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
        if (this.getCallFactory() != null) {
            object.callFactory(this.getCallFactory());
        } else {
            object.client(this.getOkHttpClient());
        }
        object = object.build();
        this.retrofit = object;
        this.service = object = object.create(this.serviceType);
        return object;
    }

    protected abstract Call<T> initializeCall();

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setCallFactory(Call.Factory factory) {
        this.callFactory = factory;
    }
}

