/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.core.utils;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public final class TextUtils {
    private TextUtils() {
    }

    @Deprecated
    public static String formatApproaches(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "";
                continue;
            }
            if (stringArray[i].equals("unrestricted") || stringArray[i].equals("curb") || stringArray[i].isEmpty()) continue;
            return null;
        }
        return TextUtils.join(";", stringArray);
    }

    @Deprecated
    public static String formatBearing(List<Double[]> list) {
        if (list.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get(i).length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(list.get(i)[0]), TextUtils.formatCoordinate(list.get(i)[1]));
        }
        return TextUtils.join(";", objectArray);
    }

    public static String formatCoordinate(double d) {
        DecimalFormat decimalFormat = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
        return String.format(Locale.US, "%s", decimalFormat.format(d));
    }

    public static String formatCoordinate(double d, int n) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("0.");
        charSequence.append(new String(new char[n]).replace("\u0000", "0"));
        charSequence = charSequence.toString();
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        decimalFormat.applyPattern((String)charSequence);
        decimalFormat.setRoundingMode(RoundingMode.FLOOR);
        return decimalFormat.format(d);
    }

    @Deprecated
    public static String formatDistributions(List<Integer[]> list) {
        if (list.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get(i).length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate(list.get(i)[0].intValue()), TextUtils.formatCoordinate(list.get(i)[1].intValue()));
        }
        return TextUtils.join(";", objectArray);
    }

    @Deprecated
    public static String formatRadiuses(double[] dArray) {
        if (dArray != null && dArray.length != 0) {
            Object[] objectArray = new String[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                objectArray[i] = dArray[i] == Double.POSITIVE_INFINITY ? "unlimited" : String.format(Locale.US, "%s", TextUtils.formatCoordinate(dArray[i]));
            }
            return TextUtils.join(";", objectArray);
        }
        return null;
    }

    @Deprecated
    public static String formatWaypointNames(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            stringArray[i] = "";
        }
        return TextUtils.join(";", stringArray);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        boolean bl = charSequence == null || charSequence.length() == 0;
        return bl;
    }

    public static String join(CharSequence charSequence, Object[] objectArray) {
        if (objectArray != null) {
            int n = objectArray.length;
            boolean bl = true;
            if (n >= 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object : objectArray) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(charSequence);
                    }
                    stringBuilder.append(object);
                }
                return stringBuilder.toString();
            }
        }
        return null;
    }
}

