/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import com.mapbox.geojson.utils.GeoJsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class BaseCoordinatesTypeAdapter<T>
extends TypeAdapter<T> {
    BaseCoordinatesTypeAdapter() {
    }

    protected Point readPoint(JsonReader object) throws IOException {
        if ((object = this.readPointList((JsonReader)object)) != null && object.size() > 1) {
            return new Point("Point", null, (List<Double>)object);
        }
        throw new GeoJsonException(" Point coordinates should be non-null double array");
    }

    protected List<Double> readPointList(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() != JsonToken.NULL) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                arrayList.add(jsonReader.nextDouble());
            }
            jsonReader.endArray();
            if (arrayList.size() > 2) {
                return CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt((Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2));
            }
            return CoordinateShifterManager.getCoordinateShifter().shiftLonLat((Double)arrayList.get(0), (Double)arrayList.get(1));
        }
        throw null;
    }

    protected void writePoint(JsonWriter jsonWriter, Point point) throws IOException {
        if (point == null) {
            return;
        }
        this.writePointList(jsonWriter, (List<Double>)point.coordinates());
    }

    protected void writePointList(JsonWriter jsonWriter, List<Double> list) throws IOException {
        if (list == null) {
            return;
        }
        jsonWriter.beginArray();
        List<Double> list2 = CoordinateShifterManager.getCoordinateShifter().unshiftPoint(list);
        jsonWriter.value(GeoJsonUtils.trim(list2.get(0)));
        jsonWriter.value(GeoJsonUtils.trim(list2.get(1)));
        if (list.size() > 2) {
            jsonWriter.value(list2.get(2));
        }
        jsonWriter.endArray();
    }
}

