/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Objects;

public class BoundingBox
implements Serializable {
    private final Point northeast;
    private final Point southwest;

    BoundingBox(Point point, Point point2) {
        Objects.requireNonNull(point, "Null southwest");
        this.southwest = point;
        Objects.requireNonNull(point2, "Null northeast");
        this.northeast = point2;
    }

    @Deprecated
    public static BoundingBox fromCoordinates(double d, double d2, double d3, double d4) {
        return BoundingBox.fromLngLats(d, d2, d3, d4);
    }

    @Deprecated
    public static BoundingBox fromCoordinates(double d, double d2, double d3, double d4, double d5, double d6) {
        return BoundingBox.fromLngLats(d, d2, d3, d4, d5, d6);
    }

    public static BoundingBox fromJson(String string2) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)BoundingBox.class), new BoundingBoxTypeAdapter()).create().fromJson(string2, BoundingBox.class);
    }

    public static BoundingBox fromLngLats(double d, double d2, double d3, double d4) {
        return new BoundingBox(Point.fromLngLat(d, d2), Point.fromLngLat(d3, d4));
    }

    public static BoundingBox fromLngLats(double d, double d2, double d3, double d4, double d5, double d6) {
        return new BoundingBox(Point.fromLngLat(d, d2, d3), Point.fromLngLat(d4, d5, d6));
    }

    public static BoundingBox fromPoints(Point point, Point point2) {
        return new BoundingBox(point, point2);
    }

    public static TypeAdapter<BoundingBox> typeAdapter(Gson gson) {
        return new BoundingBoxTypeAdapter();
    }

    public final double east() {
        return this.northeast().longitude();
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof BoundingBox) {
            if (!this.southwest.equals(((BoundingBox)(object = (BoundingBox)object)).southwest()) || !this.northeast.equals(((BoundingBox)object).northeast())) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return (this.southwest.hashCode() ^ 0xF4243) * 1000003 ^ this.northeast.hashCode();
    }

    public final double north() {
        return this.northeast().latitude();
    }

    public Point northeast() {
        return this.northeast;
    }

    public final double south() {
        return this.southwest().latitude();
    }

    public Point southwest() {
        return this.southwest;
    }

    public final String toJson() {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)BoundingBox.class), new BoundingBoxTypeAdapter()).create().toJson((Object)this, (Type)((Object)BoundingBox.class));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BoundingBox{southwest=");
        stringBuilder.append(this.southwest);
        stringBuilder.append(", northeast=");
        stringBuilder.append(this.northeast);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public final double west() {
        return this.southwest().longitude();
    }
}

