/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class GeometryCollection
implements Geometry {
    private static final String TYPE = "GeometryCollection";
    private final BoundingBox bbox;
    private final List<Geometry> geometries;
    private final String type;

    GeometryCollection(String string2, BoundingBox boundingBox, List<Geometry> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        Objects.requireNonNull(list, "Null geometries");
        this.geometries = list;
    }

    public static GeometryCollection fromGeometries(List<Geometry> list) {
        return new GeometryCollection(TYPE, null, list);
    }

    public static GeometryCollection fromGeometries(List<Geometry> list, BoundingBox boundingBox) {
        return new GeometryCollection(TYPE, boundingBox, list);
    }

    public static GeometryCollection fromGeometry(Geometry geometry) {
        return new GeometryCollection(TYPE, null, Arrays.asList(geometry));
    }

    public static GeometryCollection fromGeometry(Geometry geometry, BoundingBox boundingBox) {
        return new GeometryCollection(TYPE, boundingBox, Arrays.asList(geometry));
    }

    public static GeometryCollection fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gsonBuilder.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, GeometryCollection.class);
    }

    public static TypeAdapter<GeometryCollection> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof GeometryCollection) {
            BoundingBox boundingBox;
            if (!(this.type.equals(((GeometryCollection)(object = (GeometryCollection)object)).type()) && ((boundingBox = this.bbox) == null ? ((GeometryCollection)object).bbox() == null : boundingBox.equals(((GeometryCollection)object).bbox())) && this.geometries.equals(((GeometryCollection)object).geometries()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public List<Geometry> geometries() {
        return this.geometries;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.geometries.hashCode();
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gsonBuilder.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeometryCollection{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", geometries=");
        stringBuilder.append(this.geometries);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<GeometryCollection> {
        private volatile TypeAdapter<BoundingBox> boundingBoxTypeAdapter;
        private final Gson gson;
        private volatile TypeAdapter<List<Geometry>> listGeometryAdapter;
        private volatile TypeAdapter<String> stringTypeAdapter;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        @Override
        public GeometryCollection read(JsonReader object) throws IOException {
            Object object2 = ((JsonReader)object).peek();
            Object object3 = JsonToken.NULL;
            Object object4 = null;
            if (object2 == object3) {
                ((JsonReader)object).nextNull();
                return null;
            }
            ((JsonReader)object).beginObject();
            object2 = object3 = null;
            block10: while (((JsonReader)object).hasNext()) {
                TypeAdapter<Object> typeAdapter = ((JsonReader)object).nextName();
                if (((JsonReader)object).peek() == JsonToken.NULL) {
                    ((JsonReader)object).nextNull();
                    continue;
                }
                ((String)((Object)typeAdapter)).hashCode();
                int n = -1;
                switch (((String)((Object)typeAdapter)).hashCode()) {
                    default: {
                        break;
                    }
                    case 203916432: {
                        if (!((String)((Object)typeAdapter)).equals("geometries")) break;
                        n = 2;
                        break;
                    }
                    case 3575610: {
                        if (!((String)((Object)typeAdapter)).equals("type")) break;
                        n = 1;
                        break;
                    }
                    case 3017257: {
                        if (!((String)((Object)typeAdapter)).equals("bbox")) break;
                        n = 0;
                    }
                }
                switch (n) {
                    default: {
                        ((JsonReader)object).skipValue();
                        continue block10;
                    }
                    case 2: {
                        typeAdapter = this.listGeometryAdapter;
                        object2 = typeAdapter;
                        if (typeAdapter == null) {
                            object2 = TypeToken.getParameterized(List.class, new Type[]{Geometry.class});
                            this.listGeometryAdapter = object2 = this.gson.getAdapter(object2);
                        }
                        object2 = (List)((TypeAdapter)object2).read((JsonReader)object);
                        continue block10;
                    }
                    case 1: {
                        typeAdapter = this.stringTypeAdapter;
                        object4 = typeAdapter;
                        if (typeAdapter == null) {
                            this.stringTypeAdapter = object4 = this.gson.getAdapter(String.class);
                        }
                        object4 = (String)((TypeAdapter)object4).read((JsonReader)object);
                        continue block10;
                    }
                    case 0: 
                }
                typeAdapter = this.boundingBoxTypeAdapter;
                object3 = typeAdapter;
                if (typeAdapter == null) {
                    this.boundingBoxTypeAdapter = object3 = this.gson.getAdapter(BoundingBox.class);
                }
                object3 = (BoundingBox)((TypeAdapter)object3).read((JsonReader)object);
            }
            ((JsonReader)object).endObject();
            object = object4;
            if (object4 == null) {
                object = GeometryCollection.TYPE;
            }
            return new GeometryCollection((String)object, (BoundingBox)object3, (List<Geometry>)object2);
        }

        @Override
        public void write(JsonWriter jsonWriter, GeometryCollection geometryCollection) throws IOException {
            TypeAdapter typeAdapter;
            TypeAdapter<Object> typeAdapter2;
            if (geometryCollection == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (geometryCollection.type() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.stringTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(String.class);
                    this.stringTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, (String)geometryCollection.type());
            }
            jsonWriter.name("bbox");
            if (geometryCollection.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.boundingBoxTypeAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = this.gson.getAdapter(BoundingBox.class);
                    this.boundingBoxTypeAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, (String)((Object)geometryCollection.bbox()));
            }
            jsonWriter.name("geometries");
            if (geometryCollection.geometries() == null) {
                jsonWriter.nullValue();
            } else {
                typeAdapter2 = this.listGeometryAdapter;
                typeAdapter = typeAdapter2;
                if (typeAdapter2 == null) {
                    typeAdapter = TypeToken.getParameterized(List.class, new Type[]{Geometry.class});
                    typeAdapter = this.gson.getAdapter(typeAdapter);
                    this.listGeometryAdapter = typeAdapter;
                }
                typeAdapter.write(jsonWriter, geometryCollection.geometries());
            }
            jsonWriter.endObject();
        }
    }
}

