/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class ListOfPointCoordinatesTypeAdapter
extends BaseCoordinatesTypeAdapter<List<Point>> {
    ListOfPointCoordinatesTypeAdapter() {
    }

    @Override
    public List<Point> read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() != JsonToken.NULL) {
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                jsonReader.beginArray();
                while (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                    arrayList.add(this.readPoint(jsonReader));
                }
                jsonReader.endArray();
                return arrayList;
            }
            throw new GeoJsonException("coordinates should be non-null array of array of double");
        }
        throw null;
    }

    @Override
    public void write(JsonWriter jsonWriter, List<Point> object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginArray();
        object = object.iterator();
        while (object.hasNext()) {
            this.writePoint(jsonWriter, (Point)object.next());
        }
        jsonWriter.endArray();
    }
}

