/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.ListOfListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class MultiLineString
implements CoordinateContainer<List<List<Point>>> {
    private static final String TYPE = "MultiLineString";
    private final BoundingBox bbox;
    private final List<List<Point>> coordinates;
    private final String type;

    MultiLineString(String string2, BoundingBox boundingBox, List<List<Point>> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        Objects.requireNonNull(list, "Null coordinates");
        this.coordinates = list;
    }

    public static MultiLineString fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, MultiLineString.class);
    }

    public static MultiLineString fromLineString(LineString lineString) {
        return new MultiLineString(TYPE, null, Arrays.asList(lineString.coordinates()));
    }

    public static MultiLineString fromLineString(LineString lineString, BoundingBox boundingBox) {
        return new MultiLineString(TYPE, boundingBox, Arrays.asList(lineString.coordinates()));
    }

    public static MultiLineString fromLineStrings(List<LineString> object) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((List<Point>)((LineString)object.next()).coordinates());
        }
        return new MultiLineString(TYPE, null, arrayList);
    }

    public static MultiLineString fromLineStrings(List<LineString> object, BoundingBox boundingBox) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((List<Point>)((LineString)object.next()).coordinates());
        }
        return new MultiLineString(TYPE, boundingBox, arrayList);
    }

    public static MultiLineString fromLngLats(List<List<Point>> list) {
        return new MultiLineString(TYPE, null, list);
    }

    public static MultiLineString fromLngLats(List<List<Point>> list, BoundingBox boundingBox) {
        return new MultiLineString(TYPE, boundingBox, list);
    }

    static MultiLineString fromLngLats(double[][][] dArray) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            ArrayList<Point> arrayList2 = new ArrayList<Point>(dArray[i].length);
            for (int j = 0; j < dArray[i].length; ++j) {
                arrayList2.add(Point.fromLngLat(dArray[i][j]));
            }
            arrayList.add(arrayList2);
        }
        return new MultiLineString(TYPE, null, arrayList);
    }

    public static TypeAdapter<MultiLineString> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    public List<List<Point>> coordinates() {
        return this.coordinates;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof MultiLineString) {
            BoundingBox boundingBox;
            if (!(this.type.equals(((MultiLineString)(object = (MultiLineString)object)).type()) && ((boundingBox = this.bbox) == null ? ((MultiLineString)object).bbox() == null : boundingBox.equals(((MultiLineString)object).bbox())) && this.coordinates.equals(((MultiLineString)object).coordinates()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.coordinates.hashCode();
    }

    public List<LineString> lineStrings() {
        Iterator iterator2 = this.coordinates();
        ArrayList<LineString> arrayList = new ArrayList<LineString>(iterator2.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(LineString.fromLngLats((List)iterator2.next()));
        }
        return arrayList;
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultiLineString{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", coordinates=");
        stringBuilder.append(this.coordinates);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiLineString, List<List<Point>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfListOfPointCoordinatesTypeAdapter());
        }

        @Override
        CoordinateContainer<List<List<Point>>> createCoordinateContainer(String string2, BoundingBox boundingBox, List<List<Point>> list) {
            String string3 = string2;
            if (string2 == null) {
                string3 = MultiLineString.TYPE;
            }
            return new MultiLineString(string3, boundingBox, list);
        }

        @Override
        public MultiLineString read(JsonReader jsonReader) throws IOException {
            return (MultiLineString)this.readCoordinateContainer(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, MultiLineString multiLineString) throws IOException {
            this.writeCoordinateContainer(jsonWriter, multiLineString);
        }
    }
}

