/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MultiPoint
implements CoordinateContainer<List<Point>> {
    private static final String TYPE = "MultiPoint";
    private final BoundingBox bbox;
    private final List<Point> coordinates;
    private final String type;

    MultiPoint(String string2, BoundingBox boundingBox, List<Point> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        Objects.requireNonNull(list, "Null coordinates");
        this.coordinates = list;
    }

    public static MultiPoint fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, MultiPoint.class);
    }

    public static MultiPoint fromLngLats(List<Point> list) {
        return new MultiPoint(TYPE, null, list);
    }

    public static MultiPoint fromLngLats(List<Point> list, BoundingBox boundingBox) {
        return new MultiPoint(TYPE, boundingBox, list);
    }

    static MultiPoint fromLngLats(double[][] dArray) {
        ArrayList<Point> arrayList = new ArrayList<Point>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(Point.fromLngLat(dArray[i]));
        }
        return new MultiPoint(TYPE, null, arrayList);
    }

    public static TypeAdapter<MultiPoint> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    public List<Point> coordinates() {
        return this.coordinates;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof MultiPoint) {
            BoundingBox boundingBox;
            if (!(this.type.equals(((MultiPoint)(object = (MultiPoint)object)).type()) && ((boundingBox = this.bbox) == null ? ((MultiPoint)object).bbox() == null : boundingBox.equals(((MultiPoint)object).bbox())) && this.coordinates.equals(((MultiPoint)object).coordinates()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.coordinates.hashCode();
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("MultiPoint{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", coordinates=");
        stringBuilder.append(this.coordinates);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiPoint, List<Point>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfPointCoordinatesTypeAdapter());
        }

        @Override
        CoordinateContainer<List<Point>> createCoordinateContainer(String string2, BoundingBox boundingBox, List<Point> list) {
            String string3 = string2;
            if (string2 == null) {
                string3 = MultiPoint.TYPE;
            }
            return new MultiPoint(string3, boundingBox, list);
        }

        @Override
        public MultiPoint read(JsonReader jsonReader) throws IOException {
            return (MultiPoint)this.readCoordinateContainer(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, MultiPoint multiPoint) throws IOException {
            this.writeCoordinateContainer(jsonWriter, multiPoint);
        }
    }
}

