/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListofListofListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class MultiPolygon
implements CoordinateContainer<List<List<List<Point>>>> {
    private static final String TYPE = "MultiPolygon";
    private final BoundingBox bbox;
    private final List<List<List<Point>>> coordinates;
    private final String type;

    MultiPolygon(String string2, BoundingBox boundingBox, List<List<List<Point>>> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        Objects.requireNonNull(list, "Null coordinates");
        this.coordinates = list;
    }

    public static MultiPolygon fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, MultiPolygon.class);
    }

    public static MultiPolygon fromLngLats(List<List<List<Point>>> list) {
        return new MultiPolygon(TYPE, null, list);
    }

    public static MultiPolygon fromLngLats(List<List<List<Point>>> list, BoundingBox boundingBox) {
        return new MultiPolygon(TYPE, boundingBox, list);
    }

    static MultiPolygon fromLngLats(double[][][][] dArray) {
        ArrayList<List<List<Point>>> arrayList = new ArrayList<List<List<Point>>>(dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            ArrayList arrayList2 = new ArrayList(dArray[i].length);
            for (int j = 0; j < dArray[i].length; ++j) {
                ArrayList<Point> arrayList3 = new ArrayList<Point>(dArray[i][j].length);
                for (int k = 0; k < dArray[i][j].length; ++k) {
                    arrayList3.add(Point.fromLngLat(dArray[i][j][k]));
                }
                arrayList2.add(arrayList3);
            }
            arrayList.add(arrayList2);
        }
        return new MultiPolygon(TYPE, null, arrayList);
    }

    public static MultiPolygon fromPolygon(Polygon polygon) {
        return new MultiPolygon(TYPE, null, Arrays.asList(polygon.coordinates()));
    }

    public static MultiPolygon fromPolygon(Polygon polygon, BoundingBox boundingBox) {
        return new MultiPolygon(TYPE, boundingBox, Arrays.asList(polygon.coordinates()));
    }

    public static MultiPolygon fromPolygons(List<Polygon> object) {
        ArrayList<List<List<Point>>> arrayList = new ArrayList<List<List<Point>>>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((List<List<Point>>)((Polygon)object.next()).coordinates());
        }
        return new MultiPolygon(TYPE, null, arrayList);
    }

    public static MultiPolygon fromPolygons(List<Polygon> object, BoundingBox boundingBox) {
        ArrayList<List<List<Point>>> arrayList = new ArrayList<List<List<Point>>>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add((List<List<Point>>)((Polygon)object.next()).coordinates());
        }
        return new MultiPolygon(TYPE, boundingBox, arrayList);
    }

    public static TypeAdapter<MultiPolygon> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    public List<List<List<Point>>> coordinates() {
        return this.coordinates;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)object;
            if (!(this.type.equals(multiPolygon.type()) && ((object = this.bbox) == null ? multiPolygon.bbox() == null : ((BoundingBox)object).equals(multiPolygon.bbox())) && this.coordinates.equals(multiPolygon.coordinates()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.coordinates.hashCode();
    }

    public List<Polygon> polygons() {
        Iterator iterator2 = this.coordinates();
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>(iterator2.size());
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(Polygon.fromLngLats((List)iterator2.next()));
        }
        return arrayList;
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Polygon{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", coordinates=");
        stringBuilder.append(this.coordinates);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiPolygon, List<List<List<Point>>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListofListofListOfPointCoordinatesTypeAdapter());
        }

        @Override
        CoordinateContainer<List<List<List<Point>>>> createCoordinateContainer(String string2, BoundingBox boundingBox, List<List<List<Point>>> list) {
            String string3 = string2;
            if (string2 == null) {
                string3 = MultiPolygon.TYPE;
            }
            return new MultiPolygon(string3, boundingBox, list);
        }

        @Override
        public MultiPolygon read(JsonReader jsonReader) throws IOException {
            return (MultiPolygon)this.readCoordinateContainer(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, MultiPolygon multiPolygon) throws IOException {
            this.writeCoordinateContainer(jsonWriter, multiPolygon);
        }
    }
}

