/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListOfDoublesCoordinatesTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import com.mapbox.geojson.shifter.CoordinateShifterManager;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class Point
implements CoordinateContainer<List<Double>> {
    private static final String TYPE = "Point";
    private final BoundingBox bbox;
    private final List<Double> coordinates;
    private final String type;

    Point(String string2, BoundingBox boundingBox, List<Double> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        if (list != null && list.size() != 0) {
            this.coordinates = list;
            return;
        }
        throw new NullPointerException("Null coordinates");
    }

    public static Point fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, Point.class);
    }

    public static Point fromLngLat(double d, double d2) {
        return new Point(TYPE, null, CoordinateShifterManager.getCoordinateShifter().shiftLonLat(d, d2));
    }

    public static Point fromLngLat(double d, double d2, double d3) {
        return new Point(TYPE, null, CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt(d, d2, d3));
    }

    public static Point fromLngLat(double d, double d2, double d3, BoundingBox boundingBox) {
        return new Point(TYPE, boundingBox, CoordinateShifterManager.getCoordinateShifter().shiftLonLatAlt(d, d2, d3));
    }

    public static Point fromLngLat(double d, double d2, BoundingBox boundingBox) {
        return new Point(TYPE, boundingBox, CoordinateShifterManager.getCoordinateShifter().shiftLonLat(d, d2));
    }

    static Point fromLngLat(double[] dArray) {
        if (dArray.length == 2) {
            return Point.fromLngLat(dArray[0], dArray[1]);
        }
        if (dArray.length > 2) {
            return Point.fromLngLat(dArray[0], dArray[1], dArray[2]);
        }
        return null;
    }

    public static TypeAdapter<Point> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public double altitude() {
        if (this.coordinates().size() < 3) {
            return Double.NaN;
        }
        return (Double)this.coordinates().get(2);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    public List<Double> coordinates() {
        return this.coordinates;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof Point) {
            BoundingBox boundingBox;
            if (!(this.type.equals(((Point)(object = (Point)object)).type()) && ((boundingBox = this.bbox) == null ? ((Point)object).bbox() == null : boundingBox.equals(((Point)object).bbox())) && this.coordinates.equals(((Point)object).coordinates()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public boolean hasAltitude() {
        return Double.isNaN(this.altitude()) ^ true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.coordinates.hashCode();
    }

    public double latitude() {
        return (Double)this.coordinates().get(1);
    }

    public double longitude() {
        return (Double)this.coordinates().get(0);
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Point{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", coordinates=");
        stringBuilder.append(this.coordinates);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<Point, List<Double>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfDoublesCoordinatesTypeAdapter());
        }

        @Override
        CoordinateContainer<List<Double>> createCoordinateContainer(String string2, BoundingBox boundingBox, List<Double> list) {
            String string3 = string2;
            if (string2 == null) {
                string3 = Point.TYPE;
            }
            return new Point(string3, boundingBox, list);
        }

        @Override
        public Point read(JsonReader jsonReader) throws IOException {
            return (Point)this.readCoordinateContainer(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, Point point) throws IOException {
            this.writeCoordinateContainer(jsonWriter, point);
        }
    }
}

