/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.ListOfListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Polygon
implements CoordinateContainer<List<List<Point>>> {
    private static final String TYPE = "Polygon";
    private final BoundingBox bbox;
    private final List<List<Point>> coordinates;
    private final String type;

    Polygon(String string2, BoundingBox boundingBox, List<List<Point>> list) {
        Objects.requireNonNull(string2, "Null type");
        this.type = string2;
        this.bbox = boundingBox;
        Objects.requireNonNull(list, "Null coordinates");
        this.coordinates = list;
    }

    public static Polygon fromJson(String string2) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().fromJson(string2, Polygon.class);
    }

    public static Polygon fromLngLats(List<List<Point>> list) {
        return new Polygon(TYPE, null, list);
    }

    public static Polygon fromLngLats(List<List<Point>> list, BoundingBox boundingBox) {
        return new Polygon(TYPE, boundingBox, list);
    }

    static Polygon fromLngLats(double[][][] dArray) {
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>(dArray.length);
        for (double[][] dArray2 : dArray) {
            ArrayList<Point> arrayList2 = new ArrayList<Point>(dArray2.length);
            int n = dArray2.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(Point.fromLngLat(dArray2[i]));
            }
            arrayList.add(arrayList2);
        }
        return new Polygon(TYPE, null, arrayList);
    }

    public static Polygon fromOuterInner(LineString object, BoundingBox boundingBox, List<LineString> object2) {
        Polygon.isLinearRing((LineString)object);
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        arrayList.add((List<Point>)((LineString)object).coordinates());
        if (object2 == null) {
            return new Polygon(TYPE, boundingBox, arrayList);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (LineString)object.next();
            Polygon.isLinearRing((LineString)object2);
            arrayList.add((List<Point>)((LineString)object2).coordinates());
        }
        return new Polygon(TYPE, boundingBox, arrayList);
    }

    public static Polygon fromOuterInner(LineString lineString2, BoundingBox boundingBox, LineString ... lineStringArray) {
        Polygon.isLinearRing(lineString2);
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        arrayList.add((List<Point>)lineString2.coordinates());
        if (lineStringArray == null) {
            return new Polygon(TYPE, boundingBox, arrayList);
        }
        for (LineString lineString2 : lineStringArray) {
            Polygon.isLinearRing(lineString2);
            arrayList.add((List<Point>)lineString2.coordinates());
        }
        return new Polygon(TYPE, boundingBox, arrayList);
    }

    public static Polygon fromOuterInner(LineString lineString, List<LineString> object) {
        Polygon.isLinearRing(lineString);
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        arrayList.add((List<Point>)lineString.coordinates());
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                lineString = (LineString)object.next();
                Polygon.isLinearRing(lineString);
                arrayList.add((List<Point>)lineString.coordinates());
            }
            return new Polygon(TYPE, null, arrayList);
        }
        return new Polygon(TYPE, null, arrayList);
    }

    public static Polygon fromOuterInner(LineString lineString2, LineString ... lineStringArray) {
        Polygon.isLinearRing(lineString2);
        ArrayList<List<Point>> arrayList = new ArrayList<List<Point>>();
        arrayList.add((List<Point>)lineString2.coordinates());
        if (lineStringArray == null) {
            return new Polygon(TYPE, null, arrayList);
        }
        for (LineString lineString2 : lineStringArray) {
            Polygon.isLinearRing(lineString2);
            arrayList.add((List<Point>)lineString2.coordinates());
        }
        return new Polygon(TYPE, null, arrayList);
    }

    private static boolean isLinearRing(LineString lineString) {
        if (lineString.coordinates().size() >= 4) {
            if (((Point)lineString.coordinates().get(0)).equals(lineString.coordinates().get(lineString.coordinates().size() - 1))) {
                return true;
            }
            throw new GeoJsonException("LinearRings require first and last coordinate to be identical.");
        }
        throw new GeoJsonException("LinearRings need to be made up of 4 or more coordinates.");
    }

    public static TypeAdapter<Polygon> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    @Override
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    public List<List<Point>> coordinates() {
        return this.coordinates;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object instanceof Polygon) {
            Polygon polygon = (Polygon)object;
            if (!(this.type.equals(polygon.type()) && ((object = this.bbox) == null ? polygon.bbox() == null : ((BoundingBox)object).equals(polygon.bbox())) && this.coordinates.equals(polygon.coordinates()))) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        BoundingBox boundingBox = this.bbox;
        int n2 = boundingBox == null ? 0 : boundingBox.hashCode();
        return ((n ^ 0xF4243) * 1000003 ^ n2) * 1000003 ^ this.coordinates.hashCode();
    }

    public List<LineString> inner() {
        Iterator iterator2 = this.coordinates();
        if (iterator2.size() <= 1) {
            return new ArrayList<LineString>(0);
        }
        ArrayList<LineString> arrayList = new ArrayList<LineString>(iterator2.size() - 1);
        iterator2 = iterator2.subList(1, iterator2.size()).iterator();
        while (iterator2.hasNext()) {
            arrayList.add(LineString.fromLngLats((List)iterator2.next()));
        }
        return arrayList;
    }

    public LineString outer() {
        return LineString.fromLngLats((List)this.coordinates().get(0));
    }

    @Override
    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gsonBuilder.create().toJson(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Polygon{type=");
        stringBuilder.append(this.type);
        stringBuilder.append(", bbox=");
        stringBuilder.append(this.bbox);
        stringBuilder.append(", coordinates=");
        stringBuilder.append(this.coordinates);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String type() {
        return this.type;
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<Polygon, List<List<Point>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfListOfPointCoordinatesTypeAdapter());
        }

        @Override
        CoordinateContainer<List<List<Point>>> createCoordinateContainer(String string2, BoundingBox boundingBox, List<List<Point>> list) {
            String string3 = string2;
            if (string2 == null) {
                string3 = Polygon.TYPE;
            }
            return new Polygon(string3, boundingBox, list);
        }

        @Override
        public Polygon read(JsonReader jsonReader) throws IOException {
            return (Polygon)this.readCoordinateContainer(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, Polygon polygon) throws IOException {
            this.writeCoordinateContainer(jsonWriter, polygon);
        }
    }
}

