/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson.internal.typeadapters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RuntimeTypeAdapterFactory<T>
implements TypeAdapterFactory {
    private final Class<?> baseType;
    private final Map<String, Class<?>> labelToSubtype = new LinkedHashMap();
    private final boolean maintainType;
    private final Map<Class<?>, String> subtypeToLabel = new LinkedHashMap();
    private final String typeFieldName;

    private RuntimeTypeAdapterFactory(Class<?> clazz, String string2, boolean bl) {
        if (string2 != null && clazz != null) {
            this.baseType = clazz;
            this.typeFieldName = string2;
            this.maintainType = bl;
            return;
        }
        throw null;
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> clazz) {
        return new RuntimeTypeAdapterFactory<T>(clazz, "type", false);
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> clazz, String string2) {
        return new RuntimeTypeAdapterFactory<T>(clazz, string2, false);
    }

    public static <T> RuntimeTypeAdapterFactory<T> of(Class<T> clazz, String string2, boolean bl) {
        return new RuntimeTypeAdapterFactory<T>(clazz, string2, bl);
    }

    public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> object) {
        if (((TypeToken)object).getRawType() != this.baseType) {
            return null;
        }
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        object = new LinkedHashMap();
        for (Map.Entry<String, Class<?>> entry : this.labelToSubtype.entrySet()) {
            TypeAdapter<?> typeAdapter = gson.getDelegateAdapter(this, TypeToken.get(entry.getValue()));
            linkedHashMap.put(entry.getKey(), typeAdapter);
            object.put(entry.getValue(), typeAdapter);
        }
        return new TypeAdapter<R>((Map)object){
            final /* synthetic */ Map val$subtypeToDelegate;
            {
                this.val$subtypeToDelegate = map2;
            }

            @Override
            public R read(JsonReader object) throws IOException {
                Object object2 = Streams.parse((JsonReader)object);
                object = RuntimeTypeAdapterFactory.this.maintainType ? ((JsonElement)object2).getAsJsonObject().get(RuntimeTypeAdapterFactory.this.typeFieldName) : ((JsonElement)object2).getAsJsonObject().remove(RuntimeTypeAdapterFactory.this.typeFieldName);
                if (object != null) {
                    TypeAdapter typeAdapter = (TypeAdapter)linkedHashMap.get(object = ((JsonElement)object).getAsString());
                    if (typeAdapter != null) {
                        return typeAdapter.fromJsonTree((JsonElement)object2);
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("cannot deserialize ");
                    ((StringBuilder)object2).append(RuntimeTypeAdapterFactory.this.baseType);
                    ((StringBuilder)object2).append(" subtype named ");
                    ((StringBuilder)object2).append((String)object);
                    ((StringBuilder)object2).append("; did you forget to register a subtype?");
                    throw new JsonParseException(((StringBuilder)object2).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("cannot deserialize ");
                ((StringBuilder)object).append(RuntimeTypeAdapterFactory.this.baseType);
                ((StringBuilder)object).append(" because it does not define a field named ");
                ((StringBuilder)object).append(RuntimeTypeAdapterFactory.this.typeFieldName);
                throw new JsonParseException(((StringBuilder)object).toString());
            }

            @Override
            public void write(JsonWriter object, R object2) throws IOException {
                Object object3 = object2.getClass();
                TypeAdapter object42 = (TypeAdapter)this.val$subtypeToDelegate.get(object3);
                if (object42 != null) {
                    JsonObject jsonObject = object42.toJsonTree(object2).getAsJsonObject();
                    if (RuntimeTypeAdapterFactory.this.maintainType) {
                        Streams.write(jsonObject, (JsonWriter)object);
                        return;
                    }
                    object2 = new JsonObject();
                    if (!jsonObject.has(RuntimeTypeAdapterFactory.this.typeFieldName)) {
                        object3 = (String)RuntimeTypeAdapterFactory.this.subtypeToLabel.get(object3);
                        ((JsonObject)object2).add(RuntimeTypeAdapterFactory.this.typeFieldName, new JsonPrimitive((String)object3));
                        for (Map.Entry<String, JsonElement> entry : jsonObject.entrySet()) {
                            ((JsonObject)object2).add(entry.getKey(), entry.getValue());
                        }
                        Streams.write((JsonElement)object2, (JsonWriter)object);
                        return;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("cannot serialize ");
                    ((StringBuilder)object).append(((Class)object3).getName());
                    ((StringBuilder)object).append(" because it already defines a field named ");
                    ((StringBuilder)object).append(RuntimeTypeAdapterFactory.this.typeFieldName);
                    throw new JsonParseException(((StringBuilder)object).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("cannot serialize ");
                ((StringBuilder)object).append(((Class)object3).getName());
                ((StringBuilder)object).append("; did you forget to register a subtype?");
                throw new JsonParseException(((StringBuilder)object).toString());
            }
        }.nullSafe();
    }

    public RuntimeTypeAdapterFactory<T> registerSubtype(Class<? extends T> clazz) {
        return this.registerSubtype(clazz, clazz.getSimpleName());
    }

    public RuntimeTypeAdapterFactory<T> registerSubtype(Class<? extends T> clazz, String string2) {
        if (clazz != null && string2 != null) {
            if (!this.subtypeToLabel.containsKey(clazz) && !this.labelToSubtype.containsKey(string2)) {
                this.labelToSubtype.put(string2, clazz);
                this.subtypeToLabel.put(clazz, string2);
                return this;
            }
            throw new IllegalArgumentException("types and labels must be unique");
        }
        throw null;
    }
}

