/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import com.mapbox.mapboxsdk.annotations.ArrowDirection;

@Deprecated
class Bubble
extends Drawable {
    private float arrowHeight;
    private float arrowPosition;
    private float arrowWidth;
    private float cornersRadius;
    private Paint paint = new Paint(1);
    private Path path = new Path();
    private RectF rect;
    private Paint strokePaint;
    private Path strokePath;
    private float strokeWidth;

    Bubble(RectF rectF, ArrowDirection arrowDirection, float f, float f2, float f3, float f4, int n, float f5, int n2) {
        this.rect = rectF;
        this.arrowWidth = f;
        this.arrowHeight = f2;
        this.arrowPosition = f3;
        this.cornersRadius = f4;
        this.paint.setColor(n);
        this.strokeWidth = f5;
        if (f5 > 0.0f) {
            rectF = new Paint(1);
            this.strokePaint = rectF;
            rectF.setColor(n2);
            this.strokePath = new Path();
            this.initPath(arrowDirection, this.path, f5);
            this.initPath(arrowDirection, this.strokePath, 0.0f);
        } else {
            this.initPath(arrowDirection, this.path, 0.0f);
        }
    }

    private void initBottomRoundedPath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + this.cornersRadius + f, rectF.top + f);
        path.lineTo(rectF.width() - this.cornersRadius - f, rectF.top + f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.top + f, rectF.right - f, this.cornersRadius + rectF.top), 270.0f, 90.0f);
        path.lineTo(rectF.right - f, rectF.bottom - this.arrowHeight - this.cornersRadius - f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.bottom - this.cornersRadius - this.arrowHeight, rectF.right - f, rectF.bottom - this.arrowHeight - f), 0.0f, 90.0f);
        float f2 = rectF.left;
        float f3 = this.arrowWidth;
        float f4 = this.arrowPosition;
        float f5 = f / 2.0f;
        path.lineTo(f2 + f3 + f4 - f5, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + this.arrowPosition + this.arrowWidth / 2.0f, rectF.bottom - f - f);
        path.lineTo(rectF.left + this.arrowPosition + f5, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + Math.min(this.cornersRadius, this.arrowPosition) + f, rectF.bottom - this.arrowHeight - f);
        f3 = rectF.left;
        f4 = rectF.bottom;
        f2 = this.cornersRadius;
        path.arcTo(new RectF(f3 + f, f4 - f2 - this.arrowHeight, f2 + rectF.left, rectF.bottom - this.arrowHeight - f), 90.0f, 90.0f);
        path.lineTo(rectF.left + f, rectF.top + this.cornersRadius + f);
        path.arcTo(new RectF(rectF.left + f, rectF.top + f, this.cornersRadius + rectF.left, this.cornersRadius + rectF.top), 180.0f, 90.0f);
        path.close();
    }

    private void initBottomSquarePath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + f, rectF.top + f);
        path.lineTo(rectF.right - f, rectF.top + f);
        path.lineTo(rectF.right - f, rectF.bottom - this.arrowHeight - f);
        float f2 = rectF.left;
        float f3 = this.arrowWidth;
        float f4 = this.arrowPosition;
        float f5 = f / 2.0f;
        path.lineTo(f2 + f3 + f4 - f5, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + this.arrowPosition + this.arrowWidth / 2.0f, rectF.bottom - f - f);
        path.lineTo(rectF.left + this.arrowPosition + f5, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + this.arrowPosition + f, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + f, rectF.bottom - this.arrowHeight - f);
        path.lineTo(rectF.left + f, rectF.top + f);
        path.close();
    }

    private void initLeftRoundedPath(RectF rectF, Path path, float f) {
        path.moveTo(this.arrowWidth + rectF.left + this.cornersRadius + f, rectF.top + f);
        path.lineTo(rectF.width() - this.cornersRadius - f, rectF.top + f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.top + f, rectF.right - f, this.cornersRadius + rectF.top), 270.0f, 90.0f);
        path.lineTo(rectF.right - f, rectF.bottom - this.cornersRadius - f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.bottom - this.cornersRadius, rectF.right - f, rectF.bottom - f), 0.0f, 90.0f);
        path.lineTo(rectF.left + this.arrowWidth + this.cornersRadius + f, rectF.bottom - f);
        float f2 = rectF.left;
        float f3 = this.arrowWidth;
        float f4 = rectF.bottom;
        float f5 = this.cornersRadius;
        path.arcTo(new RectF(f2 + f3 + f, f4 - f5, f5 + rectF.left + this.arrowWidth, rectF.bottom - f), 90.0f, 90.0f);
        f5 = rectF.left;
        f3 = this.arrowWidth;
        f4 = this.arrowHeight;
        float f6 = this.arrowPosition;
        f2 = f / 2.0f;
        path.lineTo(f5 + f3 + f, f4 + f6 - f2);
        path.lineTo(rectF.left + f + f, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rectF.left + this.arrowWidth + f, this.arrowPosition + f2);
        path.lineTo(rectF.left + this.arrowWidth + f, rectF.top + this.cornersRadius + f);
        path.arcTo(new RectF(rectF.left + this.arrowWidth + f, rectF.top + f, this.cornersRadius + rectF.left + this.arrowWidth, this.cornersRadius + rectF.top), 180.0f, 90.0f);
        path.close();
    }

    private void initLeftSquarePath(RectF rectF, Path path, float f) {
        path.moveTo(this.arrowWidth + rectF.left + f, rectF.top + f);
        path.lineTo(rectF.width() - f, rectF.top + f);
        path.lineTo(rectF.right - f, rectF.bottom - f);
        path.lineTo(rectF.left + this.arrowWidth + f, rectF.bottom - f);
        float f2 = rectF.left;
        float f3 = this.arrowWidth;
        float f4 = this.arrowHeight;
        float f5 = this.arrowPosition;
        float f6 = f / 2.0f;
        path.lineTo(f2 + f3 + f, f4 + f5 - f6);
        path.lineTo(rectF.left + f + f, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rectF.left + this.arrowWidth + f, this.arrowPosition + f6);
        path.lineTo(rectF.left + this.arrowWidth + f, rectF.top + f);
        path.close();
    }

    private void initPath(ArrowDirection arrowDirection, Path path, float f) {
        int n = arrowDirection.getValue();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        float f2 = this.cornersRadius;
                        if (f2 <= 0.0f) {
                            this.initBottomSquarePath(this.rect, path, f);
                        } else if (f > 0.0f && f > f2) {
                            this.initBottomSquarePath(this.rect, path, f);
                        } else {
                            this.initBottomRoundedPath(this.rect, path, f);
                        }
                    }
                } else {
                    float f3 = this.cornersRadius;
                    if (f3 <= 0.0f) {
                        this.initTopSquarePath(this.rect, path, f);
                    } else if (f > 0.0f && f > f3) {
                        this.initTopSquarePath(this.rect, path, f);
                    } else {
                        this.initTopRoundedPath(this.rect, path, f);
                    }
                }
            } else {
                float f4 = this.cornersRadius;
                if (f4 <= 0.0f) {
                    this.initRightSquarePath(this.rect, path, f);
                } else if (f > 0.0f && f > f4) {
                    this.initRightSquarePath(this.rect, path, f);
                } else {
                    this.initRightRoundedPath(this.rect, path, f);
                }
            }
        } else {
            float f5 = this.cornersRadius;
            if (f5 <= 0.0f) {
                this.initLeftSquarePath(this.rect, path, f);
            } else if (f > 0.0f && f > f5) {
                this.initLeftSquarePath(this.rect, path, f);
            } else {
                this.initLeftRoundedPath(this.rect, path, f);
            }
        }
    }

    private void initRightRoundedPath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + this.cornersRadius + f, rectF.top + f);
        path.lineTo(rectF.width() - this.cornersRadius - this.arrowWidth - f, rectF.top + f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius - this.arrowWidth, rectF.top + f, rectF.right - this.arrowWidth - f, this.cornersRadius + rectF.top), 270.0f, 90.0f);
        float f2 = rectF.right;
        float f3 = this.arrowWidth;
        float f4 = this.arrowPosition;
        float f5 = f / 2.0f;
        path.lineTo(f2 - f3 - f, f4 + f5);
        path.lineTo(rectF.right - f - f, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rectF.right - this.arrowWidth - f, this.arrowPosition + this.arrowHeight - f5);
        path.lineTo(rectF.right - this.arrowWidth - f, rectF.bottom - this.cornersRadius - f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius - this.arrowWidth, rectF.bottom - this.cornersRadius, rectF.right - this.arrowWidth - f, rectF.bottom - f), 0.0f, 90.0f);
        path.lineTo(rectF.left + this.arrowWidth + f, rectF.bottom - f);
        f2 = rectF.left;
        f3 = rectF.bottom;
        f4 = this.cornersRadius;
        path.arcTo(new RectF(f2 + f, f3 - f4, f4 + rectF.left, rectF.bottom - f), 90.0f, 90.0f);
        path.arcTo(new RectF(rectF.left + f, rectF.top + f, this.cornersRadius + rectF.left, this.cornersRadius + rectF.top), 180.0f, 90.0f);
        path.close();
    }

    private void initRightSquarePath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + f, rectF.top + f);
        path.lineTo(rectF.width() - this.arrowWidth - f, rectF.top + f);
        float f2 = rectF.right;
        float f3 = this.arrowWidth;
        float f4 = this.arrowPosition;
        float f5 = f / 2.0f;
        path.lineTo(f2 - f3 - f, f4 + f5);
        path.lineTo(rectF.right - f - f, this.arrowPosition + this.arrowHeight / 2.0f);
        path.lineTo(rectF.right - this.arrowWidth - f, this.arrowPosition + this.arrowHeight - f5);
        path.lineTo(rectF.right - this.arrowWidth - f, rectF.bottom - f);
        path.lineTo(rectF.left + f, rectF.bottom - f);
        path.lineTo(rectF.left + f, rectF.top + f);
        path.close();
    }

    private void initTopRoundedPath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + Math.min(this.arrowPosition, this.cornersRadius) + f, rectF.top + this.arrowHeight + f);
        float f2 = rectF.left;
        float f3 = this.arrowPosition;
        float f4 = f / 2.0f;
        path.lineTo(f2 + f3 + f4, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.left + this.arrowWidth / 2.0f + this.arrowPosition, rectF.top + f + f);
        path.lineTo(rectF.left + this.arrowWidth + this.arrowPosition - f4, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.right - this.cornersRadius - f, rectF.top + this.arrowHeight + f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.top + this.arrowHeight + f, rectF.right - f, this.cornersRadius + rectF.top + this.arrowHeight), 270.0f, 90.0f);
        path.lineTo(rectF.right - f, rectF.bottom - this.cornersRadius - f);
        path.arcTo(new RectF(rectF.right - this.cornersRadius, rectF.bottom - this.cornersRadius, rectF.right - f, rectF.bottom - f), 0.0f, 90.0f);
        path.lineTo(rectF.left + this.cornersRadius + f, rectF.bottom - f);
        f2 = rectF.left;
        f3 = rectF.bottom;
        f4 = this.cornersRadius;
        path.arcTo(new RectF(f2 + f, f3 - f4, f4 + rectF.left, rectF.bottom - f), 90.0f, 90.0f);
        path.lineTo(rectF.left + f, rectF.top + this.arrowHeight + this.cornersRadius + f);
        path.arcTo(new RectF(rectF.left + f, rectF.top + this.arrowHeight + f, this.cornersRadius + rectF.left, this.cornersRadius + rectF.top + this.arrowHeight), 180.0f, 90.0f);
        path.close();
    }

    private void initTopSquarePath(RectF rectF, Path path, float f) {
        path.moveTo(rectF.left + this.arrowPosition + f, rectF.top + this.arrowHeight + f);
        float f2 = rectF.left;
        float f3 = this.arrowPosition;
        float f4 = f / 2.0f;
        path.lineTo(f2 + f3 + f4, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.left + this.arrowWidth / 2.0f + this.arrowPosition, rectF.top + f + f);
        path.lineTo(rectF.left + this.arrowWidth + this.arrowPosition - f4, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.right - f, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.right - f, rectF.bottom - f);
        path.lineTo(rectF.left + f, rectF.bottom - f);
        path.lineTo(rectF.left + f, rectF.top + this.arrowHeight + f);
        path.lineTo(rectF.left + this.arrowPosition + f, rectF.top + this.arrowHeight + f);
        path.close();
    }

    public void draw(Canvas canvas) {
        if (this.strokeWidth > 0.0f) {
            canvas.drawPath(this.strokePath, this.strokePaint);
        }
        canvas.drawPath(this.path, this.paint);
    }

    public int getIntrinsicHeight() {
        return (int)this.rect.height();
    }

    public int getIntrinsicWidth() {
        return (int)this.rect.width();
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
    }

    public void setAlpha(int n) {
        this.paint.setAlpha(n);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }
}

