/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.ArrowDirection;
import com.mapbox.mapboxsdk.annotations.Bubble;

@Deprecated
public class BubbleLayout
extends LinearLayout {
    public static final float DEFAULT_STROKE_WIDTH = -1.0f;
    private ArrowDirection arrowDirection;
    private float arrowHeight;
    private float arrowPosition;
    private float arrowWidth;
    private Bubble bubble;
    private int bubbleColor;
    private float cornersRadius;
    private int strokeColor;
    private float strokeWidth;

    public BubbleLayout(Context context) {
        this(context, null, 0);
    }

    public BubbleLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BubbleLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.mapbox_BubbleLayout);
        this.arrowDirection = new ArrowDirection(attributeSet.getInt(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowDirection, 0));
        this.arrowWidth = attributeSet.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowWidth, BubbleLayout.convertDpToPixel(8.0f, context));
        this.arrowHeight = attributeSet.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowHeight, BubbleLayout.convertDpToPixel(8.0f, context));
        this.arrowPosition = attributeSet.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_arrowPosition, BubbleLayout.convertDpToPixel(12.0f, context));
        this.cornersRadius = attributeSet.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_cornersRadius, 0.0f);
        this.bubbleColor = attributeSet.getColor(R.styleable.mapbox_BubbleLayout_mapbox_bl_bubbleColor, -1);
        this.strokeWidth = attributeSet.getDimension(R.styleable.mapbox_BubbleLayout_mapbox_bl_strokeWidth, -1.0f);
        this.strokeColor = attributeSet.getColor(R.styleable.mapbox_BubbleLayout_mapbox_bl_strokeColor, -7829368);
        attributeSet.recycle();
        this.initPadding();
    }

    static float convertDpToPixel(float f, Context context) {
        return f * (float)(context.getResources().getDisplayMetrics().densityDpi / 160);
    }

    private void initDrawable(int n, int n2, int n3, int n4) {
        if (n2 >= n && n4 >= n3) {
            this.bubble = new Bubble(new RectF((float)n, (float)n3, (float)n2, (float)n4), this.arrowDirection, this.arrowWidth, this.arrowHeight, this.arrowPosition, this.cornersRadius, this.bubbleColor, this.strokeWidth, this.strokeColor);
        }
    }

    private void initPadding() {
        int n = this.getPaddingLeft();
        int n2 = this.getPaddingRight();
        int n3 = this.getPaddingTop();
        int n4 = this.getPaddingBottom();
        int n5 = this.arrowDirection.getValue();
        if (n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    if (n5 == 3) {
                        n4 = (int)((float)n4 + this.arrowHeight);
                    }
                } else {
                    n3 = (int)((float)n3 + this.arrowHeight);
                }
            } else {
                n2 = (int)((float)n2 + this.arrowWidth);
            }
        } else {
            n = (int)((float)n + this.arrowWidth);
        }
        float f = this.strokeWidth;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        n5 = n4;
        if (f > 0.0f) {
            n6 = (int)((float)n + f);
            n7 = (int)((float)n2 + f);
            n8 = (int)((float)n3 + f);
            n5 = (int)((float)n4 + f);
        }
        this.setPadding(n6, n8, n7, n5);
    }

    private void resetPadding() {
        int n = this.getPaddingLeft();
        int n2 = this.getPaddingRight();
        int n3 = this.getPaddingTop();
        int n4 = this.getPaddingBottom();
        int n5 = this.arrowDirection.getValue();
        if (n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    if (n5 == 3) {
                        n4 = (int)((float)n4 - this.arrowHeight);
                    }
                } else {
                    n3 = (int)((float)n3 - this.arrowHeight);
                }
            } else {
                n2 = (int)((float)n2 - this.arrowWidth);
            }
        } else {
            n = (int)((float)n - this.arrowWidth);
        }
        float f = this.strokeWidth;
        int n6 = n;
        int n7 = n2;
        int n8 = n3;
        n5 = n4;
        if (f > 0.0f) {
            n6 = (int)((float)n - f);
            n7 = (int)((float)n2 - f);
            n8 = (int)((float)n3 - f);
            n5 = (int)((float)n4 - f);
        }
        this.setPadding(n6, n8, n7, n5);
    }

    protected void dispatchDraw(Canvas canvas) {
        Bubble bubble = this.bubble;
        if (bubble != null) {
            bubble.draw(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public ArrowDirection getArrowDirection() {
        return this.arrowDirection;
    }

    public float getArrowHeight() {
        return this.arrowHeight;
    }

    public float getArrowPosition() {
        return this.arrowPosition;
    }

    public float getArrowWidth() {
        return this.arrowWidth;
    }

    public int getBubbleColor() {
        return this.bubbleColor;
    }

    public float getCornersRadius() {
        return this.cornersRadius;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.initDrawable(0, this.getWidth(), 0, this.getHeight());
    }

    public BubbleLayout setArrowDirection(ArrowDirection arrowDirection) {
        this.resetPadding();
        this.arrowDirection = arrowDirection;
        this.initPadding();
        return this;
    }

    public BubbleLayout setArrowHeight(float f) {
        this.resetPadding();
        this.arrowHeight = f;
        this.initPadding();
        return this;
    }

    public BubbleLayout setArrowPosition(float f) {
        this.resetPadding();
        this.arrowPosition = f;
        this.initPadding();
        return this;
    }

    public BubbleLayout setArrowWidth(float f) {
        this.resetPadding();
        this.arrowWidth = f;
        this.initPadding();
        return this;
    }

    public BubbleLayout setBubbleColor(int n) {
        this.bubbleColor = n;
        this.requestLayout();
        return this;
    }

    public BubbleLayout setCornersRadius(float f) {
        this.cornersRadius = f;
        this.requestLayout();
        return this;
    }

    public BubbleLayout setStrokeColor(int n) {
        this.strokeColor = n;
        this.requestLayout();
        return this;
    }

    public BubbleLayout setStrokeWidth(float f) {
        this.resetPadding();
        this.strokeWidth = f;
        this.initPadding();
        return this;
    }
}

