/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.annotations;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.BubbleLayout;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;

@Deprecated
public class InfoWindow {
    private WeakReference<Marker> boundMarker;
    private final ViewTreeObserver.OnGlobalLayoutListener contentUpdateListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            View view = (View)InfoWindow.this.view.get();
            if (view != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                InfoWindow.access$202(InfoWindow.this, (float)(-view.getMeasuredHeight()) + InfoWindow.this.markerHeightOffset);
                InfoWindow.this.update();
            }
        }
    };
    private PointF coordinates;
    private boolean isVisible;
    private int layoutRes;
    private WeakReference<MapboxMap> mapboxMap;
    private float markerHeightOffset;
    private float markerWidthOffset;
    protected WeakReference<View> view;
    private float viewHeightOffset;
    private float viewWidthOffset;

    InfoWindow(View view, MapboxMap mapboxMap) {
        this.initialize(view, mapboxMap);
    }

    InfoWindow(MapView mapView, int n, MapboxMap mapboxMap) {
        this.layoutRes = n;
        this.initialize(LayoutInflater.from((Context)mapView.getContext()).inflate(n, (ViewGroup)mapView, false), mapboxMap);
    }

    static /* synthetic */ float access$202(InfoWindow infoWindow, float f) {
        infoWindow.viewHeightOffset = f;
        return f;
    }

    private void closeInfoWindow() {
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        if (marker != null && mapboxMap != null) {
            mapboxMap.deselectMarker(marker);
        }
        this.close();
    }

    private void initialize(View view, MapboxMap mapboxMap) {
        this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        this.isVisible = false;
        this.view = new WeakReference<View>(view);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View object) {
                object = (MapboxMap)InfoWindow.this.mapboxMap.get();
                if (object != null) {
                    object = ((MapboxMap)object).getOnInfoWindowClickListener();
                    boolean bl = false;
                    if (object != null) {
                        bl = object.onInfoWindowClick(InfoWindow.this.getBoundMarker());
                    }
                    if (!bl) {
                        InfoWindow.this.closeInfoWindow();
                    }
                }
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View object) {
                object = (MapboxMap)InfoWindow.this.mapboxMap.get();
                if (object != null && (object = ((MapboxMap)object).getOnInfoWindowLongClickListener()) != null) {
                    object.onInfoWindowLongClick(InfoWindow.this.getBoundMarker());
                }
                return true;
            }
        });
    }

    void adaptDefaultMarker(Marker object, MapboxMap mapboxMap, MapView object2) {
        View view;
        View view2 = view = (View)this.view.get();
        if (view == null) {
            view2 = LayoutInflater.from((Context)object2.getContext()).inflate(this.layoutRes, (ViewGroup)object2, false);
            this.initialize(view2, mapboxMap);
        }
        this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        object2 = ((Marker)object).getTitle();
        mapboxMap = (TextView)view2.findViewById(R.id.infowindow_title);
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            mapboxMap.setText((CharSequence)object2);
            mapboxMap.setVisibility(0);
        } else {
            mapboxMap.setVisibility(8);
        }
        object = ((Marker)object).getSnippet();
        mapboxMap = (TextView)view2.findViewById(R.id.infowindow_description);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            mapboxMap.setText((CharSequence)object);
            mapboxMap.setVisibility(0);
        } else {
            mapboxMap.setVisibility(8);
        }
    }

    InfoWindow close() {
        Object object = (MapboxMap)this.mapboxMap.get();
        if (this.isVisible && object != null) {
            this.isVisible = false;
            Object object2 = (View)this.view.get();
            if (object2 != null && object2.getParent() != null) {
                ((ViewGroup)object2.getParent()).removeView(object2);
            }
            object2 = this.getBoundMarker();
            if ((object = ((MapboxMap)object).getOnInfoWindowCloseListener()) != null) {
                object.onInfoWindowClose((Marker)object2);
            }
            this.setBoundMarker(null);
        }
        return this;
    }

    Marker getBoundMarker() {
        WeakReference<Marker> weakReference = this.boundMarker;
        if (weakReference == null) {
            return null;
        }
        return (Marker)weakReference.get();
    }

    public View getView() {
        Object object = this.view;
        object = object != null ? (View)object.get() : null;
        return object;
    }

    boolean isVisible() {
        return this.isVisible;
    }

    void onContentUpdate() {
        View view = (View)this.view.get();
        if (view != null && (view = view.getViewTreeObserver()).isAlive()) {
            view.addOnGlobalLayoutListener(this.contentUpdateListener);
        }
    }

    InfoWindow open(MapView mapView, Marker marker, LatLng latLng, int n, int n2) {
        this.setBoundMarker(marker);
        marker = new FrameLayout.LayoutParams(-2, -2);
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        View view = (View)this.view.get();
        if (view != null && mapboxMap != null) {
            float f;
            view.measure(0, 0);
            this.markerHeightOffset = f = (float)n2;
            this.markerWidthOffset = -n;
            latLng = mapboxMap.getProjection().toScreenLocation(latLng);
            this.coordinates = latLng;
            float f2 = ((PointF)latLng).x;
            float f3 = view.getMeasuredWidth() / 2;
            float f4 = n;
            f2 = f2 - f3 + f4;
            float f5 = this.coordinates.y;
            float f6 = view.getMeasuredHeight();
            f3 = f2;
            if (view instanceof BubbleLayout) {
                latLng = mapView.getContext().getResources();
                float f7 = (float)view.getMeasuredWidth() + f2;
                float f8 = mapView.getRight();
                float f9 = mapView.getLeft();
                float f10 = latLng.getDimension(R.dimen.mapbox_infowindow_margin);
                float f11 = latLng.getDimension(R.dimen.mapbox_infowindow_tipview_width) / 2.0f;
                float f12 = (float)(view.getMeasuredWidth() / 2) - f11;
                f3 = f2;
                float f13 = f12;
                if (this.coordinates.x >= 0.0f) {
                    f3 = f2;
                    f13 = f12;
                    if (this.coordinates.x <= (float)mapView.getWidth()) {
                        f3 = f2;
                        f13 = f12;
                        if (this.coordinates.y >= 0.0f) {
                            f3 = f2;
                            f13 = f12;
                            if (this.coordinates.y <= (float)mapView.getHeight()) {
                                boolean bl;
                                float f14;
                                if (f7 > f8) {
                                    f3 = f7 - f8;
                                    f13 = f2 - f3;
                                    f3 = f12 + (f3 + f11);
                                    f7 = (float)view.getMeasuredWidth() + f13;
                                    n = 1;
                                    f12 = f13;
                                } else {
                                    f13 = f2;
                                    n = 0;
                                    f3 = f12;
                                    f12 = f13;
                                }
                                if (f2 < f9) {
                                    f2 = f9 - f2;
                                    f14 = f12 += f2;
                                    f3 -= f2 + f11;
                                    bl = true;
                                } else {
                                    bl = false;
                                    f14 = f2;
                                }
                                float f15 = f14;
                                f13 = f12;
                                f2 = f3;
                                if (n != 0) {
                                    f7 = f8 - f7;
                                    f15 = f14;
                                    f13 = f12;
                                    f2 = f3;
                                    if (f7 < f10) {
                                        f2 = f10 - f7;
                                        f13 = f12 - f2;
                                        f2 = f3 + (f2 - f11);
                                        f15 = f13;
                                    }
                                }
                                if (bl && (f3 = f15 - f9) < f10) {
                                    f3 = f10 - f3;
                                    f2 -= f3 - f11;
                                    f3 = f13 + f3;
                                    f13 = f2;
                                } else {
                                    f3 = f13;
                                    f13 = f2;
                                }
                            }
                        }
                    }
                }
                ((BubbleLayout)view).setArrowPosition(f13);
            }
            view.setX(f3);
            view.setY(f5 - f6 + f);
            this.viewWidthOffset = f3 - this.coordinates.x - f4;
            this.viewHeightOffset = -view.getMeasuredHeight() + n2;
            this.close();
            mapView.addView(view, (ViewGroup.LayoutParams)marker);
            this.isVisible = true;
        }
        return this;
    }

    InfoWindow setBoundMarker(Marker marker) {
        this.boundMarker = new WeakReference<Marker>(marker);
        return this;
    }

    public void update() {
        MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
        Marker marker = (Marker)this.boundMarker.get();
        View view = (View)this.view.get();
        if (mapboxMap != null && marker != null && view != null) {
            mapboxMap = mapboxMap.getProjection().toScreenLocation(marker.getPosition());
            this.coordinates = mapboxMap;
            if (view instanceof BubbleLayout) {
                view.setX(((PointF)mapboxMap).x + this.viewWidthOffset - this.markerWidthOffset);
            } else {
                view.setX(((PointF)mapboxMap).x - (float)(view.getMeasuredWidth() / 2) - this.markerWidthOffset);
            }
            view.setY(this.coordinates.y + this.viewHeightOffset);
        }
    }
}

