/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.camera;

import android.graphics.Point;
import android.graphics.PointF;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.UiSettings;
import java.util.Arrays;

public final class CameraUpdateFactory {
    public static CameraUpdate bearingTo(double d) {
        return new CameraPositionUpdate(d, null, -1.0, -1.0, null);
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraPosition) {
        return new CameraPositionUpdate(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom, cameraPosition.padding);
    }

    public static CameraUpdate newLatLng(LatLng latLng) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0, null);
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, double d, double d2, int n) {
        return CameraUpdateFactory.newLatLngBounds(latLngBounds, d, d2, n, n, n, n);
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, double d, double d2, int n, int n2, int n3, int n4) {
        return new CameraBoundsUpdate(latLngBounds, d, d2, n, n2, n3, n4);
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n) {
        return CameraUpdateFactory.newLatLngBounds(latLngBounds, n, n, n, n);
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latLngBounds, int n, int n2, int n3, int n4) {
        return new CameraBoundsUpdate(latLngBounds, null, null, n, n2, n3, n4);
    }

    public static CameraUpdate newLatLngPadding(LatLng latLng, double d, double d2, double d3, double d4) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0, new double[]{d, d2, d3, d4});
    }

    public static CameraUpdate newLatLngZoom(LatLng latLng, double d) {
        return new CameraPositionUpdate(-1.0, latLng, -1.0, d, null);
    }

    public static CameraUpdate paddingTo(double d, double d2, double d3, double d4) {
        return CameraUpdateFactory.paddingTo(new double[]{d, d2, d3, d4});
    }

    public static CameraUpdate paddingTo(double[] dArray) {
        return new CameraPositionUpdate(-1.0, null, -1.0, -1.0, dArray);
    }

    public static CameraUpdate tiltTo(double d) {
        return new CameraPositionUpdate(-1.0, null, d, -1.0, null);
    }

    public static CameraUpdate zoomBy(double d) {
        return new ZoomUpdate(2, d);
    }

    public static CameraUpdate zoomBy(double d, Point point) {
        return new ZoomUpdate(d, point.x, point.y);
    }

    public static CameraUpdate zoomIn() {
        return new ZoomUpdate(0);
    }

    public static CameraUpdate zoomOut() {
        return new ZoomUpdate(1);
    }

    public static CameraUpdate zoomTo(double d) {
        return new ZoomUpdate(3, d);
    }

    static final class CameraBoundsUpdate
    implements CameraUpdate {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private final Double bearing;
        private final LatLngBounds bounds;
        private final int[] padding;
        private final Double tilt;

        CameraBoundsUpdate(LatLngBounds latLngBounds, Double d, Double d2, int n, int n2, int n3, int n4) {
            this(latLngBounds, d, d2, new int[]{n, n2, n3, n4});
        }

        CameraBoundsUpdate(LatLngBounds latLngBounds, Double d, Double d2, int[] nArray) {
            this.bounds = latLngBounds;
            this.padding = nArray;
            this.bearing = d;
            this.tilt = d2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (CameraBoundsUpdate)object;
                if (!this.bounds.equals(((CameraBoundsUpdate)object).bounds)) {
                    return false;
                }
                return Arrays.equals(this.padding, ((CameraBoundsUpdate)object).padding);
            }
            return false;
        }

        public LatLngBounds getBounds() {
            return this.bounds;
        }

        @Override
        public CameraPosition getCameraPosition(MapboxMap mapboxMap) {
            Double d = this.bearing;
            if (d == null && this.tilt == null) {
                return mapboxMap.getCameraForLatLngBounds(this.bounds, this.padding);
            }
            return mapboxMap.getCameraForLatLngBounds(this.bounds, this.padding, d, this.tilt);
        }

        public int[] getPadding() {
            return this.padding;
        }

        public int hashCode() {
            return this.bounds.hashCode() * 31 + Arrays.hashCode(this.padding);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CameraBoundsUpdate{bounds=");
            stringBuilder.append(this.bounds);
            stringBuilder.append(", padding=");
            stringBuilder.append(Arrays.toString(this.padding));
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static final class CameraMoveUpdate
    implements CameraUpdate {
        private float x;
        private float y;

        CameraMoveUpdate(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (CameraMoveUpdate)object;
                if (Float.compare(((CameraMoveUpdate)object).x, this.x) != 0) {
                    return false;
                }
                if (Float.compare(((CameraMoveUpdate)object).y, this.y) != 0) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        @Override
        public CameraPosition getCameraPosition(MapboxMap object) {
            Object object2 = ((MapboxMap)object).getUiSettings();
            Object object3 = ((MapboxMap)object).getProjection();
            float f = ((UiSettings)object2).getWidth();
            float f2 = ((UiSettings)object2).getHeight();
            object2 = ((MapboxMap)object).getPadding();
            object3 = ((Projection)object3).fromScreenLocation(new PointF((f - (float)object2[0] + (float)object2[1]) / 2.0f + this.x, (f2 + (float)object2[1] - (float)object2[3]) / 2.0f + this.y));
            object = ((MapboxMap)object).getCameraPosition();
            return new CameraPosition.Builder().target((LatLng)object3).zoom(((CameraPosition)object).zoom).tilt(((CameraPosition)object).tilt).bearing(((CameraPosition)object).bearing).build();
        }

        public int hashCode() {
            float f = this.x;
            int n = 0;
            int n2 = f != 0.0f ? Float.floatToIntBits(f) : 0;
            f = this.y;
            if (f != 0.0f) {
                n = Float.floatToIntBits(f);
            }
            return n2 * 31 + n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CameraMoveUpdate{x=");
            stringBuilder.append(this.x);
            stringBuilder.append(", y=");
            stringBuilder.append(this.y);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static final class CameraPositionUpdate
    implements CameraUpdate {
        private final double bearing;
        private final double[] padding;
        private final LatLng target;
        private final double tilt;
        private final double zoom;

        CameraPositionUpdate(double d, LatLng latLng, double d2, double d3, double[] dArray) {
            this.bearing = d;
            this.target = latLng;
            this.tilt = d2;
            this.zoom = d3;
            this.padding = dArray;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                CameraPositionUpdate cameraPositionUpdate = (CameraPositionUpdate)object;
                if (Double.compare(cameraPositionUpdate.bearing, this.bearing) != 0) {
                    return false;
                }
                if (Double.compare(cameraPositionUpdate.tilt, this.tilt) != 0) {
                    return false;
                }
                if (Double.compare(cameraPositionUpdate.zoom, this.zoom) != 0) {
                    return false;
                }
                object = this.target;
                if (object != null ? !((LatLng)object).equals(cameraPositionUpdate.target) : cameraPositionUpdate.target != null) {
                    return false;
                }
                return Arrays.equals(this.padding, cameraPositionUpdate.padding);
            }
            return false;
        }

        public double getBearing() {
            return this.bearing;
        }

        @Override
        public CameraPosition getCameraPosition(MapboxMap object) {
            if (this.target == null) {
                object = ((MapboxMap)object).getCameraPosition();
                return new CameraPosition.Builder(this).target(((CameraPosition)object).target).build();
            }
            return new CameraPosition.Builder(this).build();
        }

        public double[] getPadding() {
            return this.padding;
        }

        public LatLng getTarget() {
            return this.target;
        }

        public double getTilt() {
            return this.tilt;
        }

        public double getZoom() {
            return this.zoom;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.bearing);
            int n = (int)(l ^ l >>> 32);
            LatLng latLng = this.target;
            int n2 = latLng != null ? latLng.hashCode() : 0;
            l = Double.doubleToLongBits(this.tilt);
            int n3 = (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.zoom);
            return (((n * 31 + n2) * 31 + n3) * 31 + (int)(l ^ l >>> 32)) * 31 + Arrays.hashCode(this.padding);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CameraPositionUpdate{bearing=");
            stringBuilder.append(this.bearing);
            stringBuilder.append(", target=");
            stringBuilder.append(this.target);
            stringBuilder.append(", tilt=");
            stringBuilder.append(this.tilt);
            stringBuilder.append(", zoom=");
            stringBuilder.append(this.zoom);
            stringBuilder.append(", padding=");
            stringBuilder.append(Arrays.toString(this.padding));
            stringBuilder.append('}');
            return stringBuilder.toString();
        }
    }

    static final class ZoomUpdate
    implements CameraUpdate {
        static final int ZOOM_BY = 2;
        static final int ZOOM_IN = 0;
        static final int ZOOM_OUT = 1;
        static final int ZOOM_TO = 3;
        static final int ZOOM_TO_POINT = 4;
        private final int type;
        private float x;
        private float y;
        private final double zoom;

        ZoomUpdate(double d, float f, float f2) {
            this.type = 4;
            this.zoom = d;
            this.x = f;
            this.y = f2;
        }

        ZoomUpdate(int n) {
            this.type = n;
            this.zoom = 0.0;
        }

        ZoomUpdate(int n, double d) {
            this.type = n;
            this.zoom = d;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (ZoomUpdate)object;
                if (this.type != ((ZoomUpdate)object).type) {
                    return false;
                }
                if (Double.compare(((ZoomUpdate)object).zoom, this.zoom) != 0) {
                    return false;
                }
                if (Float.compare(((ZoomUpdate)object).x, this.x) != 0) {
                    return false;
                }
                if (Float.compare(((ZoomUpdate)object).y, this.y) != 0) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        @Override
        public CameraPosition getCameraPosition(MapboxMap mapboxMap) {
            CameraPosition cameraPosition = mapboxMap.getCameraPosition();
            if (this.getType() != 4) {
                return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).build();
            }
            return new CameraPosition.Builder(cameraPosition).zoom(this.transformZoom(cameraPosition.zoom)).target(mapboxMap.getProjection().fromScreenLocation(new PointF(this.getX(), this.getY()))).build();
        }

        public int getType() {
            return this.type;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public double getZoom() {
            return this.zoom;
        }

        public int hashCode() {
            int n = this.type;
            long l = Double.doubleToLongBits(this.zoom);
            int n2 = (int)(l ^ l >>> 32);
            float f = this.x;
            int n3 = 0;
            int n4 = f != 0.0f ? Float.floatToIntBits(f) : 0;
            f = this.y;
            if (f != 0.0f) {
                n3 = Float.floatToIntBits(f);
            }
            return ((n * 31 + n2) * 31 + n4) * 31 + n3;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ZoomUpdate{type=");
            stringBuilder.append(this.type);
            stringBuilder.append(", zoom=");
            stringBuilder.append(this.zoom);
            stringBuilder.append(", x=");
            stringBuilder.append(this.x);
            stringBuilder.append(", y=");
            stringBuilder.append(this.y);
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        double transformZoom(double d) {
            block5: {
                block1: {
                    double d2;
                    block2: {
                        double d3;
                        block6: {
                            block3: {
                                block4: {
                                    int n = this.getType();
                                    if (n == 0) break block1;
                                    if (n == 1) break block2;
                                    if (n == 2) break block3;
                                    if (n == 3) break block4;
                                    if (n != 4) break block5;
                                    d3 = this.getZoom();
                                    break block6;
                                }
                                d = this.getZoom();
                                break block5;
                            }
                            d3 = this.getZoom();
                        }
                        d += d3;
                        break block5;
                    }
                    d = d2 = d - 1.0;
                    if (d2 < 0.0) {
                        d = 0.0;
                    }
                    break block5;
                }
                d += 1.0;
            }
            return d;
        }
    }
}

