/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.geometry;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import com.mapbox.geojson.Point;
import com.mapbox.turf.TurfMeasurement;

public class LatLng
implements Parcelable {
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        public LatLng createFromParcel(Parcel parcel) {
            return new LatLng(parcel);
        }

        public LatLng[] newArray(int n) {
            return new LatLng[n];
        }
    };
    private double altitude = 0.0;
    private double latitude;
    private double longitude;

    public LatLng() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public LatLng(double d, double d2) {
        this.setLatitude(d);
        this.setLongitude(d2);
    }

    public LatLng(double d, double d2, double d3) {
        this.setLatitude(d);
        this.setLongitude(d2);
        this.setAltitude(d3);
    }

    public LatLng(Location location) {
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    protected LatLng(Parcel parcel) {
        this.setLatitude(parcel.readDouble());
        this.setLongitude(parcel.readDouble());
        this.setAltitude(parcel.readDouble());
    }

    public LatLng(LatLng latLng) {
        this.latitude = latLng.latitude;
        this.longitude = latLng.longitude;
        this.altitude = latLng.altitude;
    }

    static double wrap(double d, double d2, double d3) {
        double d4 = d3 - d2;
        d4 = ((d - d2) % d4 + d4) % d4;
        if (d >= d3 && d4 == 0.0) {
            return d3;
        }
        return d4 + d2;
    }

    public int describeContents() {
        return 0;
    }

    public double distanceTo(LatLng latLng) {
        return TurfMeasurement.distance(Point.fromLngLat(this.longitude, this.latitude), Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude()), "metres");
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (LatLng)object;
            if (Double.compare(((LatLng)object).altitude, this.altitude) != 0 || Double.compare(((LatLng)object).latitude, this.latitude) != 0 || Double.compare(((LatLng)object).longitude, this.longitude) != 0) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.latitude);
        int n = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.longitude);
        int n2 = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.altitude);
        return (n * 31 + n2) * 31 + (int)(l ^ l >>> 32);
    }

    public void setAltitude(double d) {
        this.altitude = d;
    }

    public void setLatitude(double d) {
        if (!Double.isNaN(d)) {
            if (!(Math.abs(d) > 90.0)) {
                this.latitude = d;
                return;
            }
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        throw new IllegalArgumentException("latitude must not be NaN");
    }

    public void setLongitude(double d) {
        if (!Double.isNaN(d)) {
            if (!Double.isInfinite(d)) {
                this.longitude = d;
                return;
            }
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        throw new IllegalArgumentException("longitude must not be NaN");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("LatLng [latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(", longitude=");
        stringBuilder.append(this.longitude);
        stringBuilder.append(", altitude=");
        stringBuilder.append(this.altitude);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public LatLng wrap() {
        return new LatLng(this.latitude, LatLng.wrap(this.longitude, -180.0, 180.0));
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeDouble(this.latitude);
        parcel.writeDouble(this.longitude);
        parcel.writeDouble(this.altitude);
    }
}

