/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import com.mapbox.geojson.Feature;
import com.mapbox.mapboxsdk.location.IndicatorLocationLayerRenderer;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LocationIndicatorLayer;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.location.LocationPropertyFactory;
import com.mapbox.mapboxsdk.location.SymbolLocationLayerRenderer;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CircleLayer;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.HashSet;
import java.util.Set;

class LayerSourceProvider {
    private static final String EMPTY_STRING = "";

    LayerSourceProvider() {
    }

    Layer generateAccuracyLayer() {
        return new CircleLayer("mapbox-location-accuracy-layer", "mapbox-location-source").withProperties(PropertyFactory.circleRadius(Expression.get("mapbox-property-accuracy-radius")), PropertyFactory.circleColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circleOpacity(Expression.get("mapbox-property-accuracy-alpha")), PropertyFactory.circleStrokeColor(Expression.get("mapbox-property-accuracy-color")), PropertyFactory.circlePitchAlignment("map"));
    }

    Layer generateLayer(String string2) {
        SymbolLayer symbolLayer = new SymbolLayer(string2, "mapbox-location-source");
        Comparable<Boolean> comparable = true;
        PropertyValue<Boolean> propertyValue = PropertyFactory.iconAllowOverlap(comparable);
        PropertyValue<Boolean> propertyValue2 = PropertyFactory.iconIgnorePlacement(comparable);
        PropertyValue<String> propertyValue3 = PropertyFactory.iconRotationAlignment("map");
        Expression expression = Expression.literal(string2);
        comparable = Float.valueOf(0.0f);
        symbolLayer.setProperties(propertyValue, propertyValue2, propertyValue3, PropertyFactory.iconRotate(Expression.match(expression, Expression.literal((Number)((Object)comparable)), Expression.stop("mapbox-location-foreground-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-background-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-shadow-layer", Expression.get("mapbox-property-gps-bearing")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-compass-bearing")))), PropertyFactory.iconImage(Expression.match(Expression.literal(string2), Expression.literal(EMPTY_STRING), Expression.stop("mapbox-location-foreground-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-foreground-stale-icon"), Expression.get("mapbox-property-foreground-icon"))), Expression.stop("mapbox-location-background-layer", Expression.switchCase(Expression.get("mapbox-property-location-stale"), Expression.get("mapbox-property-background-stale-icon"), Expression.get("mapbox-property-background-icon"))), Expression.stop("mapbox-location-shadow-layer", Expression.literal("mapbox-location-shadow-icon")), Expression.stop("mapbox-location-bearing-layer", Expression.get("mapbox-property-shadow-icon")))), PropertyFactory.iconOffset(Expression.match(Expression.literal(string2), Expression.literal(new Float[]{comparable, comparable}), Expression.stop(Expression.literal("mapbox-location-foreground-layer"), Expression.get("mapbox-property-foreground-icon-offset")), Expression.stop(Expression.literal("mapbox-location-shadow-layer"), Expression.get("mapbox-property-shadow-icon-offset")))));
        return symbolLayer;
    }

    Layer generateLocationComponentLayer() {
        LocationIndicatorLayer locationIndicatorLayer = new LocationIndicatorLayer("mapbox-location-foreground-layer");
        locationIndicatorLayer.setLocationTransition(new TransitionOptions(0L, 0L));
        locationIndicatorLayer.setProperties(LocationPropertyFactory.perspectiveCompensation(Float.valueOf(0.9f)), LocationPropertyFactory.imageTiltDisplacement(Float.valueOf(4.0f)));
        return locationIndicatorLayer;
    }

    Layer generatePulsingCircleLayer() {
        return new CircleLayer("mapbox-location-pulsing-circle-layer", "mapbox-location-source").withProperties(PropertyFactory.circlePitchAlignment("map"));
    }

    GeoJsonSource generateSource(Feature feature) {
        return new GeoJsonSource("mapbox-location-source", feature, new GeoJsonOptions().withMaxZoom(16));
    }

    Set<String> getEmptyLayerSet() {
        return new HashSet<String>();
    }

    LocationLayerRenderer getIndicatorLocationLayerRenderer() {
        return new IndicatorLocationLayerRenderer(this);
    }

    LocationLayerRenderer getSymbolLocationLayerRenderer(LayerFeatureProvider layerFeatureProvider, boolean bl) {
        return new SymbolLocationLayerRenderer(this, layerFeatureProvider, bl);
    }
}

