/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.animation.Animator;
import android.location.Location;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.MapboxAnimatorProvider;
import com.mapbox.mapboxsdk.location.MapboxAnimatorSetProvider;
import com.mapbox.mapboxsdk.location.MapboxFloatAnimator;
import com.mapbox.mapboxsdk.location.MapboxLatLngAnimator;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

final class LocationAnimatorCoordinator {
    private static final String TAG = "Mbgl-LocationAnimatorCoordinator";
    private boolean accuracyAnimationEnabled;
    final SparseArray<MapboxAnimator> animatorArray = new SparseArray();
    private final MapboxAnimatorProvider animatorProvider;
    private final MapboxAnimatorSetProvider animatorSetProvider;
    private boolean compassAnimationEnabled;
    private float durationMultiplier;
    final SparseArray<MapboxAnimator.AnimationsValueChangeListener> listeners;
    private long locationUpdateTimestamp = -1L;
    int maxAnimationFps = Integer.MAX_VALUE;
    private float previousAccuracyRadius = -1.0f;
    private float previousCompassBearing = -1.0f;
    private Location previousLocation;
    private final Projection projection;

    LocationAnimatorCoordinator(Projection projection, MapboxAnimatorSetProvider mapboxAnimatorSetProvider, MapboxAnimatorProvider mapboxAnimatorProvider) {
        this.listeners = new SparseArray();
        this.projection = projection;
        this.animatorProvider = mapboxAnimatorProvider;
        this.animatorSetProvider = mapboxAnimatorSetProvider;
    }

    private void cancelAnimator(int n) {
        MapboxAnimator mapboxAnimator = (MapboxAnimator)((Object)this.animatorArray.get(n));
        if (mapboxAnimator != null) {
            mapboxAnimator.cancel();
            mapboxAnimator.removeAllUpdateListeners();
            mapboxAnimator.removeAllListeners();
        }
    }

    private float checkGpsNorth(boolean bl, float f) {
        if (bl) {
            f = 0.0f;
        }
        return f;
    }

    private void createNewCameraAdapterAnimator(int n, Float[] floatArray, MapboxMap.CancelableCallback cancelableCallback) {
        this.cancelAnimator(n);
        MapboxAnimator.AnimationsValueChangeListener animationsValueChangeListener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(n);
        if (animationsValueChangeListener != null) {
            this.animatorArray.put(n, (Object)this.animatorProvider.cameraAnimator(floatArray, animationsValueChangeListener, cancelableCallback));
        }
    }

    private void createNewFloatAnimator(int n, float f, float f2) {
        this.createNewFloatAnimator(n, new Float[]{Float.valueOf(f), Float.valueOf(f2)});
    }

    private void createNewFloatAnimator(int n, Float[] floatArray) {
        this.cancelAnimator(n);
        MapboxAnimator.AnimationsValueChangeListener animationsValueChangeListener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(n);
        if (animationsValueChangeListener != null) {
            this.animatorArray.put(n, (Object)this.animatorProvider.floatAnimator(floatArray, animationsValueChangeListener, this.maxAnimationFps));
        }
    }

    private void createNewLatLngAnimator(int n, LatLng latLng, LatLng latLng2) {
        this.createNewLatLngAnimator(n, new LatLng[]{latLng, latLng2});
    }

    private void createNewLatLngAnimator(int n, LatLng[] latLngArray) {
        this.cancelAnimator(n);
        MapboxAnimator.AnimationsValueChangeListener animationsValueChangeListener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(n);
        if (animationsValueChangeListener != null) {
            this.animatorArray.put(n, (Object)this.animatorProvider.latLngAnimator(latLngArray, animationsValueChangeListener, this.maxAnimationFps));
        }
    }

    private void createNewPaddingAnimator(int n, double[][] dArray, MapboxMap.CancelableCallback cancelableCallback) {
        this.cancelAnimator(n);
        MapboxAnimator.AnimationsValueChangeListener animationsValueChangeListener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(n);
        if (animationsValueChangeListener != null) {
            this.animatorArray.put(n, (Object)this.animatorProvider.paddingAnimator(dArray, animationsValueChangeListener, cancelableCallback));
        }
    }

    private Float[] getBearingValues(Float f, Location[] locationArray) {
        int n = locationArray.length;
        Float[] floatArray = new Float[++n];
        floatArray[0] = Float.valueOf(Utils.normalize(f.floatValue()));
        for (int i = 1; i < n; ++i) {
            int n2 = i - 1;
            floatArray[i] = Float.valueOf(Utils.shortestRotation(locationArray[n2].getBearing(), floatArray[n2].floatValue()));
        }
        return floatArray;
    }

    private LatLng[] getLatLngValues(LatLng latLng, Location[] locationArray) {
        int n = locationArray.length;
        LatLng[] latLngArray = new LatLng[++n];
        latLngArray[0] = latLng;
        for (int i = 1; i < n; ++i) {
            latLngArray[i] = new LatLng(locationArray[i - 1]);
        }
        return latLngArray;
    }

    private float getPreviousAccuracyRadius() {
        MapboxAnimator mapboxAnimator = (MapboxAnimator)((Object)this.animatorArray.get(6));
        float f = mapboxAnimator != null ? ((Float)mapboxAnimator.getAnimatedValue()).floatValue() : this.previousAccuracyRadius;
        return f;
    }

    private float getPreviousLayerCompassBearing() {
        MapboxFloatAnimator mapboxFloatAnimator = (MapboxFloatAnimator)((Object)this.animatorArray.get(3));
        float f = mapboxFloatAnimator != null ? ((Float)mapboxFloatAnimator.getAnimatedValue()).floatValue() : this.previousCompassBearing;
        return f;
    }

    private float getPreviousLayerGpsBearing() {
        MapboxFloatAnimator mapboxFloatAnimator = (MapboxFloatAnimator)((Object)this.animatorArray.get(2));
        float f = mapboxFloatAnimator != null ? ((Float)mapboxFloatAnimator.getAnimatedValue()).floatValue() : this.previousLocation.getBearing();
        return f;
    }

    private LatLng getPreviousLayerLatLng() {
        Object object = (MapboxAnimator)((Object)this.animatorArray.get(0));
        object = object != null ? (LatLng)object.getAnimatedValue() : new LatLng(this.previousLocation);
        return object;
    }

    private void playAnimators(long l, int ... nArray) {
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        for (int n : nArray) {
            Animator animator2 = (Animator)this.animatorArray.get(n);
            if (animator2 == null) continue;
            arrayList.add(animator2);
        }
        this.animatorSetProvider.startAnimation(arrayList, (Interpolator)new LinearInterpolator(), l);
    }

    private void playPulsingAnimator() {
        Animator animator2 = (Animator)this.animatorArray.get(9);
        if (animator2 != null) {
            animator2.start();
        }
    }

    private void resetCameraCompassAnimation(CameraPosition cameraPosition) {
        MapboxFloatAnimator mapboxFloatAnimator = (MapboxFloatAnimator)((Object)this.animatorArray.get(5));
        if (mapboxFloatAnimator == null) {
            return;
        }
        float f = ((Float)mapboxFloatAnimator.getTarget()).floatValue();
        float f2 = (float)cameraPosition.bearing;
        this.createNewFloatAnimator(5, f2, Utils.shortestRotation(f, f2));
    }

    private void resetCameraGpsBearingAnimation(CameraPosition cameraPosition, boolean bl) {
        MapboxFloatAnimator mapboxFloatAnimator = (MapboxFloatAnimator)((Object)this.animatorArray.get(4));
        if (mapboxFloatAnimator == null) {
            return;
        }
        float f = this.checkGpsNorth(bl, ((Float)mapboxFloatAnimator.getTarget()).floatValue());
        float f2 = (float)cameraPosition.bearing;
        this.createNewFloatAnimator(4, f2, Utils.shortestRotation(f, f2));
    }

    private boolean resetCameraLatLngAnimation(CameraPosition object) {
        Object object2 = (MapboxLatLngAnimator)((Object)this.animatorArray.get(1));
        if (object2 == null) {
            return false;
        }
        object2 = (LatLng)object2.getTarget();
        object = object.target;
        this.createNewLatLngAnimator(1, (LatLng)object, (LatLng)object2);
        return Utils.immediateAnimation(this.projection, (LatLng)object, (LatLng)object2);
    }

    private boolean resetCameraLocationAnimations(CameraPosition cameraPosition, boolean bl) {
        this.resetCameraGpsBearingAnimation(cameraPosition, bl);
        return this.resetCameraLatLngAnimation(cameraPosition);
    }

    private void updateAccuracyAnimators(float f, float f2) {
        this.createNewFloatAnimator(6, f2, f);
    }

    private void updateCameraAnimators(LatLng[] latLngArray, Float[] floatArray) {
        this.createNewLatLngAnimator(1, latLngArray);
        this.createNewFloatAnimator(4, floatArray);
    }

    private void updateCompassAnimators(float f, float f2, float f3) {
        this.createNewFloatAnimator(3, f2, Utils.shortestRotation(f, f2));
        this.createNewFloatAnimator(5, f3, Utils.shortestRotation(f, f3));
    }

    private void updateLayerAnimators(LatLng[] latLngArray, Float[] floatArray) {
        this.createNewLatLngAnimator(0, latLngArray);
        this.createNewFloatAnimator(2, floatArray);
    }

    private void updatePaddingAnimator(double[] dArray, double[] dArray2, MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewPaddingAnimator(10, new double[][]{dArray2, dArray}, cancelableCallback);
    }

    private void updateTiltAnimator(float f, float f2, MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(8, new Float[]{Float.valueOf(f2), Float.valueOf(f)}, cancelableCallback);
    }

    private void updateZoomAnimator(float f, float f2, MapboxMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(7, new Float[]{Float.valueOf(f2), Float.valueOf(f)}, cancelableCallback);
    }

    void cancelAllAnimations() {
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            this.cancelAnimator(this.animatorArray.keyAt(i));
        }
    }

    void cancelAndRemoveGpsBearingAnimation() {
        this.cancelAnimator(2);
        this.animatorArray.remove(2);
    }

    void cancelPaddingAnimation() {
        this.cancelAnimator(10);
    }

    void cancelTiltAnimation() {
        this.cancelAnimator(8);
    }

    void cancelZoomAnimation() {
        this.cancelAnimator(7);
    }

    void feedNewAccuracyRadius(float f, boolean bl) {
        if (this.previousAccuracyRadius < 0.0f) {
            this.previousAccuracyRadius = f;
        }
        this.updateAccuracyAnimators(f, this.getPreviousAccuracyRadius());
        long l = !bl && this.accuracyAnimationEnabled ? 250L : 0L;
        this.playAnimators(l, 6);
        this.previousAccuracyRadius = f;
    }

    void feedNewCompassBearing(float f, CameraPosition cameraPosition) {
        if (this.previousCompassBearing < 0.0f) {
            this.previousCompassBearing = f;
        }
        this.updateCompassAnimators(f, this.getPreviousLayerCompassBearing(), (float)cameraPosition.bearing);
        long l = this.compassAnimationEnabled ? 500L : 0L;
        this.playAnimators(l, 3, 5);
        this.previousCompassBearing = f;
    }

    void feedNewLocation(Location[] object, CameraPosition latLngArray, boolean bl, Long l) {
        int n = ((Location[])object).length;
        int n2 = 1;
        Location location = object[n - 1];
        if (this.previousLocation == null) {
            this.previousLocation = location;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime() - 750L;
        }
        LatLng latLng = this.getPreviousLayerLatLng();
        float f = this.getPreviousLayerGpsBearing();
        LatLng latLng2 = latLngArray.target;
        float f2 = Utils.normalize((float)latLngArray.bearing);
        latLngArray = this.getLatLngValues(latLng, (Location[])object);
        this.updateLayerAnimators(latLngArray, this.getBearingValues(Float.valueOf(f), (Location[])object));
        latLngArray[0] = latLng2;
        object = bl ? new Float[]{Float.valueOf(f2), Float.valueOf(Utils.shortestRotation(0.0f, f2))} : this.getBearingValues(Float.valueOf(f2), (Location[])object);
        this.updateCameraAnimators(latLngArray, (Float[])object);
        object = new LatLng(location);
        n = n2;
        if (!Utils.immediateAnimation(this.projection, latLng2, (LatLng)object)) {
            n = Utils.immediateAnimation(this.projection, latLng, (LatLng)object) ? n2 : 0;
        }
        long l2 = this.locationUpdateTimestamp;
        this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
        object = l;
        if (l == null) {
            if (n == 0) {
                object = l2 == 0L ? Long.valueOf(0L) : Long.valueOf((long)((float)(this.locationUpdateTimestamp - l2) * this.durationMultiplier));
                object = Math.min((Long)object, 2000L);
            } else {
                object = 0L;
            }
        }
        this.playAnimators((Long)object, 0, 2, 1, 4);
        this.previousLocation = location;
    }

    void feedNewPadding(double[] dArray, CameraPosition cameraPosition, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.updatePaddingAnimator(dArray, cameraPosition.padding, cancelableCallback);
        this.playAnimators(l, 10);
    }

    void feedNewTilt(double d, CameraPosition cameraPosition, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.updateTiltAnimator((float)d, (float)cameraPosition.tilt, cancelableCallback);
        this.playAnimators(l, 8);
    }

    void feedNewZoomLevel(double d, CameraPosition cameraPosition, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.updateZoomAnimator((float)d, (float)cameraPosition.zoom, cancelableCallback);
        this.playAnimators(l, 7);
    }

    void resetAllCameraAnimations(CameraPosition cameraPosition, boolean bl) {
        this.resetCameraCompassAnimation(cameraPosition);
        long l = this.resetCameraLocationAnimations(cameraPosition, bl) ? 0L : 750L;
        this.playAnimators(l, 1, 4);
    }

    void resetAllLayerAnimations() {
        MapboxLatLngAnimator mapboxLatLngAnimator = (MapboxLatLngAnimator)((Object)this.animatorArray.get(0));
        MapboxFloatAnimator mapboxFloatAnimator = (MapboxFloatAnimator)((Object)this.animatorArray.get(2));
        MapboxFloatAnimator mapboxFloatAnimator2 = (MapboxFloatAnimator)((Object)this.animatorArray.get(3));
        MapboxFloatAnimator mapboxFloatAnimator3 = (MapboxFloatAnimator)((Object)this.animatorArray.get(6));
        if (mapboxLatLngAnimator != null && mapboxFloatAnimator != null) {
            this.createNewLatLngAnimator(0, (LatLng)mapboxLatLngAnimator.getAnimatedValue(), (LatLng)mapboxLatLngAnimator.getTarget());
            this.createNewFloatAnimator(2, ((Float)mapboxFloatAnimator.getAnimatedValue()).floatValue(), ((Float)mapboxFloatAnimator.getTarget()).floatValue());
            this.playAnimators(mapboxLatLngAnimator.getDuration() - mapboxLatLngAnimator.getCurrentPlayTime(), 0, 2);
        }
        if (mapboxFloatAnimator2 != null) {
            this.createNewFloatAnimator(3, this.getPreviousLayerCompassBearing(), ((Float)mapboxFloatAnimator2.getTarget()).floatValue());
            long l = this.compassAnimationEnabled ? 500L : 0L;
            this.playAnimators(l, 3);
        }
        if (mapboxFloatAnimator3 != null) {
            this.feedNewAccuracyRadius(this.previousAccuracyRadius, false);
        }
    }

    void setAccuracyAnimationEnabled(boolean bl) {
        this.accuracyAnimationEnabled = bl;
    }

    void setCompassAnimationEnabled(boolean bl) {
        this.compassAnimationEnabled = bl;
    }

    void setMaxAnimationFps(int n) {
        if (n <= 0) {
            Logger.e(TAG, "Max animation FPS cannot be less or equal to 0.");
            return;
        }
        this.maxAnimationFps = n;
    }

    void setTrackingAnimationDurationMultiplier(float f) {
        this.durationMultiplier = f;
    }

    void startLocationComponentCirclePulsing(LocationComponentOptions object) {
        this.cancelAnimator(9);
        MapboxAnimator.AnimationsValueChangeListener animationsValueChangeListener = (MapboxAnimator.AnimationsValueChangeListener)this.listeners.get(9);
        if (animationsValueChangeListener != null) {
            MapboxAnimatorProvider mapboxAnimatorProvider = this.animatorProvider;
            int n = this.maxAnimationFps;
            float f = object.pulseSingleDuration();
            float f2 = object.pulseMaxRadius();
            object = object.pulseInterpolator() == null ? new DecelerateInterpolator() : object.pulseInterpolator();
            object = mapboxAnimatorProvider.pulsingCircleAnimator(animationsValueChangeListener, n, f, f2, (Interpolator)object);
            this.animatorArray.put(9, object);
            this.playPulsingAnimator();
        }
    }

    void stopPulsingCircleAnimation() {
        this.cancelAnimator(9);
    }

    void updateAnimatorListenerHolders(Set<AnimatorListenerHolder> object) {
        this.listeners.clear();
        Iterator<AnimatorListenerHolder> iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            this.listeners.append(((AnimatorListenerHolder)object).getAnimatorType(), (Object)((AnimatorListenerHolder)object).getListener());
        }
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            int n = this.animatorArray.keyAt(i);
            if (this.listeners.get(n) != null || (object = (MapboxAnimator)((Object)this.animatorArray.get(n))) == null) continue;
            ((MapboxAnimator)((Object)object)).makeInvalid();
        }
    }
}

