/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.hardware.SensorManager;
import android.location.Location;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.view.WindowManager;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.CompassEngine;
import com.mapbox.mapboxsdk.location.CompassListener;
import com.mapbox.mapboxsdk.location.LayerBitmapProvider;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationAnimatorCoordinator;
import com.mapbox.mapboxsdk.location.LocationCameraController;
import com.mapbox.mapboxsdk.location.LocationComponentActivationOptions;
import com.mapbox.mapboxsdk.location.LocationComponentCompassEngine;
import com.mapbox.mapboxsdk.location.LocationComponentNotInitializedException;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationLayerController;
import com.mapbox.mapboxsdk.location.LocationUpdate;
import com.mapbox.mapboxsdk.location.MapboxAnimatorProvider;
import com.mapbox.mapboxsdk.location.MapboxAnimatorSetProvider;
import com.mapbox.mapboxsdk.location.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.location.OnIndicatorPositionChangedListener;
import com.mapbox.mapboxsdk.location.OnLocationCameraTransitionListener;
import com.mapbox.mapboxsdk.location.OnLocationClickListener;
import com.mapbox.mapboxsdk.location.OnLocationLongClickListener;
import com.mapbox.mapboxsdk.location.OnLocationStaleListener;
import com.mapbox.mapboxsdk.location.OnRenderModeChangedListener;
import com.mapbox.mapboxsdk.location.StaleStateManager;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.Transform;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public final class LocationComponent {
    private static final String TAG = "Mbgl-LocationComponent";
    OnCameraTrackingChangedListener cameraTrackingChangedListener;
    private CompassEngine compassEngine;
    private CompassListener compassListener;
    private LocationEngineCallback<LocationEngineResult> currentLocationEngineListener;
    private final MapboxMap.OnDeveloperAnimationListener developerAnimationListener;
    private long fastestInterval;
    OnIndicatorPositionChangedListener indicatorPositionChangedListener;
    private InternalLocationEngineProvider internalLocationEngineProvider = new InternalLocationEngineProvider();
    private boolean isComponentInitialized;
    private boolean isComponentStarted;
    private boolean isEnabled;
    private boolean isLayerReady;
    private boolean isListeningToCompass;
    private CameraPosition lastCameraPosition;
    private Location lastLocation;
    private LocationEngineCallback<LocationEngineResult> lastLocationEngineListener;
    private long lastUpdateTime;
    private LocationAnimatorCoordinator locationAnimatorCoordinator;
    private LocationCameraController locationCameraController;
    private LocationEngine locationEngine;
    private LocationEngineRequest locationEngineRequest = new LocationEngineRequest.Builder(1000L).setFastestInterval(1000L).setPriority(0).build();
    private LocationLayerController locationLayerController;
    private final MapboxMap mapboxMap;
    private MapboxMap.OnCameraIdleListener onCameraIdleListener;
    private OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private MapboxMap.OnCameraMoveListener onCameraMoveListener;
    private final CopyOnWriteArrayList<OnCameraTrackingChangedListener> onCameraTrackingChangedListeners;
    private final CopyOnWriteArrayList<OnIndicatorPositionChangedListener> onIndicatorPositionChangedListener;
    private final CopyOnWriteArrayList<OnLocationClickListener> onLocationClickListeners;
    private final CopyOnWriteArrayList<OnLocationLongClickListener> onLocationLongClickListeners;
    private OnLocationStaleListener onLocationStaleListener;
    private final CopyOnWriteArrayList<OnLocationStaleListener> onLocationStaleListeners;
    private MapboxMap.OnMapClickListener onMapClickListener;
    private MapboxMap.OnMapLongClickListener onMapLongClickListener;
    private final CopyOnWriteArrayList<OnRenderModeChangedListener> onRenderModeChangedListeners;
    private LocationComponentOptions options;
    OnRenderModeChangedListener renderModeChangedListener;
    private StaleStateManager staleStateManager;
    private Style style;
    private final Transform transform;
    private boolean useSpecializedLocationLayer;

    LocationComponent() {
        this.currentLocationEngineListener = new CurrentLocationEngineCallback(this);
        this.lastLocationEngineListener = new LastLocationEngineCallback(this);
        this.onLocationStaleListeners = new CopyOnWriteArrayList();
        this.onLocationClickListeners = new CopyOnWriteArrayList();
        this.onLocationLongClickListeners = new CopyOnWriteArrayList();
        this.onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
        this.onRenderModeChangedListeners = new CopyOnWriteArrayList();
        this.onIndicatorPositionChangedListener = new CopyOnWriteArrayList();
        this.onCameraMoveListener = new MapboxMap.OnCameraMoveListener(){

            @Override
            public void onCameraMove() {
                LocationComponent.this.updateLayerOffsets(false);
            }
        };
        this.onCameraIdleListener = new MapboxMap.OnCameraIdleListener(){

            @Override
            public void onCameraIdle() {
                LocationComponent.this.updateLayerOffsets(false);
            }
        };
        this.onMapClickListener = new MapboxMap.OnMapClickListener(){

            @Override
            public boolean onMapClick(LatLng object) {
                if (!LocationComponent.this.onLocationClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick((LatLng)object)) {
                    object = LocationComponent.this.onLocationClickListeners.iterator();
                    while (object.hasNext()) {
                        ((OnLocationClickListener)object.next()).onLocationComponentClick();
                    }
                    return true;
                }
                return false;
            }
        };
        this.onMapLongClickListener = new MapboxMap.OnMapLongClickListener(){

            @Override
            public boolean onMapLongClick(LatLng object) {
                if (!LocationComponent.this.onLocationLongClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick((LatLng)object)) {
                    object = LocationComponent.this.onLocationLongClickListeners.iterator();
                    while (object.hasNext()) {
                        ((OnLocationLongClickListener)object.next()).onLocationComponentLongClick();
                    }
                    return true;
                }
                return false;
            }
        };
        this.onLocationStaleListener = new OnLocationStaleListener(){

            @Override
            public void onStaleStateChange(boolean bl) {
                LocationComponent.this.locationLayerController.setLocationsStale(bl);
                Iterator iterator2 = LocationComponent.this.onLocationStaleListeners.iterator();
                while (iterator2.hasNext()) {
                    ((OnLocationStaleListener)iterator2.next()).onStaleStateChange(bl);
                }
            }
        };
        this.onCameraMoveInvalidateListener = new OnCameraMoveInvalidateListener(){

            @Override
            public void onInvalidateCameraMove() {
                LocationComponent.this.onCameraMoveListener.onCameraMove();
            }
        };
        this.compassListener = new CompassListener(){

            @Override
            public void onCompassAccuracyChange(int n) {
            }

            @Override
            public void onCompassChanged(float f) {
                LocationComponent.this.updateCompassHeading(f);
            }
        };
        this.cameraTrackingChangedListener = new OnCameraTrackingChangedListener(){

            @Override
            public void onCameraTrackingChanged(int n) {
                LocationComponent.this.locationAnimatorCoordinator.cancelZoomAnimation();
                LocationComponent.this.locationAnimatorCoordinator.cancelTiltAnimation();
                LocationComponent.this.updateAnimatorListenerHolders();
                Iterator iterator2 = LocationComponent.this.onCameraTrackingChangedListeners.iterator();
                while (iterator2.hasNext()) {
                    ((OnCameraTrackingChangedListener)iterator2.next()).onCameraTrackingChanged(n);
                }
            }

            @Override
            public void onCameraTrackingDismissed() {
                Iterator iterator2 = LocationComponent.this.onCameraTrackingChangedListeners.iterator();
                while (iterator2.hasNext()) {
                    ((OnCameraTrackingChangedListener)iterator2.next()).onCameraTrackingDismissed();
                }
            }
        };
        this.renderModeChangedListener = new OnRenderModeChangedListener(){

            @Override
            public void onRenderModeChanged(int n) {
                LocationComponent.this.updateAnimatorListenerHolders();
                Iterator iterator2 = LocationComponent.this.onRenderModeChangedListeners.iterator();
                while (iterator2.hasNext()) {
                    ((OnRenderModeChangedListener)iterator2.next()).onRenderModeChanged(n);
                }
            }
        };
        this.indicatorPositionChangedListener = new OnIndicatorPositionChangedListener(){

            @Override
            public void onIndicatorPositionChanged(Point point) {
                Iterator iterator2 = LocationComponent.this.onIndicatorPositionChangedListener.iterator();
                while (iterator2.hasNext()) {
                    ((OnIndicatorPositionChangedListener)iterator2.next()).onIndicatorPositionChanged(point);
                }
            }
        };
        this.developerAnimationListener = new MapboxMap.OnDeveloperAnimationListener(){

            @Override
            public void onDeveloperAnimationStarted() {
                if (LocationComponent.this.isComponentInitialized && LocationComponent.this.isEnabled) {
                    LocationComponent.this.setCameraMode(8);
                }
            }
        };
        this.mapboxMap = null;
        this.transform = null;
    }

    public LocationComponent(MapboxMap mapboxMap, Transform transform, List<MapboxMap.OnDeveloperAnimationListener> list) {
        MapboxMap.OnDeveloperAnimationListener onDeveloperAnimationListener;
        this.currentLocationEngineListener = new CurrentLocationEngineCallback(this);
        this.lastLocationEngineListener = new LastLocationEngineCallback(this);
        this.onLocationStaleListeners = new CopyOnWriteArrayList();
        this.onLocationClickListeners = new CopyOnWriteArrayList();
        this.onLocationLongClickListeners = new CopyOnWriteArrayList();
        this.onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
        this.onRenderModeChangedListeners = new CopyOnWriteArrayList();
        this.onIndicatorPositionChangedListener = new CopyOnWriteArrayList();
        this.onCameraMoveListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraIdleListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapLongClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onLocationStaleListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraMoveInvalidateListener = new /* invalid duplicate definition of identical inner class */;
        this.compassListener = new /* invalid duplicate definition of identical inner class */;
        this.cameraTrackingChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.renderModeChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.indicatorPositionChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.developerAnimationListener = onDeveloperAnimationListener = new /* invalid duplicate definition of identical inner class */;
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        list.add(onDeveloperAnimationListener);
    }

    LocationComponent(MapboxMap mapboxMap, Transform transform, List<MapboxMap.OnDeveloperAnimationListener> list, LocationEngineCallback<LocationEngineResult> locationEngineCallback, LocationEngineCallback<LocationEngineResult> locationEngineCallback2, LocationLayerController locationLayerController, LocationCameraController locationCameraController, LocationAnimatorCoordinator locationAnimatorCoordinator, StaleStateManager staleStateManager, CompassEngine compassEngine, InternalLocationEngineProvider internalLocationEngineProvider, boolean bl) {
        MapboxMap.OnDeveloperAnimationListener onDeveloperAnimationListener;
        this.currentLocationEngineListener = new CurrentLocationEngineCallback(this);
        this.lastLocationEngineListener = new LastLocationEngineCallback(this);
        this.onLocationStaleListeners = new CopyOnWriteArrayList();
        this.onLocationClickListeners = new CopyOnWriteArrayList();
        this.onLocationLongClickListeners = new CopyOnWriteArrayList();
        this.onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
        this.onRenderModeChangedListeners = new CopyOnWriteArrayList();
        this.onIndicatorPositionChangedListener = new CopyOnWriteArrayList();
        this.onCameraMoveListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraIdleListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapLongClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onLocationStaleListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraMoveInvalidateListener = new /* invalid duplicate definition of identical inner class */;
        this.compassListener = new /* invalid duplicate definition of identical inner class */;
        this.cameraTrackingChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.renderModeChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.indicatorPositionChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.developerAnimationListener = onDeveloperAnimationListener = new /* invalid duplicate definition of identical inner class */;
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        list.add(onDeveloperAnimationListener);
        this.currentLocationEngineListener = locationEngineCallback;
        this.lastLocationEngineListener = locationEngineCallback2;
        this.locationLayerController = locationLayerController;
        this.locationCameraController = locationCameraController;
        this.locationAnimatorCoordinator = locationAnimatorCoordinator;
        this.staleStateManager = staleStateManager;
        this.compassEngine = compassEngine;
        this.internalLocationEngineProvider = internalLocationEngineProvider;
        this.useSpecializedLocationLayer = bl;
        this.isComponentInitialized = true;
    }

    LocationComponent(MapboxMap mapboxMap, Transform transform, List<MapboxMap.OnDeveloperAnimationListener> list, LocationEngineCallback<LocationEngineResult> locationEngineCallback, LocationLayerController locationLayerController, LocationCameraController locationCameraController, LocationAnimatorCoordinator locationAnimatorCoordinator, StaleStateManager staleStateManager, CompassEngine compassEngine, InternalLocationEngineProvider internalLocationEngineProvider, boolean bl, LocationEngineRequest locationEngineRequest) {
        MapboxMap.OnDeveloperAnimationListener onDeveloperAnimationListener;
        this.currentLocationEngineListener = new CurrentLocationEngineCallback(this);
        this.lastLocationEngineListener = new LastLocationEngineCallback(this);
        this.onLocationStaleListeners = new CopyOnWriteArrayList();
        this.onLocationClickListeners = new CopyOnWriteArrayList();
        this.onLocationLongClickListeners = new CopyOnWriteArrayList();
        this.onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
        this.onRenderModeChangedListeners = new CopyOnWriteArrayList();
        this.onIndicatorPositionChangedListener = new CopyOnWriteArrayList();
        this.onCameraMoveListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraIdleListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onMapLongClickListener = new /* invalid duplicate definition of identical inner class */;
        this.onLocationStaleListener = new /* invalid duplicate definition of identical inner class */;
        this.onCameraMoveInvalidateListener = new /* invalid duplicate definition of identical inner class */;
        this.compassListener = new /* invalid duplicate definition of identical inner class */;
        this.cameraTrackingChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.renderModeChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.indicatorPositionChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.developerAnimationListener = onDeveloperAnimationListener = new /* invalid duplicate definition of identical inner class */;
        this.mapboxMap = mapboxMap;
        this.transform = transform;
        list.add(onDeveloperAnimationListener);
        this.currentLocationEngineListener = locationEngineCallback;
        this.locationLayerController = locationLayerController;
        this.locationCameraController = locationCameraController;
        this.locationAnimatorCoordinator = locationAnimatorCoordinator;
        this.staleStateManager = staleStateManager;
        this.compassEngine = compassEngine;
        this.internalLocationEngineProvider = internalLocationEngineProvider;
        this.useSpecializedLocationLayer = bl;
        this.locationEngineRequest = locationEngineRequest;
        this.isComponentInitialized = true;
    }

    private void checkActivationState() {
        if (this.isComponentInitialized) {
            return;
        }
        throw new LocationComponentNotInitializedException();
    }

    private void disableLocationComponent() {
        this.isEnabled = false;
        this.locationLayerController.hide();
        this.onLocationLayerStop();
    }

    private void enableLocationComponent() {
        this.isEnabled = true;
        this.onLocationLayerStart();
    }

    private Location[] getTargetLocationWithIntermediates(Location location, List<Location> list) {
        int n = list.size() + 1;
        Location[] locationArray = new Location[n];
        locationArray[n - 1] = location;
        for (n = 0; n < list.size(); ++n) {
            locationArray[n] = list.get(n);
        }
        return locationArray;
    }

    private void initialize(Context context, Style object, boolean bl, LocationComponentOptions locationComponentOptions) {
        if (this.isComponentInitialized) {
            return;
        }
        this.isComponentInitialized = true;
        if (((Style)object).isFullyLoaded()) {
            this.style = object;
            this.options = locationComponentOptions;
            this.useSpecializedLocationLayer = bl;
            this.mapboxMap.addOnMapClickListener(this.onMapClickListener);
            this.mapboxMap.addOnMapLongClickListener(this.onMapLongClickListener);
            LayerSourceProvider layerSourceProvider = new LayerSourceProvider();
            LayerFeatureProvider layerFeatureProvider = new LayerFeatureProvider();
            LayerBitmapProvider layerBitmapProvider = new LayerBitmapProvider(context);
            this.locationLayerController = new LocationLayerController(this.mapboxMap, (Style)object, layerSourceProvider, layerFeatureProvider, layerBitmapProvider, locationComponentOptions, this.renderModeChangedListener, this.indicatorPositionChangedListener, bl);
            this.locationCameraController = new LocationCameraController(context, this.mapboxMap, this.transform, this.cameraTrackingChangedListener, locationComponentOptions, this.onCameraMoveInvalidateListener);
            this.locationAnimatorCoordinator = object = new LocationAnimatorCoordinator(this.mapboxMap.getProjection(), MapboxAnimatorSetProvider.getInstance(), MapboxAnimatorProvider.getInstance());
            ((LocationAnimatorCoordinator)object).setTrackingAnimationDurationMultiplier(locationComponentOptions.trackingAnimationDurationMultiplier());
            object = (WindowManager)context.getSystemService("window");
            context = (SensorManager)context.getSystemService("sensor");
            if (object != null && context != null) {
                this.compassEngine = new LocationComponentCompassEngine((WindowManager)object, (SensorManager)context);
            }
            this.staleStateManager = new StaleStateManager(this.onLocationStaleListener, locationComponentOptions);
            this.updateMapWithOptions(locationComponentOptions);
            this.setRenderMode(18);
            this.setCameraMode(8);
            this.onLocationLayerStart();
            return;
        }
        throw new IllegalStateException("Style is invalid, provide the most recently loaded one.");
    }

    private void initializeLocationEngine(Context context) {
        LocationEngine locationEngine = this.locationEngine;
        if (locationEngine != null) {
            locationEngine.removeLocationUpdates(this.currentLocationEngineListener);
        }
        this.setLocationEngine(this.internalLocationEngineProvider.getBestLocationEngine(context, false));
    }

    private void notifyUnsuccessfulCameraOperation(MapboxMap.CancelableCallback cancelableCallback, String string2) {
        if (string2 != null) {
            Logger.e(TAG, string2);
        }
        if (cancelableCallback != null) {
            cancelableCallback.onCancel();
        }
    }

    private void onLocationLayerStart() {
        if (this.isComponentInitialized && this.isComponentStarted && this.mapboxMap.getStyle() != null) {
            if (!this.isLayerReady) {
                this.isLayerReady = true;
                this.mapboxMap.addOnCameraMoveListener(this.onCameraMoveListener);
                this.mapboxMap.addOnCameraIdleListener(this.onCameraIdleListener);
                if (this.options.enableStaleState()) {
                    this.staleStateManager.onStart();
                }
            }
            if (this.isEnabled) {
                LocationEngine locationEngine = this.locationEngine;
                if (locationEngine != null) {
                    try {
                        locationEngine.requestLocationUpdates(this.locationEngineRequest, this.currentLocationEngineListener, Looper.getMainLooper());
                    }
                    catch (SecurityException securityException) {
                        Logger.e(TAG, "Unable to request location updates", securityException);
                    }
                }
                this.setCameraMode(this.locationCameraController.getCameraMode());
                if (this.options.pulseEnabled().booleanValue()) {
                    this.startPulsingLocationCircle();
                } else {
                    this.stopPulsingLocationCircle();
                }
                this.setLastLocation();
                this.updateCompassListenerState(true);
                this.setLastCompassHeading();
            }
        }
    }

    private void onLocationLayerStop() {
        if (this.isComponentInitialized && this.isLayerReady && this.isComponentStarted) {
            this.isLayerReady = false;
            this.staleStateManager.onStop();
            if (this.compassEngine != null) {
                this.updateCompassListenerState(false);
            }
            this.stopPulsingLocationCircle();
            this.locationAnimatorCoordinator.cancelAllAnimations();
            LocationEngine locationEngine = this.locationEngine;
            if (locationEngine != null) {
                locationEngine.removeLocationUpdates(this.currentLocationEngineListener);
            }
            this.mapboxMap.removeOnCameraMoveListener(this.onCameraMoveListener);
            this.mapboxMap.removeOnCameraIdleListener(this.onCameraIdleListener);
        }
    }

    private void removeCompassListener(CompassEngine compassEngine) {
        if (this.isListeningToCompass) {
            this.isListeningToCompass = false;
            compassEngine.removeCompassListener(this.compassListener);
        }
    }

    private void setLastCompassHeading() {
        CompassEngine compassEngine = this.compassEngine;
        float f = compassEngine != null ? compassEngine.getLastHeading() : 0.0f;
        this.updateCompassHeading(f);
    }

    private void setLastLocation() {
        LocationEngine locationEngine = this.locationEngine;
        if (locationEngine != null) {
            locationEngine.getLastLocation(this.lastLocationEngineListener);
        } else {
            this.updateLocation(this.getLastKnownLocation(), true);
        }
    }

    private void showLocationLayerIfHidden() {
        boolean bl = this.locationLayerController.isHidden();
        if (this.isEnabled && this.isComponentStarted && bl) {
            this.locationLayerController.show();
            if (this.options.pulseEnabled().booleanValue()) {
                this.locationLayerController.adjustPulsingCircleLayerVisibility(true);
            }
        }
    }

    private void startPulsingLocationCircle() {
        if (this.isEnabled && this.isLayerReady) {
            this.locationAnimatorCoordinator.startLocationComponentCirclePulsing(this.options);
            this.locationLayerController.adjustPulsingCircleLayerVisibility(true);
        }
    }

    private void stopPulsingLocationCircle() {
        this.locationAnimatorCoordinator.stopPulsingCircleAnimation();
        this.locationLayerController.adjustPulsingCircleLayerVisibility(false);
    }

    private void updateAccuracyRadius(Location location, boolean bl) {
        float f = location == null ? 0.0f : (this.useSpecializedLocationLayer ? location.getAccuracy() : Utils.calculateZoomLevelRadius(this.mapboxMap, location));
        this.locationAnimatorCoordinator.feedNewAccuracyRadius(f, bl);
    }

    private void updateAnimatorListenerHolders() {
        Object object = new HashSet<AnimatorListenerHolder>();
        object.addAll(this.locationLayerController.getAnimationListeners());
        object.addAll(this.locationCameraController.getAnimationListeners());
        this.locationAnimatorCoordinator.updateAnimatorListenerHolders((Set<AnimatorListenerHolder>)object);
        LocationAnimatorCoordinator locationAnimatorCoordinator = this.locationAnimatorCoordinator;
        object = this.mapboxMap.getCameraPosition();
        boolean bl = this.locationCameraController.getCameraMode() == 36;
        locationAnimatorCoordinator.resetAllCameraAnimations((CameraPosition)object, bl);
        this.locationAnimatorCoordinator.resetAllLayerAnimations();
    }

    private void updateCompassHeading(float f) {
        this.locationAnimatorCoordinator.feedNewCompassBearing(f, this.mapboxMap.getCameraPosition());
    }

    private void updateCompassListenerState(boolean bl) {
        CompassEngine compassEngine = this.compassEngine;
        if (compassEngine != null) {
            if (!bl) {
                this.removeCompassListener(compassEngine);
                return;
            }
            if (this.isComponentInitialized && this.isComponentStarted && this.isEnabled && this.isLayerReady) {
                if (!this.locationCameraController.isConsumingCompass() && !this.locationLayerController.isConsumingCompass()) {
                    this.removeCompassListener(this.compassEngine);
                } else if (!this.isListeningToCompass) {
                    this.isListeningToCompass = true;
                    this.compassEngine.addCompassListener(this.compassListener);
                }
            }
        }
    }

    private void updateLayerOffsets(boolean bl) {
        if (this.useSpecializedLocationLayer) {
            return;
        }
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        if (this.lastCameraPosition != null && !bl) {
            if (cameraPosition.bearing != this.lastCameraPosition.bearing) {
                this.locationLayerController.cameraBearingUpdated(cameraPosition.bearing);
            }
            if (cameraPosition.tilt != this.lastCameraPosition.tilt) {
                this.locationLayerController.cameraTiltUpdated(cameraPosition.tilt);
            }
            if (cameraPosition.zoom != this.lastCameraPosition.zoom) {
                this.updateAccuracyRadius(this.getLastKnownLocation(), true);
            }
            this.lastCameraPosition = cameraPosition;
            return;
        }
        this.lastCameraPosition = cameraPosition;
        this.locationLayerController.cameraBearingUpdated(cameraPosition.bearing);
        this.locationLayerController.cameraTiltUpdated(cameraPosition.tilt);
        this.updateAccuracyRadius(this.getLastKnownLocation(), true);
    }

    private void updateLocation(Location location, boolean bl) {
        if (location != null) {
            this.updateLocation(new LocationUpdate.Builder().location(location).build(), bl);
        }
    }

    private void updateLocation(LocationUpdate locationUpdate, boolean bl) {
        if (!this.isLayerReady) {
            this.lastLocation = locationUpdate.getLocation();
            return;
        }
        long l = SystemClock.elapsedRealtime();
        if (l - this.lastUpdateTime < this.fastestInterval) {
            return;
        }
        this.lastUpdateTime = l;
        this.showLocationLayerIfHidden();
        if (!bl) {
            this.staleStateManager.updateLatestLocationTime();
        }
        CameraPosition cameraPosition = this.mapboxMap.getCameraPosition();
        boolean bl2 = this.getCameraMode() == 36;
        LocationAnimatorCoordinator locationAnimatorCoordinator = this.locationAnimatorCoordinator;
        Location[] locationArray = this.getTargetLocationWithIntermediates(locationUpdate.getLocation(), locationUpdate.getIntermediatePoints());
        Long l2 = bl ? Long.valueOf(0L) : locationUpdate.getAnimationDuration();
        locationAnimatorCoordinator.feedNewLocation(locationArray, cameraPosition, bl2, l2);
        this.updateAccuracyRadius(locationUpdate.getLocation(), false);
        this.lastLocation = locationUpdate.getLocation();
    }

    private void updateMapWithOptions(LocationComponentOptions object) {
        if ((object = (Object)((LocationComponentOptions)object).padding()) != null) {
            this.mapboxMap.setPadding((int)object[0], (int)object[1], (int)object[2], (int)object[3]);
        }
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2) {
        this.activateLocationComponent(context, style2, LocationComponentOptions.createFromAttributes(context, R.style.mapbox_LocationComponent));
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, int n) {
        this.activateLocationComponent(context, style2, LocationComponentOptions.createFromAttributes(context, n));
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine) {
        this.activateLocationComponent(context, style2, locationEngine, R.style.mapbox_LocationComponent);
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine, int n) {
        this.activateLocationComponent(context, style2, locationEngine, LocationComponentOptions.createFromAttributes(context, n));
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine, LocationEngineRequest locationEngineRequest) {
        this.activateLocationComponent(context, style2, locationEngine, locationEngineRequest, R.style.mapbox_LocationComponent);
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine, LocationEngineRequest locationEngineRequest, int n) {
        this.activateLocationComponent(context, style2, locationEngine, locationEngineRequest, LocationComponentOptions.createFromAttributes(context, n));
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine, LocationEngineRequest locationEngineRequest, LocationComponentOptions locationComponentOptions) {
        this.initialize(context, style2, false, locationComponentOptions);
        this.setLocationEngineRequest(locationEngineRequest);
        this.setLocationEngine(locationEngine);
        this.applyStyle(locationComponentOptions);
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationEngine locationEngine, LocationComponentOptions locationComponentOptions) {
        this.initialize(context, style2, false, locationComponentOptions);
        this.setLocationEngine(locationEngine);
        this.applyStyle(locationComponentOptions);
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, LocationComponentOptions locationComponentOptions) {
        this.initialize(context, style2, false, locationComponentOptions);
        this.initializeLocationEngine(context);
        this.applyStyle(locationComponentOptions);
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, boolean bl) {
        if (bl) {
            this.activateLocationComponent(context, style2, R.style.mapbox_LocationComponent);
        } else {
            this.activateLocationComponent(context, style2, null, R.style.mapbox_LocationComponent);
        }
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, boolean bl, LocationEngineRequest locationEngineRequest) {
        this.setLocationEngineRequest(locationEngineRequest);
        if (bl) {
            this.activateLocationComponent(context, style2, R.style.mapbox_LocationComponent);
        } else {
            this.activateLocationComponent(context, style2, null, R.style.mapbox_LocationComponent);
        }
    }

    @Deprecated
    public void activateLocationComponent(Context context, Style style2, boolean bl, LocationEngineRequest locationEngineRequest, LocationComponentOptions locationComponentOptions) {
        this.setLocationEngineRequest(locationEngineRequest);
        if (bl) {
            this.activateLocationComponent(context, style2, locationComponentOptions);
        } else {
            this.activateLocationComponent(context, style2, null, locationComponentOptions);
        }
    }

    public void activateLocationComponent(LocationComponentActivationOptions locationComponentActivationOptions) {
        LocationComponentOptions locationComponentOptions = locationComponentActivationOptions.locationComponentOptions();
        Object object = locationComponentOptions;
        if (locationComponentOptions == null) {
            int n;
            int n2 = n = locationComponentActivationOptions.styleRes();
            if (n == 0) {
                n2 = R.style.mapbox_LocationComponent;
            }
            object = LocationComponentOptions.createFromAttributes(locationComponentActivationOptions.context(), n2);
        }
        this.initialize(locationComponentActivationOptions.context(), locationComponentActivationOptions.style(), locationComponentActivationOptions.useSpecializedLocationLayer(), (LocationComponentOptions)object);
        this.applyStyle((LocationComponentOptions)object);
        object = locationComponentActivationOptions.locationEngineRequest();
        if (object != null) {
            this.setLocationEngineRequest((LocationEngineRequest)object);
        }
        if ((object = locationComponentActivationOptions.locationEngine()) != null) {
            this.setLocationEngine((LocationEngine)object);
        } else if (locationComponentActivationOptions.useDefaultLocationEngine()) {
            this.initializeLocationEngine(locationComponentActivationOptions.context());
        } else {
            this.setLocationEngine(null);
        }
    }

    public void addOnCameraTrackingChangedListener(OnCameraTrackingChangedListener onCameraTrackingChangedListener) {
        this.onCameraTrackingChangedListeners.add(onCameraTrackingChangedListener);
    }

    public void addOnIndicatorPositionChangedListener(OnIndicatorPositionChangedListener onIndicatorPositionChangedListener) {
        this.onIndicatorPositionChangedListener.add(onIndicatorPositionChangedListener);
    }

    public void addOnLocationClickListener(OnLocationClickListener onLocationClickListener) {
        this.onLocationClickListeners.add(onLocationClickListener);
    }

    public void addOnLocationLongClickListener(OnLocationLongClickListener onLocationLongClickListener) {
        this.onLocationLongClickListeners.add(onLocationLongClickListener);
    }

    public void addOnLocationStaleListener(OnLocationStaleListener onLocationStaleListener) {
        this.onLocationStaleListeners.add(onLocationStaleListener);
    }

    public void addOnRenderModeChangedListener(OnRenderModeChangedListener onRenderModeChangedListener) {
        this.onRenderModeChangedListeners.add(onRenderModeChangedListener);
    }

    public void applyStyle(Context context, int n) {
        this.checkActivationState();
        this.applyStyle(LocationComponentOptions.createFromAttributes(context, n));
    }

    public void applyStyle(LocationComponentOptions locationComponentOptions) {
        this.checkActivationState();
        this.options = locationComponentOptions;
        if (this.mapboxMap.getStyle() != null) {
            this.locationLayerController.applyStyle(locationComponentOptions);
            this.locationCameraController.initializeOptions(locationComponentOptions);
            this.staleStateManager.setEnabled(locationComponentOptions.enableStaleState());
            this.staleStateManager.setDelayTime(locationComponentOptions.staleStateTimeout());
            this.locationAnimatorCoordinator.setTrackingAnimationDurationMultiplier(locationComponentOptions.trackingAnimationDurationMultiplier());
            this.locationAnimatorCoordinator.setCompassAnimationEnabled(locationComponentOptions.compassAnimationEnabled());
            this.locationAnimatorCoordinator.setAccuracyAnimationEnabled(locationComponentOptions.accuracyAnimationEnabled());
            if (locationComponentOptions.pulseEnabled().booleanValue()) {
                this.startPulsingLocationCircle();
            } else {
                this.stopPulsingLocationCircle();
            }
            this.updateMapWithOptions(locationComponentOptions);
        }
    }

    public void cancelPaddingWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelPaddingAnimation();
    }

    public void cancelTiltWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelTiltAnimation();
    }

    public void cancelZoomWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelZoomAnimation();
    }

    @Deprecated
    public void forceLocationUpdate(Location location) {
        this.checkActivationState();
        this.updateLocation(location, false);
    }

    public void forceLocationUpdate(LocationUpdate locationUpdate) {
        this.updateLocation(locationUpdate, false);
    }

    @Deprecated
    public void forceLocationUpdate(List<Location> object, boolean bl) {
        this.checkActivationState();
        if (object != null && object.size() >= 1) {
            Location location = object.get(object.size() - 1);
            if (location == null) {
                return;
            }
            object = new LocationUpdate.Builder().location(location).intermediatePoints(object.subList(0, object.size() - 1));
            if (bl) {
                long l;
                long l2;
                if (Build.VERSION.SDK_INT >= 17) {
                    long l3;
                    l2 = SystemClock.elapsedRealtimeNanos();
                    l = l3 = location.getElapsedRealtimeNanos();
                    if (l3 == 0L) {
                        l2 = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
                        l = TimeUnit.MILLISECONDS.toNanos(location.getTime());
                    }
                } else {
                    l2 = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
                    l = TimeUnit.MILLISECONDS.toNanos(location.getTime());
                }
                if (l2 > l) {
                    ((LocationUpdate.Builder)object).animationDuration(0L);
                    Logger.e("LocationAnimatorCoordinator", "Lookahead enabled, but the target location's timestamp is smaller than current timestamp");
                } else {
                    ((LocationUpdate.Builder)object).animationDuration(l - l2);
                }
            }
            this.updateLocation(((LocationUpdate.Builder)object).build(), false);
        }
    }

    public int getCameraMode() {
        this.checkActivationState();
        return this.locationCameraController.getCameraMode();
    }

    public CompassEngine getCompassEngine() {
        this.checkActivationState();
        return this.compassEngine;
    }

    public Location getLastKnownLocation() {
        this.checkActivationState();
        return this.lastLocation;
    }

    public LocationComponentOptions getLocationComponentOptions() {
        this.checkActivationState();
        return this.options;
    }

    public LocationEngine getLocationEngine() {
        this.checkActivationState();
        return this.locationEngine;
    }

    public LocationEngineRequest getLocationEngineRequest() {
        this.checkActivationState();
        return this.locationEngineRequest;
    }

    public int getRenderMode() {
        this.checkActivationState();
        return this.locationLayerController.getRenderMode();
    }

    public boolean isLocationComponentActivated() {
        return this.isComponentInitialized;
    }

    public boolean isLocationComponentEnabled() {
        this.checkActivationState();
        return this.isEnabled;
    }

    public void onDestroy() {
    }

    public void onFinishLoadingStyle() {
        if (this.isComponentInitialized) {
            Style style2;
            this.style = style2 = this.mapboxMap.getStyle();
            this.locationLayerController.initializeComponents(style2, this.options);
            this.locationCameraController.initializeOptions(this.options);
            this.onLocationLayerStart();
        }
    }

    public void onStart() {
        this.isComponentStarted = true;
        this.onLocationLayerStart();
    }

    public void onStartLoadingMap() {
        this.onLocationLayerStop();
    }

    public void onStop() {
        this.onLocationLayerStop();
        this.isComponentStarted = false;
    }

    public void paddingWhileTracking(double[] dArray) {
        this.paddingWhileTracking(dArray, 750L, null);
    }

    public void paddingWhileTracking(double[] dArray, long l) {
        this.paddingWhileTracking(dArray, l, null);
    }

    public void paddingWhileTracking(double[] dArray, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, String.format("%s%s", "LocationComponent#paddingWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, "LocationComponent#paddingWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewPadding(dArray, this.mapboxMap.getCameraPosition(), l, cancelableCallback);
    }

    public void removeOnCameraTrackingChangedListener(OnCameraTrackingChangedListener onCameraTrackingChangedListener) {
        this.onCameraTrackingChangedListeners.remove(onCameraTrackingChangedListener);
    }

    public void removeOnIndicatorPositionChangedListener(OnIndicatorPositionChangedListener onIndicatorPositionChangedListener) {
        this.onIndicatorPositionChangedListener.remove(onIndicatorPositionChangedListener);
    }

    public void removeOnLocationClickListener(OnLocationClickListener onLocationClickListener) {
        this.onLocationClickListeners.remove(onLocationClickListener);
    }

    public void removeOnLocationLongClickListener(OnLocationLongClickListener onLocationLongClickListener) {
        this.onLocationLongClickListeners.remove(onLocationLongClickListener);
    }

    public void removeOnLocationStaleListener(OnLocationStaleListener onLocationStaleListener) {
        this.onLocationStaleListeners.remove(onLocationStaleListener);
    }

    public void removeRenderModeChangedListener(OnRenderModeChangedListener onRenderModeChangedListener) {
        this.onRenderModeChangedListeners.remove(onRenderModeChangedListener);
    }

    public void setCameraMode(int n) {
        this.setCameraMode(n, null);
    }

    public void setCameraMode(int n, long l, Double d, Double d2, Double d3, OnLocationCameraTransitionListener onLocationCameraTransitionListener) {
        this.checkActivationState();
        this.locationCameraController.setCameraMode(n, this.lastLocation, l, d, d2, d3, new CameraTransitionListener(onLocationCameraTransitionListener));
        this.updateCompassListenerState(true);
    }

    public void setCameraMode(int n, OnLocationCameraTransitionListener onLocationCameraTransitionListener) {
        this.setCameraMode(n, 750L, null, null, null, onLocationCameraTransitionListener);
    }

    public void setCompassEngine(CompassEngine compassEngine) {
        this.checkActivationState();
        if (this.compassEngine != null) {
            this.updateCompassListenerState(false);
        }
        this.compassEngine = compassEngine;
        this.updateCompassListenerState(true);
    }

    public void setLocationComponentEnabled(boolean bl) {
        this.checkActivationState();
        if (bl) {
            this.enableLocationComponent();
        } else {
            this.disableLocationComponent();
        }
        this.locationCameraController.setEnabled(bl);
    }

    public void setLocationEngine(LocationEngine locationEngine) {
        this.checkActivationState();
        LocationEngine locationEngine2 = this.locationEngine;
        if (locationEngine2 != null) {
            locationEngine2.removeLocationUpdates(this.currentLocationEngineListener);
            this.locationEngine = null;
        }
        if (locationEngine != null) {
            this.fastestInterval = this.locationEngineRequest.getFastestInterval();
            this.locationEngine = locationEngine;
            if (this.isLayerReady && this.isEnabled) {
                this.setLastLocation();
                locationEngine.requestLocationUpdates(this.locationEngineRequest, this.currentLocationEngineListener, Looper.getMainLooper());
            }
        } else {
            this.fastestInterval = 0L;
        }
    }

    public void setLocationEngineRequest(LocationEngineRequest locationEngineRequest) {
        this.checkActivationState();
        this.locationEngineRequest = locationEngineRequest;
        this.setLocationEngine(this.locationEngine);
    }

    public void setMaxAnimationFps(int n) {
        this.checkActivationState();
        this.locationAnimatorCoordinator.setMaxAnimationFps(n);
    }

    public void setRenderMode(int n) {
        this.checkActivationState();
        if (this.lastLocation != null && n == 8) {
            this.locationAnimatorCoordinator.cancelAndRemoveGpsBearingAnimation();
            this.locationLayerController.setGpsBearing(this.lastLocation.getBearing());
        }
        this.locationLayerController.setRenderMode(n);
        this.updateLayerOffsets(true);
        this.updateCompassListenerState(true);
    }

    public void tiltWhileTracking(double d) {
        this.checkActivationState();
        this.tiltWhileTracking(d, 1250L, null);
    }

    public void tiltWhileTracking(double d, long l) {
        this.checkActivationState();
        this.tiltWhileTracking(d, l, null);
    }

    public void tiltWhileTracking(double d, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, String.format("%s%s", "LocationComponent#tiltWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, "LocationComponent#tiltWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewTilt(d, this.mapboxMap.getCameraPosition(), l, cancelableCallback);
    }

    public void zoomWhileTracking(double d) {
        this.checkActivationState();
        this.zoomWhileTracking(d, 750L, null);
    }

    public void zoomWhileTracking(double d, long l) {
        this.checkActivationState();
        this.zoomWhileTracking(d, l, null);
    }

    public void zoomWhileTracking(double d, long l, MapboxMap.CancelableCallback cancelableCallback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, String.format("%s%s", "LocationComponent#zoomWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(cancelableCallback, "LocationComponent#zoomWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewZoomLevel(d, this.mapboxMap.getCameraPosition(), l, cancelableCallback);
    }

    private class CameraTransitionListener
    implements OnLocationCameraTransitionListener {
        private final OnLocationCameraTransitionListener externalListener;

        private CameraTransitionListener(OnLocationCameraTransitionListener onLocationCameraTransitionListener) {
            this.externalListener = onLocationCameraTransitionListener;
        }

        private void reset(int n) {
            LocationAnimatorCoordinator locationAnimatorCoordinator = LocationComponent.this.locationAnimatorCoordinator;
            CameraPosition cameraPosition = LocationComponent.this.mapboxMap.getCameraPosition();
            boolean bl = n == 36;
            locationAnimatorCoordinator.resetAllCameraAnimations(cameraPosition, bl);
        }

        @Override
        public void onLocationCameraTransitionCanceled(int n) {
            OnLocationCameraTransitionListener onLocationCameraTransitionListener = this.externalListener;
            if (onLocationCameraTransitionListener != null) {
                onLocationCameraTransitionListener.onLocationCameraTransitionCanceled(n);
            }
            this.reset(n);
        }

        @Override
        public void onLocationCameraTransitionFinished(int n) {
            OnLocationCameraTransitionListener onLocationCameraTransitionListener = this.externalListener;
            if (onLocationCameraTransitionListener != null) {
                onLocationCameraTransitionListener.onLocationCameraTransitionFinished(n);
            }
            this.reset(n);
        }
    }

    static final class CurrentLocationEngineCallback
    implements LocationEngineCallback<LocationEngineResult> {
        private final WeakReference<LocationComponent> componentWeakReference;

        CurrentLocationEngineCallback(LocationComponent locationComponent) {
            this.componentWeakReference = new WeakReference<LocationComponent>(locationComponent);
        }

        @Override
        public void onFailure(Exception exception) {
            Logger.e(LocationComponent.TAG, "Failed to obtain location update", exception);
        }

        @Override
        public void onSuccess(LocationEngineResult locationEngineResult) {
            LocationComponent locationComponent = (LocationComponent)this.componentWeakReference.get();
            if (locationComponent != null) {
                locationComponent.updateLocation(locationEngineResult.getLastLocation(), false);
            }
        }
    }

    static class InternalLocationEngineProvider {
        InternalLocationEngineProvider() {
        }

        LocationEngine getBestLocationEngine(Context context, boolean bl) {
            return LocationEngineProvider.getBestLocationEngine(context, bl);
        }
    }

    static final class LastLocationEngineCallback
    implements LocationEngineCallback<LocationEngineResult> {
        private final WeakReference<LocationComponent> componentWeakReference;

        LastLocationEngineCallback(LocationComponent locationComponent) {
            this.componentWeakReference = new WeakReference<LocationComponent>(locationComponent);
        }

        @Override
        public void onFailure(Exception exception) {
            Logger.e(LocationComponent.TAG, "Failed to obtain last location update", exception);
        }

        @Override
        public void onSuccess(LocationEngineResult locationEngineResult) {
            LocationComponent locationComponent = (LocationComponent)this.componentWeakReference.get();
            if (locationComponent != null) {
                locationComponent.updateLocation(locationEngineResult.getLastLocation(), true);
            }
        }
    }
}

