/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.SystemClock;
import android.view.WindowManager;
import com.mapbox.mapboxsdk.location.CompassEngine;
import com.mapbox.mapboxsdk.location.CompassListener;
import com.mapbox.mapboxsdk.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class LocationComponentCompassEngine
implements CompassEngine,
SensorEventListener {
    private static final float ALPHA = 0.45f;
    static final int SENSOR_DELAY_MICROS = 100000;
    private static final String TAG = "Mbgl-LocationComponentCompassEngine";
    private final List<CompassListener> compassListeners = new ArrayList<CompassListener>();
    private Sensor compassSensor;
    private long compassUpdateNextTimestamp;
    private Sensor gravitySensor;
    private float[] gravityValues;
    private int lastAccuracySensorStatus;
    private float lastHeading;
    private Sensor magneticFieldSensor;
    private float[] magneticValues;
    private float[] rotationMatrix;
    private float[] rotationVectorValue;
    private final SensorManager sensorManager;
    private float[] truncatedRotationVectorValue = new float[4];
    private final WindowManager windowManager;

    LocationComponentCompassEngine(WindowManager windowManager, SensorManager sensorManager) {
        this.rotationMatrix = new float[9];
        this.gravityValues = new float[3];
        this.magneticValues = new float[3];
        this.windowManager = windowManager;
        this.sensorManager = sensorManager;
        windowManager = sensorManager.getDefaultSensor(11);
        this.compassSensor = windowManager;
        if (windowManager == null) {
            Logger.d(TAG, "Rotation vector sensor not supported on device, falling back to accelerometer and magnetic field.");
            this.gravitySensor = sensorManager.getDefaultSensor(1);
            this.magneticFieldSensor = sensorManager.getDefaultSensor(2);
        }
    }

    private float[] getRotationVectorFromSensorEvent(SensorEvent sensorEvent) {
        if (sensorEvent.values.length > 4) {
            System.arraycopy(sensorEvent.values, 0, this.truncatedRotationVectorValue, 0, 4);
            return this.truncatedRotationVectorValue;
        }
        return sensorEvent.values;
    }

    private boolean isCompassSensorAvailable() {
        boolean bl = this.compassSensor != null;
        return bl;
    }

    private float[] lowPassFilter(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            return fArray;
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray2[i] + (fArray[i] - fArray2[i]) * 0.45f;
        }
        return fArray2;
    }

    private void notifyCompassChangeListeners(float f) {
        Iterator<CompassListener> iterator2 = this.compassListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onCompassChanged(f);
        }
        this.lastHeading = f;
    }

    private void registerSensorListeners() {
        if (this.isCompassSensorAvailable()) {
            this.sensorManager.registerListener((SensorEventListener)this, this.compassSensor, 100000);
        } else {
            this.sensorManager.registerListener((SensorEventListener)this, this.gravitySensor, 100000);
            this.sensorManager.registerListener((SensorEventListener)this, this.magneticFieldSensor, 100000);
        }
    }

    private void unregisterSensorListeners() {
        if (this.isCompassSensorAvailable()) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.compassSensor);
        } else {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.gravitySensor);
            this.sensorManager.unregisterListener((SensorEventListener)this, this.magneticFieldSensor);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateOrientation() {
        block18: {
            block20: {
                block21: {
                    block22: {
                        block19: {
                            var1_1 = SystemClock.elapsedRealtime();
                            if (var1_1 < this.compassUpdateNextTimestamp) {
                                return;
                            }
                            var3_2 = this.rotationVectorValue;
                            if (var3_2 != null) {
                                SensorManager.getRotationMatrixFromVector((float[])this.rotationMatrix, (float[])var3_2);
                            } else {
                                SensorManager.getRotationMatrix((float[])this.rotationMatrix, null, (float[])this.gravityValues, (float[])this.magneticValues);
                            }
                            var4_3 = this.windowManager.getDefaultDisplay().getRotation();
                            var5_4 = 130;
                            var6_5 = 129;
                            if (var4_3 != 1) {
                                if (var4_3 != 2) {
                                    if (var4_3 != 3) {
                                        var4_3 = 1;
                                        var7_6 = 2;
                                    } else {
                                        var4_3 = 130;
                                        var7_6 = 1;
                                    }
                                } else {
                                    var4_3 = 129;
                                    var7_6 = 130;
                                }
                            } else {
                                var4_3 = 2;
                                var7_6 = 129;
                            }
                            var3_2 = new float[9];
                            SensorManager.remapCoordinateSystem((float[])this.rotationMatrix, (int)var4_3, (int)var7_6, (float[])var3_2);
                            var8_7 = new float[3];
                            SensorManager.getOrientation((float[])var3_2, (float[])var8_7);
                            if (!((double)var8_7[1] < -0.7853981633974483)) break block19;
                            var4_3 = this.windowManager.getDefaultDisplay().getRotation();
                            if (var4_3 != 1) {
                                if (var4_3 != 2) {
                                    if (var4_3 != 3) {
                                        var4_3 = 1;
lbl39:
                                        // 2 sources

                                        while (true) {
                                            var7_6 = 3;
                                            break block18;
                                            break;
                                        }
                                    }
                                    var4_3 = 131;
lbl43:
                                    // 3 sources

                                    while (true) {
                                        var7_6 = 1;
                                        break block18;
                                        break;
                                    }
                                }
                                var4_3 = 129;
lbl47:
                                // 2 sources

                                while (true) {
                                    var7_6 = 131;
                                    break block18;
                                    break;
                                }
                            }
                            var4_3 = 3;
                            var7_6 = var6_5;
                            break block18;
                        }
                        if (!((double)var8_7[1] > 0.7853981633974483)) break block20;
                        var4_3 = this.windowManager.getDefaultDisplay().getRotation();
                        if (var4_3 == 1) break block21;
                        if (var4_3 == 2) break block22;
                        if (var4_3 != 3) {
                            var4_3 = 1;
                            ** continue;
                        }
                        var4_3 = 3;
                        ** GOTO lbl43
                    }
                    var4_3 = 129;
                    ** while (true)
                }
                var4_3 = 131;
                var7_6 = var6_5;
                break block18;
            }
            if (!((double)Math.abs(var8_7[2]) > 1.5707963267948966)) break block18;
            var9_8 = this.windowManager.getDefaultDisplay().getRotation();
            var4_3 = var5_4;
            var7_6 = var6_5;
            if (var9_8 == 1) break block18;
            if (var9_8 == 2) ** GOTO lbl83
            if (var9_8 != 3) {
                var4_3 = 1;
                var7_6 = 130;
            } else {
                var4_3 = 2;
                ** continue;
lbl83:
                // 1 sources

                var4_3 = 129;
                var7_6 = 2;
            }
        }
        SensorManager.remapCoordinateSystem((float[])this.rotationMatrix, (int)var4_3, (int)var7_6, (float[])var3_2);
        SensorManager.getOrientation((float[])var3_2, (float[])var8_7);
        this.notifyCompassChangeListeners((float)Math.toDegrees(var8_7[0]));
        this.compassUpdateNextTimestamp = var1_1 + 500L;
    }

    @Override
    public void addCompassListener(CompassListener compassListener) {
        if (this.compassListeners.isEmpty()) {
            this.registerSensorListeners();
        }
        this.compassListeners.add(compassListener);
    }

    @Override
    public int getLastAccuracySensorStatus() {
        return this.lastAccuracySensorStatus;
    }

    @Override
    public float getLastHeading() {
        return this.lastHeading;
    }

    public void onAccuracyChanged(Sensor object, int n) {
        if (this.lastAccuracySensorStatus != n) {
            object = this.compassListeners.iterator();
            while (object.hasNext()) {
                ((CompassListener)object.next()).onCompassAccuracyChange(n);
            }
            this.lastAccuracySensorStatus = n;
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.lastAccuracySensorStatus == 0) {
            Logger.d(TAG, "Compass sensor is unreliable, device calibration is needed.");
        }
        if (sensorEvent.sensor.getType() == 11) {
            this.rotationVectorValue = this.getRotationVectorFromSensorEvent(sensorEvent);
            this.updateOrientation();
        } else if (sensorEvent.sensor.getType() == 1) {
            this.gravityValues = this.lowPassFilter(this.getRotationVectorFromSensorEvent(sensorEvent), this.gravityValues);
            this.updateOrientation();
        } else if (sensorEvent.sensor.getType() == 2) {
            this.magneticValues = this.lowPassFilter(this.getRotationVectorFromSensorEvent(sensorEvent), this.magneticValues);
            this.updateOrientation();
        }
    }

    @Override
    public void removeCompassListener(CompassListener compassListener) {
        this.compassListeners.remove(compassListener);
        if (this.compassListeners.isEmpty()) {
            this.unregisterSensorListeners();
        }
    }
}

