/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

class LocationIndicatorLayer
extends Layer {
    LocationIndicatorLayer(long l) {
        super(l);
    }

    public LocationIndicatorLayer(String string2) {
        this.initialize(string2);
    }

    private native Object nativeGetAccuracyRadius();

    private native Object nativeGetAccuracyRadiusBorderColor();

    private native TransitionOptions nativeGetAccuracyRadiusBorderColorTransition();

    private native Object nativeGetAccuracyRadiusColor();

    private native TransitionOptions nativeGetAccuracyRadiusColorTransition();

    private native TransitionOptions nativeGetAccuracyRadiusTransition();

    private native Object nativeGetBearing();

    private native Object nativeGetBearingImage();

    private native Object nativeGetBearingImageSize();

    private native TransitionOptions nativeGetBearingImageSizeTransition();

    private native Object nativeGetImagePitchDisplacement();

    private native Object nativeGetImageTiltDisplacement();

    private native Object nativeGetLocation();

    private native TransitionOptions nativeGetLocationTransition();

    private native Object nativeGetPerspectiveCompensation();

    private native Object nativeGetShadowImage();

    private native Object nativeGetShadowImageSize();

    private native TransitionOptions nativeGetShadowImageSizeTransition();

    private native Object nativeGetTopImage();

    private native Object nativeGetTopImageSize();

    private native TransitionOptions nativeGetTopImageSizeTransition();

    private native void nativeSetAccuracyRadiusBorderColorTransition(long var1, long var3);

    private native void nativeSetAccuracyRadiusColorTransition(long var1, long var3);

    private native void nativeSetAccuracyRadiusTransition(long var1, long var3);

    private native void nativeSetBearingImageSizeTransition(long var1, long var3);

    private native void nativeSetLocationTransition(long var1, long var3);

    private native void nativeSetShadowImageSizeTransition(long var1, long var3);

    private native void nativeSetTopImageSizeTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;

    public PropertyValue<Float> getAccuracyRadius() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius", this.nativeGetAccuracyRadius());
    }

    public PropertyValue<String> getAccuracyRadiusBorderColor() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius-border-color", this.nativeGetAccuracyRadiusBorderColor());
    }

    public int getAccuracyRadiusBorderColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getAccuracyRadiusBorderColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("accuracy-radius-border-color was set as a Function");
    }

    public TransitionOptions getAccuracyRadiusBorderColorTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusBorderColorTransition();
    }

    public PropertyValue<String> getAccuracyRadiusColor() {
        this.checkThread();
        return new PropertyValue<Object>("accuracy-radius-color", this.nativeGetAccuracyRadiusColor());
    }

    public int getAccuracyRadiusColorAsInt() {
        this.checkThread();
        PropertyValue<String> propertyValue = this.getAccuracyRadiusColor();
        if (propertyValue.isValue()) {
            return ColorUtils.rgbaToColor(propertyValue.getValue());
        }
        throw new RuntimeException("accuracy-radius-color was set as a Function");
    }

    public TransitionOptions getAccuracyRadiusColorTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusColorTransition();
    }

    public TransitionOptions getAccuracyRadiusTransition() {
        this.checkThread();
        return this.nativeGetAccuracyRadiusTransition();
    }

    public PropertyValue<Double> getBearing() {
        this.checkThread();
        return new PropertyValue<Object>("bearing", this.nativeGetBearing());
    }

    public PropertyValue<String> getBearingImage() {
        this.checkThread();
        return new PropertyValue<Object>("bearing-image", this.nativeGetBearingImage());
    }

    public PropertyValue<Float> getBearingImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("bearing-image-size", this.nativeGetBearingImageSize());
    }

    public TransitionOptions getBearingImageSizeTransition() {
        this.checkThread();
        return this.nativeGetBearingImageSizeTransition();
    }

    public PropertyValue<Float> getImagePitchDisplacement() {
        this.checkThread();
        return new PropertyValue<Object>("image-pitch-displacement", this.nativeGetImagePitchDisplacement());
    }

    @Deprecated
    public PropertyValue<Float> getImageTiltDisplacement() {
        this.checkThread();
        return new PropertyValue<Object>("image-pitch-displacement", this.nativeGetImageTiltDisplacement());
    }

    public PropertyValue<Double[]> getLocation() {
        this.checkThread();
        return new PropertyValue<Object>("location", this.nativeGetLocation());
    }

    public TransitionOptions getLocationTransition() {
        this.checkThread();
        return this.nativeGetLocationTransition();
    }

    public PropertyValue<Float> getPerspectiveCompensation() {
        this.checkThread();
        return new PropertyValue<Object>("perspective-compensation", this.nativeGetPerspectiveCompensation());
    }

    public PropertyValue<String> getShadowImage() {
        this.checkThread();
        return new PropertyValue<Object>("shadow-image", this.nativeGetShadowImage());
    }

    public PropertyValue<Float> getShadowImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("shadow-image-size", this.nativeGetShadowImageSize());
    }

    public TransitionOptions getShadowImageSizeTransition() {
        this.checkThread();
        return this.nativeGetShadowImageSizeTransition();
    }

    public PropertyValue<String> getTopImage() {
        this.checkThread();
        return new PropertyValue<Object>("top-image", this.nativeGetTopImage());
    }

    public PropertyValue<Float> getTopImageSize() {
        this.checkThread();
        return new PropertyValue<Object>("top-image-size", this.nativeGetTopImageSize());
    }

    public TransitionOptions getTopImageSizeTransition() {
        this.checkThread();
        return this.nativeGetTopImageSizeTransition();
    }

    protected native void initialize(String var1);

    public void setAccuracyRadiusBorderColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetAccuracyRadiusBorderColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setAccuracyRadiusColorTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetAccuracyRadiusColorTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setAccuracyRadiusTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetAccuracyRadiusTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setBearingImageSizeTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetBearingImageSizeTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setLocationTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetLocationTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setShadowImageSizeTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetShadowImageSizeTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public void setTopImageSizeTransition(TransitionOptions transitionOptions) {
        this.checkThread();
        this.nativeSetTopImageSizeTransition(transitionOptions.getDuration(), transitionOptions.getDelay());
    }

    public LocationIndicatorLayer withProperties(PropertyValue<?> ... propertyValueArray) {
        this.setProperties(propertyValueArray);
        return this;
    }
}

