/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import android.graphics.PointF;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.AnimatorListenerHolder;
import com.mapbox.mapboxsdk.location.LayerBitmapProvider;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.location.MapboxAnimator;
import com.mapbox.mapboxsdk.location.OnIndicatorPositionChangedListener;
import com.mapbox.mapboxsdk.location.OnRenderModeChangedListener;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import java.util.HashSet;
import java.util.Set;

final class LocationLayerController {
    private static final String TAG = "Mbgl-LocationLayerController";
    private final MapboxAnimator.AnimationsValueChangeListener<Float> accuracyValueListener;
    private final LayerBitmapProvider bitmapProvider;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> compassBearingValueListener;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> gpsBearingValueListener;
    private final OnIndicatorPositionChangedListener internalIndicatorPositionChangedListener;
    private final OnRenderModeChangedListener internalRenderModeChangedListener;
    private boolean isHidden = true;
    private boolean isStale;
    private final MapboxAnimator.AnimationsValueChangeListener<LatLng> latLngValueListener = new MapboxAnimator.AnimationsValueChangeListener<LatLng>(){

        @Override
        public void onNewAnimationValue(LatLng latLng) {
            LocationLayerController.this.locationLayerRenderer.setLatLng(latLng);
            LocationLayerController.this.internalIndicatorPositionChangedListener.onIndicatorPositionChanged(Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude(), latLng.getAltitude()));
        }
    };
    private LocationLayerRenderer locationLayerRenderer;
    private final MapboxMap mapboxMap;
    private LocationComponentOptions options;
    private LocationComponentPositionManager positionManager;
    private final MapboxAnimator.AnimationsValueChangeListener<Float> pulsingCircleRadiusListener;
    private int renderMode;
    private final boolean useSpecializedLocationLayer;

    LocationLayerController(MapboxMap mapboxMap, Style style2, LayerSourceProvider layerSourceProvider, LayerFeatureProvider layerFeatureProvider, LayerBitmapProvider layerBitmapProvider, LocationComponentOptions locationComponentOptions, OnRenderModeChangedListener onRenderModeChangedListener, OnIndicatorPositionChangedListener onIndicatorPositionChangedListener, boolean bl) {
        boolean bl2;
        this.gpsBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                LocationLayerController.this.locationLayerRenderer.setGpsBearing(f);
            }
        };
        this.compassBearingValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                LocationLayerController.this.locationLayerRenderer.setCompassBearing(f);
            }
        };
        this.accuracyValueListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                LocationLayerController.this.locationLayerRenderer.setAccuracyRadius(f);
            }
        };
        this.pulsingCircleRadiusListener = new MapboxAnimator.AnimationsValueChangeListener<Float>(){

            @Override
            public void onNewAnimationValue(Float f) {
                Float f2 = LocationLayerController.this.options.pulseFadeEnabled() != false && LocationLayerController.this.options.pulseMaxRadius() > 0.0f ? Float.valueOf(1.0f - f.floatValue() / LocationLayerController.this.options.pulseMaxRadius()) : null;
                LocationLayerController.this.locationLayerRenderer.updatePulsingUi(f.floatValue(), f2);
            }
        };
        this.mapboxMap = mapboxMap;
        this.bitmapProvider = layerBitmapProvider;
        this.internalRenderModeChangedListener = onRenderModeChangedListener;
        this.internalIndicatorPositionChangedListener = onIndicatorPositionChangedListener;
        this.useSpecializedLocationLayer = bl;
        this.isStale = bl2 = locationComponentOptions.enableStaleState();
        this.locationLayerRenderer = bl ? layerSourceProvider.getIndicatorLocationLayerRenderer() : layerSourceProvider.getSymbolLocationLayerRenderer(layerFeatureProvider, bl2);
        this.initializeComponents(style2, locationComponentOptions);
    }

    private String buildIconString(String string2, String string3) {
        if (string2 != null) {
            if (this.useSpecializedLocationLayer) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append(" replacement ID provided for an unsupported specialized location layer");
                Logger.e(TAG, stringBuilder.toString());
                return string3;
            }
            return string2;
        }
        return string3;
    }

    private void determineIconsSource(LocationComponentOptions object) {
        String string2 = this.renderMode == 8 ? ((LocationComponentOptions)object).gpsName() : ((LocationComponentOptions)object).foregroundName();
        string2 = this.buildIconString(string2, "mapbox-location-icon");
        String string3 = this.buildIconString(((LocationComponentOptions)object).foregroundStaleName(), "mapbox-location-stale-icon");
        String string4 = this.buildIconString(((LocationComponentOptions)object).backgroundName(), "mapbox-location-stroke-icon");
        String string5 = this.buildIconString(((LocationComponentOptions)object).backgroundStaleName(), "mapbox-location-background-stale-icon");
        object = this.buildIconString(((LocationComponentOptions)object).bearingName(), "mapbox-location-bearing-icon");
        this.locationLayerRenderer.updateIconIds(string2, string3, string4, string5, (String)object);
    }

    private void styleBitmaps(LocationComponentOptions locationComponentOptions) {
        Bitmap bitmap = locationComponentOptions.elevation() > 0.0f ? this.bitmapProvider.generateShadowBitmap(locationComponentOptions) : null;
        Bitmap bitmap2 = this.bitmapProvider.generateBitmap(locationComponentOptions.backgroundDrawable(), locationComponentOptions.backgroundTintColor());
        Bitmap bitmap3 = this.bitmapProvider.generateBitmap(locationComponentOptions.backgroundDrawableStale(), locationComponentOptions.backgroundStaleTintColor());
        Bitmap bitmap4 = this.bitmapProvider.generateBitmap(locationComponentOptions.bearingDrawable(), locationComponentOptions.bearingTintColor());
        Bitmap bitmap5 = this.bitmapProvider.generateBitmap(locationComponentOptions.foregroundDrawable(), locationComponentOptions.foregroundTintColor());
        Bitmap bitmap6 = this.bitmapProvider.generateBitmap(locationComponentOptions.foregroundDrawableStale(), locationComponentOptions.foregroundStaleTintColor());
        if (this.renderMode == 8) {
            bitmap5 = this.bitmapProvider.generateBitmap(locationComponentOptions.gpsDrawable(), locationComponentOptions.foregroundTintColor());
            bitmap6 = this.bitmapProvider.generateBitmap(locationComponentOptions.gpsDrawable(), locationComponentOptions.foregroundStaleTintColor());
            locationComponentOptions = bitmap5;
        } else {
            locationComponentOptions = bitmap5;
        }
        this.locationLayerRenderer.addBitmaps(this.renderMode, bitmap, bitmap2, bitmap3, bitmap4, (Bitmap)locationComponentOptions, bitmap6);
    }

    private void styleScaling(LocationComponentOptions object) {
        object = Expression.interpolate(Expression.linear(), Expression.zoom(), Expression.stop(this.mapboxMap.getMinZoomLevel(), Float.valueOf(((LocationComponentOptions)object).minZoomIconScale())), Expression.stop(this.mapboxMap.getMaxZoomLevel(), Float.valueOf(((LocationComponentOptions)object).maxZoomIconScale())));
        this.locationLayerRenderer.styleScaling((Expression)object);
    }

    void adjustPulsingCircleLayerVisibility(boolean bl) {
        this.locationLayerRenderer.adjustPulsingCircleLayerVisibility(bl);
    }

    void applyStyle(LocationComponentOptions locationComponentOptions) {
        if (this.positionManager.update(locationComponentOptions.layerAbove(), locationComponentOptions.layerBelow())) {
            this.locationLayerRenderer.removeLayers();
            this.locationLayerRenderer.addLayers(this.positionManager);
            if (this.isHidden) {
                this.hide();
            }
        }
        this.options = locationComponentOptions;
        this.styleBitmaps(locationComponentOptions);
        this.locationLayerRenderer.styleAccuracy(locationComponentOptions.accuracyAlpha(), locationComponentOptions.accuracyColor());
        this.styleScaling(locationComponentOptions);
        this.locationLayerRenderer.stylePulsingCircle(locationComponentOptions);
        this.determineIconsSource(locationComponentOptions);
        if (!this.isHidden) {
            this.show();
        }
    }

    void cameraBearingUpdated(double d) {
        if (this.renderMode != 8) {
            this.locationLayerRenderer.cameraBearingUpdated(d);
        }
    }

    void cameraTiltUpdated(double d) {
        this.locationLayerRenderer.cameraTiltUpdated(d);
    }

    Set<AnimatorListenerHolder> getAnimationListeners() {
        HashSet<AnimatorListenerHolder> hashSet = new HashSet<AnimatorListenerHolder>();
        hashSet.add(new AnimatorListenerHolder(0, this.latLngValueListener));
        int n = this.renderMode;
        if (n == 8) {
            hashSet.add(new AnimatorListenerHolder(2, this.gpsBearingValueListener));
        } else if (n == 4) {
            hashSet.add(new AnimatorListenerHolder(3, this.compassBearingValueListener));
        }
        n = this.renderMode;
        if (n == 4 || n == 18) {
            hashSet.add(new AnimatorListenerHolder(6, this.accuracyValueListener));
        }
        if (this.options.pulseEnabled().booleanValue()) {
            hashSet.add(new AnimatorListenerHolder(9, this.pulsingCircleRadiusListener));
        }
        return hashSet;
    }

    int getRenderMode() {
        return this.renderMode;
    }

    void hide() {
        this.isHidden = true;
        this.locationLayerRenderer.hide();
    }

    void initializeComponents(Style style2, LocationComponentOptions locationComponentOptions) {
        this.positionManager = new LocationComponentPositionManager(style2, locationComponentOptions.layerAbove(), locationComponentOptions.layerBelow());
        this.locationLayerRenderer.initializeComponents(style2);
        this.locationLayerRenderer.addLayers(this.positionManager);
        this.applyStyle(locationComponentOptions);
        if (this.isHidden) {
            this.hide();
        } else {
            this.show();
        }
    }

    boolean isConsumingCompass() {
        boolean bl = this.renderMode == 4;
        return bl;
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean onMapClick(LatLng latLng) {
        latLng = this.mapboxMap.getProjection().toScreenLocation(latLng);
        return this.mapboxMap.queryRenderedFeatures((PointF)latLng, "mapbox-location-background-layer", "mapbox-location-foreground-layer", "mapbox-location-bearing-layer").isEmpty() ^ true;
    }

    void setGpsBearing(float f) {
        this.locationLayerRenderer.setGpsBearing(Float.valueOf(f));
    }

    void setLocationsStale(boolean bl) {
        this.isStale = bl;
        this.locationLayerRenderer.setLocationStale(bl, this.renderMode);
    }

    void setRenderMode(int n) {
        if (this.renderMode == n) {
            return;
        }
        this.renderMode = n;
        this.styleBitmaps(this.options);
        this.determineIconsSource(this.options);
        if (!this.isHidden) {
            this.show();
        }
        this.internalRenderModeChangedListener.onRenderModeChanged(n);
    }

    void show() {
        this.isHidden = false;
        this.locationLayerRenderer.show(this.renderMode, this.isStale);
    }
}

