/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;

abstract class MapboxAnimator<K>
extends ValueAnimator
implements ValueAnimator.AnimatorUpdateListener {
    static final int ANIMATOR_CAMERA_COMPASS_BEARING = 5;
    static final int ANIMATOR_CAMERA_GPS_BEARING = 4;
    static final int ANIMATOR_CAMERA_LATLNG = 1;
    static final int ANIMATOR_LAYER_ACCURACY = 6;
    static final int ANIMATOR_LAYER_COMPASS_BEARING = 3;
    static final int ANIMATOR_LAYER_GPS_BEARING = 2;
    static final int ANIMATOR_LAYER_LATLNG = 0;
    static final int ANIMATOR_PADDING = 10;
    static final int ANIMATOR_PULSING_CIRCLE = 9;
    static final int ANIMATOR_TILT = 8;
    static final int ANIMATOR_ZOOM = 7;
    private K animatedValue;
    private boolean invalid;
    private final double minUpdateInterval;
    private final K target;
    private long timeElapsed;
    private final AnimationsValueChangeListener<K> updateListener;

    public MapboxAnimator(AnimationsValueChangeListener<K> animationsValueChangeListener, K k, K k2, double d, long l) {
        this.updateListener = animationsValueChangeListener;
        this.target = k;
        this.animatedValue = k2;
        this.minUpdateInterval = d;
        this.timeElapsed = l;
    }

    MapboxAnimator(K[] KArray, AnimationsValueChangeListener<K> animationsValueChangeListener, int n) {
        this.minUpdateInterval = 1.0E9 / (double)n;
        this.setObjectValues(KArray);
        this.setEvaluator(this.provideEvaluator());
        this.updateListener = animationsValueChangeListener;
        this.target = KArray[KArray.length - 1];
        this.addUpdateListener(this);
        this.addListener((Animator.AnimatorListener)new AnimatorListener());
    }

    private void postUpdates() {
        if (!this.invalid) {
            this.updateListener.onNewAnimationValue(this.animatedValue);
        }
    }

    K getTarget() {
        return this.target;
    }

    public void makeInvalid() {
        this.invalid = true;
    }

    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        this.animatedValue = valueAnimator.getAnimatedValue();
        long l = System.nanoTime();
        if ((double)(l - this.timeElapsed) < this.minUpdateInterval) {
            return;
        }
        this.postUpdates();
        this.timeElapsed = l;
    }

    abstract TypeEvaluator provideEvaluator();

    static interface AnimationsValueChangeListener<K> {
        public void onNewAnimationValue(K var1);
    }

    private class AnimatorListener
    extends AnimatorListenerAdapter {
        private AnimatorListener() {
        }

        public void onAnimationEnd(Animator animator2) {
            MapboxAnimator.this.postUpdates();
        }
    }
}

