/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.os.Handler;
import android.os.Message;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.OnLocationStaleListener;
import java.lang.ref.WeakReference;

class StaleStateManager {
    private long delayTime;
    private final StaleMessageHandler handler;
    private final OnLocationStaleListener innerOnLocationStaleListeners;
    private boolean isEnabled;
    private boolean isStale = true;
    private final int staleStateMessage;

    StaleStateManager(OnLocationStaleListener onLocationStaleListener, LocationComponentOptions locationComponentOptions) {
        this.staleStateMessage = 1;
        this.innerOnLocationStaleListeners = onLocationStaleListener;
        this.handler = new StaleMessageHandler(this);
        this.isEnabled = locationComponentOptions.enableStaleState();
        this.delayTime = locationComponentOptions.staleStateTimeout();
    }

    private void postTheCallback() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.sendEmptyMessageDelayed(1, this.delayTime);
    }

    private void setState(boolean bl) {
        if (bl != this.isStale) {
            this.isStale = bl;
            if (this.isEnabled) {
                this.innerOnLocationStaleListeners.onStaleStateChange(bl);
            }
        }
    }

    boolean isStale() {
        return this.isStale;
    }

    void onStart() {
        if (!this.isStale) {
            this.postTheCallback();
        }
    }

    void onStop() {
        this.handler.removeCallbacksAndMessages(null);
    }

    void setDelayTime(long l) {
        this.delayTime = l;
        if (this.handler.hasMessages(1)) {
            this.postTheCallback();
        }
    }

    void setEnabled(boolean bl) {
        if (bl) {
            this.setState(this.isStale);
        } else if (this.isEnabled) {
            this.onStop();
            this.innerOnLocationStaleListeners.onStaleStateChange(false);
        }
        this.isEnabled = bl;
    }

    void updateLatestLocationTime() {
        this.setState(false);
        this.postTheCallback();
    }

    private static class StaleMessageHandler
    extends Handler {
        private final WeakReference<StaleStateManager> managerWeakReference;

        private StaleMessageHandler(StaleStateManager staleStateManager) {
            this.managerWeakReference = new WeakReference<StaleStateManager>(staleStateManager);
        }

        public void handleMessage(Message object) {
            object = (StaleStateManager)this.managerWeakReference.get();
            if (object != null) {
                ((StaleStateManager)object).setState(true);
            }
        }
    }
}

