/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.Iterator;
import java.util.Set;

final class SymbolLocationLayerRenderer
implements LocationLayerRenderer {
    private static final String TAG = "mbgl-locationSymbol";
    private final Set<String> layerSet;
    private final LayerSourceProvider layerSourceProvider;
    private Feature locationFeature;
    private GeoJsonSource locationSource;
    private Style style;

    SymbolLocationLayerRenderer(LayerSourceProvider layerSourceProvider, LayerFeatureProvider layerFeatureProvider, boolean bl) {
        this.layerSourceProvider = layerSourceProvider;
        this.layerSet = layerSourceProvider.getEmptyLayerSet();
        this.locationFeature = layerFeatureProvider.generateLocationFeature(this.locationFeature, bl);
    }

    private void addAccuracyLayer() {
        this.addLayerToMap(this.layerSourceProvider.generateAccuracyLayer(), "mapbox-location-background-layer");
    }

    private void addLayerToMap(Layer layer, String string2) {
        this.style.addLayerBelow(layer, string2);
        this.layerSet.add(layer.getId());
    }

    private void addLocationSource() {
        GeoJsonSource geoJsonSource;
        this.locationSource = geoJsonSource = this.layerSourceProvider.generateSource(this.locationFeature);
        this.style.addSource(geoJsonSource);
    }

    private void addPulsingCircleLayerToMap() {
        this.addLayerToMap(this.layerSourceProvider.generatePulsingCircleLayer(), "mapbox-location-accuracy-layer");
    }

    private void addSymbolLayer(String string2, String string3) {
        this.addLayerToMap(this.layerSourceProvider.generateLayer(string2), string3);
    }

    private void refreshSource() {
        if (!this.style.isFullyLoaded()) {
            Logger.w(TAG, "Style is not fully loaded, not able to get source!");
            return;
        }
        if ((GeoJsonSource)this.style.getSourceAs("mapbox-location-source") != null) {
            this.locationSource.setGeoJson(this.locationFeature.toJson());
        }
    }

    private void setBearingProperty(String string2, float f) {
        this.locationFeature.addNumberProperty(string2, Float.valueOf(f));
        this.refreshSource();
    }

    private void setLayerVisibility(String string2, boolean bl) {
        if (!this.style.isFullyLoaded()) {
            Logger.w(TAG, "Style is not fully loaded, not able to get layer!");
            return;
        }
        Layer layer = this.style.getLayer(string2);
        if (layer != null) {
            String string3 = "visible";
            string2 = bl ? "visible" : "none";
            if (!((String)layer.getVisibility().value).equals(string2)) {
                string2 = bl ? string3 : "none";
                layer.setProperties(PropertyFactory.visibility(string2));
            }
        }
    }

    private void setLocationPoint(Point point) {
        JsonObject jsonObject = this.locationFeature.properties();
        if (jsonObject != null) {
            this.locationFeature = Feature.fromGeometry((Geometry)point, jsonObject);
            this.refreshSource();
        }
    }

    private void updateAccuracyRadius(float f) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-radius", Float.valueOf(f));
        this.refreshSource();
    }

    private void updateForegroundBearing(float f) {
        this.setBearingProperty("mapbox-property-gps-bearing", f);
    }

    private void updateForegroundOffset(double d) {
        JsonArray jsonArray = new JsonArray();
        Float f = Float.valueOf(0.0f);
        jsonArray.add(f);
        jsonArray.add(Float.valueOf((float)(-0.05 * d)));
        this.locationFeature.addProperty("mapbox-property-foreground-icon-offset", jsonArray);
        jsonArray = new JsonArray();
        jsonArray.add(f);
        jsonArray.add(Float.valueOf((float)(d * 0.05)));
        this.locationFeature.addProperty("mapbox-property-shadow-icon-offset", jsonArray);
        this.refreshSource();
    }

    @Override
    public void addBitmaps(int n, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6) {
        if (bitmap != null) {
            this.style.addImage("mapbox-location-shadow-icon", bitmap);
        } else {
            this.style.removeImage("mapbox-location-shadow-icon");
        }
        this.style.addImage("mapbox-location-stroke-icon", bitmap2);
        this.style.addImage("mapbox-location-background-stale-icon", bitmap3);
        this.style.addImage("mapbox-location-bearing-icon", bitmap4);
        this.style.addImage("mapbox-location-icon", bitmap5);
        this.style.addImage("mapbox-location-stale-icon", bitmap6);
    }

    @Override
    public void addLayers(LocationComponentPositionManager locationComponentPositionManager) {
        Layer layer = this.layerSourceProvider.generateLayer("mapbox-location-bearing-layer");
        locationComponentPositionManager.addLayerToMap(layer);
        this.layerSet.add(layer.getId());
        this.addSymbolLayer("mapbox-location-foreground-layer", "mapbox-location-bearing-layer");
        this.addSymbolLayer("mapbox-location-background-layer", "mapbox-location-foreground-layer");
        this.addSymbolLayer("mapbox-location-shadow-layer", "mapbox-location-background-layer");
        this.addAccuracyLayer();
        this.addPulsingCircleLayerToMap();
    }

    @Override
    public void adjustPulsingCircleLayerVisibility(boolean bl) {
        this.setLayerVisibility("mapbox-location-pulsing-circle-layer", bl);
    }

    @Override
    public void cameraBearingUpdated(double d) {
        this.updateForegroundBearing((float)d);
    }

    @Override
    public void cameraTiltUpdated(double d) {
        this.updateForegroundOffset(d);
    }

    @Override
    public void hide() {
        Iterator<String> iterator2 = this.layerSet.iterator();
        while (iterator2.hasNext()) {
            this.setLayerVisibility(iterator2.next(), false);
        }
    }

    @Override
    public void initializeComponents(Style style2) {
        this.style = style2;
        this.addLocationSource();
    }

    @Override
    public void removeLayers() {
        for (String string2 : this.layerSet) {
            this.style.removeLayer(string2);
        }
        this.layerSet.clear();
    }

    @Override
    public void setAccuracyRadius(Float f) {
        this.updateAccuracyRadius(f.floatValue());
    }

    @Override
    public void setCompassBearing(Float f) {
        this.setBearingProperty("mapbox-property-compass-bearing", f.floatValue());
    }

    @Override
    public void setGpsBearing(Float f) {
        this.setBearingProperty("mapbox-property-gps-bearing", f.floatValue());
    }

    @Override
    public void setLatLng(LatLng latLng) {
        this.setLocationPoint(Point.fromLngLat(latLng.getLongitude(), latLng.getLatitude()));
    }

    @Override
    public void setLocationStale(boolean bl, int n) {
        this.locationFeature.addBooleanProperty("mapbox-property-location-stale", bl);
        this.refreshSource();
        if (n != 8) {
            this.setLayerVisibility("mapbox-location-accuracy-layer", bl ^ true);
        }
    }

    @Override
    public void show(int n, boolean bl) {
        if (n != 4) {
            if (n != 8) {
                if (n == 18) {
                    this.setLayerVisibility("mapbox-location-shadow-layer", true);
                    this.setLayerVisibility("mapbox-location-foreground-layer", true);
                    this.setLayerVisibility("mapbox-location-background-layer", true);
                    this.setLayerVisibility("mapbox-location-accuracy-layer", bl ^ true);
                    this.setLayerVisibility("mapbox-location-bearing-layer", false);
                }
            } else {
                this.setLayerVisibility("mapbox-location-shadow-layer", false);
                this.setLayerVisibility("mapbox-location-foreground-layer", true);
                this.setLayerVisibility("mapbox-location-background-layer", true);
                this.setLayerVisibility("mapbox-location-accuracy-layer", false);
                this.setLayerVisibility("mapbox-location-bearing-layer", false);
            }
        } else {
            this.setLayerVisibility("mapbox-location-shadow-layer", true);
            this.setLayerVisibility("mapbox-location-foreground-layer", true);
            this.setLayerVisibility("mapbox-location-background-layer", true);
            this.setLayerVisibility("mapbox-location-accuracy-layer", bl ^ true);
            this.setLayerVisibility("mapbox-location-bearing-layer", true);
        }
    }

    @Override
    public void styleAccuracy(float f, int n) {
        this.locationFeature.addNumberProperty("mapbox-property-accuracy-alpha", Float.valueOf(f));
        this.locationFeature.addStringProperty("mapbox-property-accuracy-color", ColorUtils.colorToRgbaString(n));
        this.refreshSource();
    }

    @Override
    public void stylePulsingCircle(LocationComponentOptions locationComponentOptions) {
        if (!this.style.isFullyLoaded()) {
            Logger.w(TAG, "Style is not fully loaded, not able to get layer!");
            return;
        }
        if (this.style.getLayer("mapbox-location-pulsing-circle-layer") != null) {
            this.setLayerVisibility("mapbox-location-pulsing-circle-layer", true);
            this.style.getLayer("mapbox-location-pulsing-circle-layer").setProperties(PropertyFactory.circleRadius(Expression.get("mapbox-property-pulsing-circle-radius")), PropertyFactory.circleColor(locationComponentOptions.pulseColor()), PropertyFactory.circleStrokeColor(locationComponentOptions.pulseColor()), PropertyFactory.circleOpacity(Expression.get("mapbox-property-pulsing-circle-opacity")));
        }
    }

    @Override
    public void styleScaling(Expression expression) {
        if (!this.style.isFullyLoaded()) {
            Logger.w(TAG, "Style is not fully loaded, not able to get layer!");
            return;
        }
        for (String string2 : this.layerSet) {
            Layer object = this.style.getLayer(string2);
            if (!(object instanceof SymbolLayer)) continue;
            object.setProperties(PropertyFactory.iconSize(expression));
        }
    }

    @Override
    public void updateIconIds(String string2, String string3, String string4, String string5, String string6) {
        this.locationFeature.addStringProperty("mapbox-property-foreground-icon", string2);
        this.locationFeature.addStringProperty("mapbox-property-background-icon", string4);
        this.locationFeature.addStringProperty("mapbox-property-foreground-stale-icon", string3);
        this.locationFeature.addStringProperty("mapbox-property-background-stale-icon", string5);
        this.locationFeature.addStringProperty("mapbox-property-shadow-icon", string6);
        this.refreshSource();
    }

    @Override
    public void updatePulsingUi(float f, Float f2) {
        this.locationFeature.addNumberProperty("mapbox-property-pulsing-circle-radius", Float.valueOf(f));
        if (f2 != null) {
            this.locationFeature.addNumberProperty("mapbox-property-pulsing-circle-opacity", f2);
        }
        this.refreshSource();
    }
}

