/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.attribution.Attribution;
import com.mapbox.mapboxsdk.attribution.AttributionParser;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AttributionDialogManager
implements View.OnClickListener,
DialogInterface.OnClickListener {
    private static final String MAP_FEEDBACK_STYLE_URI_REGEX = "^(.*://[^:^/]*)/(.*)/(.*)";
    private static final String MAP_FEEDBACK_URL = "https://apps.mapbox.com/feedback";
    private static final String MAP_FEEDBACK_URL_LOCATION_FRAGMENT_FORMAT = "/%f/%f/%f/%f/%d";
    private static final String MAP_FEEDBACK_URL_OLD = "https://www.mapbox.com/map-feedback";
    private Set<Attribution> attributionSet;
    private final Context context;
    private AlertDialog dialog;
    private final MapboxMap mapboxMap;

    public AttributionDialogManager(Context context, MapboxMap mapboxMap) {
        this.context = context;
        this.mapboxMap = mapboxMap;
    }

    private String[] getAttributionTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Attribution> iterator2 = this.attributionSet.iterator();
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next().getTitle());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isLatestEntry(int n) {
        int n2 = this.getAttributionTitles().length;
        boolean bl = true;
        if (n != n2 - 1) {
            bl = false;
        }
        return bl;
    }

    private void showMapAttributionWebPage(int n) {
        Set<Attribution> set;
        block3: {
            block2: {
                set = this.attributionSet;
                String string2 = set.toArray(new Attribution[set.size()])[n].getUrl();
                if (string2.contains(MAP_FEEDBACK_URL_OLD)) break block2;
                set = string2;
                if (!string2.contains(MAP_FEEDBACK_URL)) break block3;
            }
            set = this.buildMapFeedbackMapUrl(Mapbox.getAccessToken());
        }
        this.showWebPage((String)((Object)set));
    }

    private void showTelemetryDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionTelemetryTitle);
        builder.setMessage(R.string.mapbox_attributionTelemetryMessage);
        builder.setPositiveButton(R.string.mapbox_attributionTelemetryPositive, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                TelemetryDefinition telemetryDefinition = Mapbox.getTelemetry();
                if (telemetryDefinition != null) {
                    telemetryDefinition.setUserTelemetryRequestState(true);
                }
                dialogInterface.cancel();
            }
        });
        builder.setNeutralButton(R.string.mapbox_attributionTelemetryNeutral, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                AttributionDialogManager attributionDialogManager = AttributionDialogManager.this;
                attributionDialogManager.showWebPage(attributionDialogManager.context.getResources().getString(R.string.mapbox_telemetryLink));
                dialogInterface.cancel();
            }
        });
        builder.setNegativeButton(R.string.mapbox_attributionTelemetryNegative, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                TelemetryDefinition telemetryDefinition = Mapbox.getTelemetry();
                if (telemetryDefinition != null) {
                    telemetryDefinition.setUserTelemetryRequestState(false);
                }
                dialogInterface.cancel();
            }
        });
        builder.show();
    }

    private void showWebPage(String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            this.context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Toast.makeText((Context)this.context, (int)R.string.mapbox_attributionErrorNoBrowser, (int)1).show();
            MapStrictMode.strictModeViolation(activityNotFoundException);
        }
    }

    String buildMapFeedbackMapUrl(String object) {
        Uri.Builder builder = Uri.parse((String)MAP_FEEDBACK_URL).buildUpon();
        Object object2 = this.mapboxMap.getCameraPosition();
        if (object2 != null) {
            builder.encodedFragment(String.format(Locale.getDefault(), MAP_FEEDBACK_URL_LOCATION_FRAGMENT_FORMAT, ((CameraPosition)object2).target.getLongitude(), ((CameraPosition)object2).target.getLatitude(), ((CameraPosition)object2).zoom, ((CameraPosition)object2).bearing, (int)((CameraPosition)object2).tilt));
        }
        if ((object2 = this.context.getApplicationContext().getPackageName()) != null) {
            builder.appendQueryParameter("referrer", (String)object2);
        }
        if (object != null) {
            builder.appendQueryParameter("access_token", (String)object);
        }
        if ((object = this.mapboxMap.getStyle()) != null) {
            object = ((Style)object).getUri();
            object2 = Pattern.compile(MAP_FEEDBACK_STYLE_URI_REGEX).matcher((CharSequence)object);
            if (((Matcher)object2).find()) {
                object = ((Matcher)object2).group(2);
                object2 = ((Matcher)object2).group(3);
                builder.appendQueryParameter("owner", (String)object).appendQueryParameter("id", (String)object2);
            }
        }
        return builder.build().toString();
    }

    public void onClick(DialogInterface dialogInterface, int n) {
        if (this.isLatestEntry(n)) {
            this.showTelemetryDialog();
        } else {
            this.showMapAttributionWebPage(n);
        }
    }

    public void onClick(View view) {
        this.attributionSet = new AttributionBuilder(this.mapboxMap, view.getContext()).build();
        view = this.context;
        boolean bl = view instanceof Activity ? ((Activity)view).isFinishing() : false;
        if (!bl) {
            this.showAttributionDialog(this.getAttributionTitles());
        }
    }

    public void onStop() {
        AlertDialog alertDialog = this.dialog;
        if (alertDialog != null && alertDialog.isShowing()) {
            this.dialog.dismiss();
        }
    }

    protected void showAttributionDialog(String[] stringArray) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(R.string.mapbox_attributionsDialogTitle);
        builder.setAdapter((ListAdapter)new ArrayAdapter(this.context, R.layout.mapbox_attribution_list_item, (Object[])stringArray), (DialogInterface.OnClickListener)this);
        this.dialog = builder.show();
    }

    private static class AttributionBuilder {
        private final WeakReference<Context> context;
        private final MapboxMap mapboxMap;

        AttributionBuilder(MapboxMap mapboxMap, Context context) {
            this.mapboxMap = mapboxMap;
            this.context = new WeakReference<Context>(context);
        }

        private Set<Attribution> build() {
            Context context = (Context)this.context.get();
            if (context == null) {
                return Collections.emptySet();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = this.mapboxMap.getStyle();
            if (object != null) {
                object = ((Style)object).getSources().iterator();
                while (object.hasNext()) {
                    String string2 = ((Source)object.next()).getAttribution();
                    if (string2.isEmpty()) continue;
                    arrayList.add(string2);
                }
            }
            return new AttributionParser.Options(context).withCopyrightSign(true).withImproveMap(true).withTelemetryAttribution(true).withAttributionData(arrayList.toArray(new String[arrayList.size()])).build().getAttributions();
        }
    }
}

