/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class IconManager {
    private int highestIconHeight;
    private int highestIconWidth;
    private final Map<Icon, Integer> iconMap = new HashMap<Icon, Integer>();
    private NativeMap nativeMap;

    IconManager(NativeMap nativeMap) {
        this.nativeMap = nativeMap;
    }

    private void addIcon(Icon icon) {
        this.addIcon(icon, true);
    }

    private void addIcon(Icon icon, boolean bl) {
        if (!this.iconMap.keySet().contains(icon)) {
            this.iconMap.put(icon, 1);
            if (bl) {
                this.loadIcon(icon);
            }
        } else {
            Map<Icon, Integer> map = this.iconMap;
            map.put(icon, map.get(icon) + 1);
        }
    }

    private Icon loadDefaultIconForMarker(Marker marker) {
        Icon icon = IconFactory.getInstance(Mapbox.getApplicationContext()).defaultMarker();
        Bitmap bitmap = icon.getBitmap();
        this.updateHighestIconSize(bitmap.getWidth(), bitmap.getHeight() / 2);
        marker.setIcon(icon);
        return icon;
    }

    private void loadIcon(Icon icon) {
        Bitmap bitmap = icon.getBitmap();
        this.nativeMap.addAnnotationIcon(icon.getId(), bitmap.getWidth(), bitmap.getHeight(), icon.getScale(), icon.toBytes());
    }

    private void remove(Icon icon) {
        this.nativeMap.removeAnnotationIcon(icon.getId());
        this.iconMap.remove(icon);
    }

    private void setTopOffsetPixels(Marker marker, MapboxMap object, Icon icon) {
        object = marker.getId() != -1L ? (Marker)((MapboxMap)object).getAnnotation(marker.getId()) : null;
        if (object == null || ((Marker)object).getIcon() == null || ((Marker)object).getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }

    private void updateHighestIconSize(int n, int n2) {
        if (n > this.highestIconWidth) {
            this.highestIconWidth = n;
        }
        if (n2 > this.highestIconHeight) {
            this.highestIconHeight = n2;
        }
    }

    private void updateHighestIconSize(Bitmap bitmap) {
        this.updateHighestIconSize(bitmap.getWidth(), bitmap.getHeight());
    }

    private void updateHighestIconSize(Icon icon) {
        this.updateHighestIconSize(icon.getBitmap());
    }

    private void updateIconRefCounter(Icon icon, int n) {
        this.iconMap.put(icon, n);
    }

    void ensureIconLoaded(Marker marker, MapboxMap mapboxMap) {
        Icon icon;
        Icon icon2 = icon = marker.getIcon();
        if (icon == null) {
            icon2 = this.loadDefaultIconForMarker(marker);
        }
        this.addIcon(icon2);
        this.setTopOffsetPixels(marker, mapboxMap, icon2);
    }

    int getHighestIconHeight() {
        return this.highestIconHeight;
    }

    int getHighestIconWidth() {
        return this.highestIconWidth;
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        return (int)(this.nativeMap.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.nativeMap.getPixelRatio());
    }

    void iconCleanup(Icon icon) {
        Integer n = this.iconMap.get(icon);
        if (n != null) {
            if ((n = Integer.valueOf(n - 1)) == 0) {
                this.remove(icon);
            } else {
                this.updateIconRefCounter(icon, n);
            }
        }
    }

    Icon loadIconForMarker(Marker object) {
        Icon icon = ((Marker)object).getIcon();
        if (icon == null) {
            object = this.loadDefaultIconForMarker((Marker)object);
        } else {
            this.updateHighestIconSize(icon);
            object = icon;
        }
        this.addIcon((Icon)object);
        return object;
    }

    void reloadIcons() {
        Iterator<Icon> iterator2 = this.iconMap.keySet().iterator();
        while (iterator2.hasNext()) {
            this.loadIcon(iterator2.next());
        }
    }
}

