/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.collection.LongSparseArray;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.exceptions.MapboxConfigurationException;
import com.mapbox.mapboxsdk.exceptions.MapboxLifecycleException;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.maps.AnnotationContainer;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.GlyphsRasterizationMode;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapChangeReceiver;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.MapKeyListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.MarkerContainer;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.PolygonContainer;
import com.mapbox.mapboxsdk.maps.PolylineContainer;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotationContainer;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.GLSurfaceViewMapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.MapboxGLSurfaceView;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MapView
extends FrameLayout
implements NativeMapView.ViewCallback {
    private AttributionClickListener attributionClickListener;
    private final CameraChangeDispatcher cameraDispatcher;
    private CompassView compassView;
    private boolean created;
    private boolean destroyed;
    private final FocalPointInvalidator focalInvalidator;
    private PointF focalPoint;
    private final InitialRenderCallback initialRenderCallback;
    private boolean isStarted;
    private final MapCallback mapCallback;
    private final MapChangeReceiver mapChangeReceiver = new MapChangeReceiver();
    private MapGestureDetector mapGestureDetector;
    private MapKeyListener mapKeyListener;
    private MapRenderer mapRenderer;
    private MapboxMap mapboxMap;
    MapboxMapOptions mapboxMapOptions;
    private NativeMap nativeMapView;
    private final List<View.OnTouchListener> onTouchListeners;
    private final GesturesManagerInteractionListener registerTouchListener;
    private View renderView;
    private Bundle savedInstanceState;

    public MapView(Context context) {
        super(context);
        this.mapCallback = new MapCallback();
        this.initialRenderCallback = new InitialRenderCallback();
        this.onTouchListeners = new ArrayList<View.OnTouchListener>();
        this.focalInvalidator = new FocalPointInvalidator();
        this.registerTouchListener = new GesturesManagerInteractionListener();
        this.cameraDispatcher = new CameraChangeDispatcher();
        this.initialize(context, MapboxMapOptions.createFromAttributes(context));
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mapCallback = new MapCallback();
        this.initialRenderCallback = new InitialRenderCallback();
        this.onTouchListeners = new ArrayList<View.OnTouchListener>();
        this.focalInvalidator = new FocalPointInvalidator();
        this.registerTouchListener = new GesturesManagerInteractionListener();
        this.cameraDispatcher = new CameraChangeDispatcher();
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attributeSet));
    }

    public MapView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mapCallback = new MapCallback();
        this.initialRenderCallback = new InitialRenderCallback();
        this.onTouchListeners = new ArrayList<View.OnTouchListener>();
        this.focalInvalidator = new FocalPointInvalidator();
        this.registerTouchListener = new GesturesManagerInteractionListener();
        this.cameraDispatcher = new CameraChangeDispatcher();
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attributeSet));
    }

    public MapView(Context context, MapboxMapOptions mapboxMapOptions) {
        super(context);
        this.mapCallback = new MapCallback();
        this.initialRenderCallback = new InitialRenderCallback();
        this.onTouchListeners = new ArrayList<View.OnTouchListener>();
        this.focalInvalidator = new FocalPointInvalidator();
        this.registerTouchListener = new GesturesManagerInteractionListener();
        this.cameraDispatcher = new CameraChangeDispatcher();
        MapboxMapOptions mapboxMapOptions2 = mapboxMapOptions;
        if (mapboxMapOptions == null) {
            mapboxMapOptions2 = MapboxMapOptions.createFromAttributes(context);
        }
        this.initialize(context, mapboxMapOptions2);
    }

    static /* synthetic */ PointF access$302(MapView mapView, PointF pointF) {
        mapView.focalPoint = pointF;
        return pointF;
    }

    private MapboxMap.OnCompassAnimationListener createCompassAnimationListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new MapboxMap.OnCompassAnimationListener(){

            @Override
            public void onCompassAnimation() {
                cameraChangeDispatcher.onCameraMove();
            }

            @Override
            public void onCompassAnimationFinished() {
                if (MapView.this.compassView != null) {
                    MapView.this.compassView.isAnimating(false);
                }
                cameraChangeDispatcher.onCameraIdle();
            }
        };
    }

    private View.OnClickListener createCompassClickListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new View.OnClickListener(){

            public void onClick(View view) {
                if (MapView.this.mapboxMap != null && MapView.this.compassView != null) {
                    if (MapView.this.focalPoint != null) {
                        MapView.this.mapboxMap.setFocalBearing(0.0, ((MapView)MapView.this).focalPoint.x, ((MapView)MapView.this).focalPoint.y, 150L);
                    } else {
                        MapView.this.mapboxMap.setFocalBearing(0.0, MapView.this.mapboxMap.getWidth() / 2.0f, MapView.this.mapboxMap.getHeight() / 2.0f, 150L);
                    }
                    cameraChangeDispatcher.onCameraMoveStarted(3);
                    MapView.this.compassView.isAnimating(true);
                    MapView.this.compassView.postDelayed(MapView.this.compassView, 650L);
                }
            }
        };
    }

    private FocalPointChangeListener createFocalPointChangeListener() {
        return new FocalPointChangeListener(){

            @Override
            public void onFocalPointChanged(PointF pointF) {
                MapView.access$302(MapView.this, pointF);
            }
        };
    }

    private void initialiseDrawingSurface(MapboxMapOptions object) {
        boolean bl;
        String string2 = ((MapboxMapOptions)object).getLocalIdeographFontFamily();
        GlyphsRasterizationMode glyphsRasterizationMode = ((MapboxMapOptions)object).getGlyphsRasterizationMode();
        if (((MapboxMapOptions)object).getTextureMode()) {
            TextureView textureView = new TextureView(this.getContext());
            bl = ((MapboxMapOptions)object).getTranslucentTextureSurface();
            this.mapRenderer = new TextureViewMapRenderer(this.getContext(), textureView, glyphsRasterizationMode, string2, bl){

                @Override
                protected void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gL10, eGLConfig);
                }
            };
            this.addView((View)textureView, 0);
            this.renderView = textureView;
        } else {
            object = new MapboxGLSurfaceView(this.getContext());
            object.setZOrderMediaOverlay(this.mapboxMapOptions.getRenderSurfaceOnTop());
            this.mapRenderer = new GLSurfaceViewMapRenderer(this.getContext(), (MapboxGLSurfaceView)((Object)object), glyphsRasterizationMode, string2){

                @Override
                public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gL10, eGLConfig);
                }
            };
            this.addView((View)object, 0);
            this.renderView = object;
        }
        bl = this.mapboxMapOptions.getCrossSourceCollisions();
        this.nativeMapView = new NativeMapView(this.getContext(), this.getPixelRatio(), bl, this, this.mapChangeReceiver, this.mapRenderer);
    }

    private void initialiseMap() {
        MapboxMap mapboxMap;
        Context context = this.getContext();
        this.focalInvalidator.addListener(this.createFocalPointChangeListener());
        Object object = new Projection(this.nativeMapView, this);
        Object object2 = new UiSettings((Projection)object, this.focalInvalidator, this.getPixelRatio(), this);
        Object object3 = new LongSparseArray();
        Object object4 = new IconManager(this.nativeMapView);
        AnnotationManager annotationManager = new AnnotationManager(this, (LongSparseArray<Annotation>)object3, (IconManager)object4, new AnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)object3), new MarkerContainer(this.nativeMapView, (LongSparseArray<Annotation>)object3, (IconManager)object4), new PolygonContainer(this.nativeMapView, (LongSparseArray<Annotation>)object3), new PolylineContainer(this.nativeMapView, (LongSparseArray<Annotation>)object3), new ShapeAnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)object3));
        object4 = new Transform(this, this.nativeMapView, this.cameraDispatcher);
        object3 = new ArrayList();
        this.mapboxMap = mapboxMap = new MapboxMap(this.nativeMapView, (Transform)object4, (UiSettings)object2, (Projection)object, this.registerTouchListener, this.cameraDispatcher, (List<MapboxMap.OnDeveloperAnimationListener>)object3);
        mapboxMap.injectAnnotationManager(annotationManager);
        this.mapGestureDetector = object = new MapGestureDetector(context, (Transform)object4, (Projection)object, (UiSettings)object2, annotationManager, this.cameraDispatcher);
        this.mapKeyListener = new MapKeyListener((Transform)object4, (UiSettings)object2, (MapGestureDetector)object);
        object2 = this.mapboxMap;
        ((MapboxMap)object2).injectLocationComponent(new LocationComponent((MapboxMap)object2, (Transform)object4, (List<MapboxMap.OnDeveloperAnimationListener>)object3));
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.nativeMapView.setReachability(Mapbox.isConnected());
        object2 = this.savedInstanceState;
        if (object2 == null) {
            this.mapboxMap.initialise(context, this.mapboxMapOptions);
        } else {
            this.mapboxMap.onRestoreInstanceState((Bundle)object2);
        }
        this.mapCallback.initialised();
    }

    private boolean isGestureDetectorInitialized() {
        boolean bl = this.mapGestureDetector != null;
        return bl;
    }

    private boolean isKeyDetectorInitialized() {
        boolean bl = this.mapKeyListener != null;
        return bl;
    }

    private void onSurfaceCreated() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MapView.this.destroyed && MapView.this.mapboxMap == null) {
                    MapView.this.initialiseMap();
                    MapView.this.mapboxMap.onStart();
                }
            }
        });
    }

    public static void setMapStrictModeEnabled(boolean bl) {
        MapStrictMode.setStrictModeEnabled(bl);
    }

    public void addOnCameraDidChangeListener(OnCameraDidChangeListener onCameraDidChangeListener) {
        this.mapChangeReceiver.addOnCameraDidChangeListener(onCameraDidChangeListener);
    }

    public void addOnCameraIsChangingListener(OnCameraIsChangingListener onCameraIsChangingListener) {
        this.mapChangeReceiver.addOnCameraIsChangingListener(onCameraIsChangingListener);
    }

    public void addOnCameraWillChangeListener(OnCameraWillChangeListener onCameraWillChangeListener) {
        this.mapChangeReceiver.addOnCameraWillChangeListener(onCameraWillChangeListener);
    }

    public void addOnCanRemoveUnusedStyleImageListener(OnCanRemoveUnusedStyleImageListener onCanRemoveUnusedStyleImageListener) {
        this.mapChangeReceiver.addOnCanRemoveUnusedStyleImageListener(onCanRemoveUnusedStyleImageListener);
    }

    public void addOnDidBecomeIdleListener(OnDidBecomeIdleListener onDidBecomeIdleListener) {
        this.mapChangeReceiver.addOnDidBecomeIdleListener(onDidBecomeIdleListener);
    }

    public void addOnDidFailLoadingMapListener(OnDidFailLoadingMapListener onDidFailLoadingMapListener) {
        this.mapChangeReceiver.addOnDidFailLoadingMapListener(onDidFailLoadingMapListener);
    }

    public void addOnDidFailLoadingTileListener(OnDidFailLoadingTileListener onDidFailLoadingTileListener) {
        this.mapChangeReceiver.addOnDidFailLoadingTileListener(onDidFailLoadingTileListener);
    }

    public void addOnDidFinishLoadingMapListener(OnDidFinishLoadingMapListener onDidFinishLoadingMapListener) {
        this.mapChangeReceiver.addOnDidFinishLoadingMapListener(onDidFinishLoadingMapListener);
    }

    public void addOnDidFinishLoadingStyleListener(OnDidFinishLoadingStyleListener onDidFinishLoadingStyleListener) {
        this.mapChangeReceiver.addOnDidFinishLoadingStyleListener(onDidFinishLoadingStyleListener);
    }

    public void addOnDidFinishRenderingFrameListener(OnDidFinishRenderingFrameListener onDidFinishRenderingFrameListener) {
        this.mapChangeReceiver.addOnDidFinishRenderingFrameListener(onDidFinishRenderingFrameListener);
    }

    public void addOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener onDidFinishRenderingMapListener) {
        this.mapChangeReceiver.addOnDidFinishRenderingMapListener(onDidFinishRenderingMapListener);
    }

    public void addOnSourceChangedListener(OnSourceChangedListener onSourceChangedListener) {
        this.mapChangeReceiver.addOnSourceChangedListener(onSourceChangedListener);
    }

    public void addOnStyleImageMissingListener(OnStyleImageMissingListener onStyleImageMissingListener) {
        this.mapChangeReceiver.addOnStyleImageMissingListener(onStyleImageMissingListener);
    }

    public boolean addOnTouchListener(View.OnTouchListener onTouchListener) {
        return this.onTouchListeners.add(onTouchListener);
    }

    public void addOnWillStartLoadingMapListener(OnWillStartLoadingMapListener onWillStartLoadingMapListener) {
        this.mapChangeReceiver.addOnWillStartLoadingMapListener(onWillStartLoadingMapListener);
    }

    public void addOnWillStartRenderingFrameListener(OnWillStartRenderingFrameListener onWillStartRenderingFrameListener) {
        this.mapChangeReceiver.addOnWillStartRenderingFrameListener(onWillStartRenderingFrameListener);
    }

    public void addOnWillStartRenderingMapListener(OnWillStartRenderingMapListener onWillStartRenderingMapListener) {
        this.mapChangeReceiver.addOnWillStartRenderingMapListener(onWillStartRenderingMapListener);
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        MapboxMap mapboxMap = this.mapboxMap;
        if (mapboxMap == null) {
            this.mapCallback.addOnMapReadyCallback(onMapReadyCallback);
        } else {
            onMapReadyCallback.onMapReady(mapboxMap);
        }
    }

    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    public float getPixelRatio() {
        float f;
        float f2 = f = this.mapboxMapOptions.getPixelRatio();
        if (f == 0.0f) {
            f2 = this.getResources().getDisplayMetrics().density;
        }
        return f2;
    }

    public View getRenderView() {
        return this.renderView;
    }

    @Override
    public Bitmap getViewContent() {
        return BitmapUtils.createBitmapFromView((View)this);
    }

    protected ImageView initialiseAttributionView() {
        AttributionClickListener attributionClickListener;
        ImageView imageView = new ImageView(this.getContext());
        this.addView((View)imageView);
        imageView.setTag((Object)"attrView");
        imageView.getLayoutParams().width = -2;
        imageView.getLayoutParams().height = -2;
        imageView.setAdjustViewBounds(true);
        imageView.setClickable(true);
        imageView.setFocusable(true);
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.mapbox_attributionsIconContentDescription));
        imageView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.mapbox_info_bg_selector));
        this.attributionClickListener = attributionClickListener = new AttributionClickListener(this.getContext(), this.mapboxMap);
        imageView.setOnClickListener((View.OnClickListener)attributionClickListener);
        return imageView;
    }

    protected CompassView initialiseCompassView() {
        CompassView compassView;
        this.compassView = compassView = new CompassView(this.getContext());
        this.addView((View)compassView);
        this.compassView.setTag("compassView");
        this.compassView.getLayoutParams().width = -2;
        this.compassView.getLayoutParams().height = -2;
        this.compassView.setContentDescription(this.getResources().getString(R.string.mapbox_compassContentDescription));
        this.compassView.injectCompassAnimationListener(this.createCompassAnimationListener(this.cameraDispatcher));
        this.compassView.setOnClickListener(this.createCompassClickListener(this.cameraDispatcher));
        return this.compassView;
    }

    protected ImageView initialiseLogoView() {
        ImageView imageView = new ImageView(this.getContext());
        this.addView((View)imageView);
        imageView.setTag((Object)"logoView");
        imageView.getLayoutParams().width = -2;
        imageView.getLayoutParams().height = -2;
        imageView.setImageDrawable(BitmapUtils.getDrawableFromRes(this.getContext(), R.drawable.mapbox_logo_icon));
        return imageView;
    }

    protected void initialize(Context context, MapboxMapOptions mapboxMapOptions) {
        if (this.isInEditMode()) {
            return;
        }
        if (Mapbox.hasInstance()) {
            this.setForeground((Drawable)new ColorDrawable(mapboxMapOptions.getForegroundLoadColor()));
            this.mapboxMapOptions = mapboxMapOptions;
            this.setContentDescription(context.getString(R.string.mapbox_mapActionDescription));
            this.setWillNotDraw(false);
            this.initialiseDrawingSurface(mapboxMapOptions);
            return;
        }
        throw new MapboxConfigurationException();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void onCreate(Bundle object) {
        this.created = true;
        if (object == null) {
            object = Mapbox.getTelemetry();
            if (object != null) {
                object.onAppUserTurnstileEvent();
            }
        } else if (object.getBoolean("mapbox_savedState")) {
            this.savedInstanceState = object;
        }
    }

    public void onDestroy() {
        this.destroyed = true;
        this.mapChangeReceiver.clear();
        this.mapCallback.onDestroy();
        this.initialRenderCallback.onDestroy();
        Object object = this.compassView;
        if (object != null) {
            ((CompassView)object).resetAnimation();
        }
        if ((object = this.mapboxMap) != null) {
            ((MapboxMap)object).onDestroy();
        }
        if ((object = this.nativeMapView) != null) {
            object.destroy();
            this.nativeMapView = null;
        }
        if ((object = this.mapRenderer) != null) {
            ((MapRenderer)object).onDestroy();
        }
        this.onTouchListeners.clear();
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onGenericMotionEvent(motionEvent);
        }
        boolean bl = this.mapGestureDetector.onGenericMotionEvent(motionEvent) || super.onGenericMotionEvent(motionEvent);
        return bl;
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyDown(n, keyEvent);
        }
        boolean bl = this.mapKeyListener.onKeyDown(n, keyEvent) || super.onKeyDown(n, keyEvent);
        return bl;
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyLongPress(n, keyEvent);
        }
        boolean bl = this.mapKeyListener.onKeyLongPress(n, keyEvent) || super.onKeyLongPress(n, keyEvent);
        return bl;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onKeyUp(n, keyEvent);
        }
        boolean bl = this.mapKeyListener.onKeyUp(n, keyEvent) || super.onKeyUp(n, keyEvent);
        return bl;
    }

    public void onLowMemory() {
        NativeMap nativeMap = this.nativeMapView;
        if (nativeMap != null && this.mapboxMap != null && !this.destroyed) {
            nativeMap.onLowMemory();
        }
    }

    public void onPause() {
        MapRenderer mapRenderer = this.mapRenderer;
        if (mapRenderer != null) {
            mapRenderer.onPause();
        }
    }

    public void onResume() {
        MapRenderer mapRenderer = this.mapRenderer;
        if (mapRenderer != null) {
            mapRenderer.onResume();
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (this.mapboxMap != null) {
            bundle.putBoolean("mapbox_savedState", true);
            this.mapboxMap.onSaveInstanceState(bundle);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        NativeMap nativeMap;
        if (!this.isInEditMode() && (nativeMap = this.nativeMapView) != null) {
            nativeMap.resizeView(n, n2);
        }
    }

    public void onStart() {
        if (this.created) {
            Object object;
            if (!this.isStarted) {
                ConnectivityReceiver.instance(this.getContext()).activate();
                FileSource.getInstance(this.getContext()).activate();
                this.isStarted = true;
            }
            if ((object = this.mapboxMap) != null) {
                ((MapboxMap)object).onStart();
            }
            if ((object = this.mapRenderer) != null) {
                ((MapRenderer)object).onStart();
            }
            return;
        }
        throw new MapboxLifecycleException();
    }

    public void onStop() {
        Object object = this.attributionClickListener;
        if (object != null) {
            ((AttributionClickListener)object).onStop();
        }
        if (this.mapboxMap != null) {
            this.mapGestureDetector.cancelAnimators();
            this.mapboxMap.onStop();
        }
        if ((object = this.mapRenderer) != null) {
            ((MapRenderer)object).onStop();
        }
        if (this.isStarted) {
            ConnectivityReceiver.instance(this.getContext()).deactivate();
            FileSource.getInstance(this.getContext()).deactivate();
            this.isStarted = false;
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isGestureDetectorInitialized() && this.mapGestureDetector.onTouchEvent(motionEvent) || super.onTouchEvent(motionEvent)) {
            return true;
        }
        Iterator<View.OnTouchListener> iterator2 = this.onTouchListeners.iterator();
        while (iterator2.hasNext()) {
            if (!iterator2.next().onTouch((View)this, motionEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (!this.isKeyDetectorInitialized()) {
            return super.onTrackballEvent(motionEvent);
        }
        boolean bl = this.mapKeyListener.onTrackballEvent(motionEvent) || super.onTrackballEvent(motionEvent);
        return bl;
    }

    public void queueEvent(Runnable runnable) {
        MapRenderer mapRenderer = this.mapRenderer;
        if (mapRenderer != null) {
            mapRenderer.queueEvent(runnable);
            return;
        }
        throw new IllegalStateException("Calling MapView#queueEvent before mapRenderer is created.");
    }

    public void removeOnCameraDidChangeListener(OnCameraDidChangeListener onCameraDidChangeListener) {
        this.mapChangeReceiver.removeOnCameraDidChangeListener(onCameraDidChangeListener);
    }

    public void removeOnCameraIsChangingListener(OnCameraIsChangingListener onCameraIsChangingListener) {
        this.mapChangeReceiver.removeOnCameraIsChangingListener(onCameraIsChangingListener);
    }

    public void removeOnCameraWillChangeListener(OnCameraWillChangeListener onCameraWillChangeListener) {
        this.mapChangeReceiver.removeOnCameraWillChangeListener(onCameraWillChangeListener);
    }

    public void removeOnCanRemoveUnusedStyleImageListener(OnCanRemoveUnusedStyleImageListener onCanRemoveUnusedStyleImageListener) {
        this.mapChangeReceiver.removeOnCanRemoveUnusedStyleImageListener(onCanRemoveUnusedStyleImageListener);
    }

    public void removeOnDidBecomeIdleListener(OnDidBecomeIdleListener onDidBecomeIdleListener) {
        this.mapChangeReceiver.removeOnDidBecomeIdleListener(onDidBecomeIdleListener);
    }

    public void removeOnDidFailLoadingMapListener(OnDidFailLoadingMapListener onDidFailLoadingMapListener) {
        this.mapChangeReceiver.removeOnDidFailLoadingMapListener(onDidFailLoadingMapListener);
    }

    public void removeOnDidFailLoadingTileListener(OnDidFailLoadingTileListener onDidFailLoadingTileListener) {
        this.mapChangeReceiver.removeOnDidFailLoadingTileListener(onDidFailLoadingTileListener);
    }

    public void removeOnDidFinishLoadingMapListener(OnDidFinishLoadingMapListener onDidFinishLoadingMapListener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingMapListener(onDidFinishLoadingMapListener);
    }

    public void removeOnDidFinishLoadingStyleListener(OnDidFinishLoadingStyleListener onDidFinishLoadingStyleListener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingStyleListener(onDidFinishLoadingStyleListener);
    }

    public void removeOnDidFinishRenderingFrameListener(OnDidFinishRenderingFrameListener onDidFinishRenderingFrameListener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingFrameListener(onDidFinishRenderingFrameListener);
    }

    public void removeOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener onDidFinishRenderingMapListener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingMapListener(onDidFinishRenderingMapListener);
    }

    public void removeOnSourceChangedListener(OnSourceChangedListener onSourceChangedListener) {
        this.mapChangeReceiver.removeOnSourceChangedListener(onSourceChangedListener);
    }

    public void removeOnStyleImageMissingListener(OnStyleImageMissingListener onStyleImageMissingListener) {
        this.mapChangeReceiver.removeOnStyleImageMissingListener(onStyleImageMissingListener);
    }

    public boolean removeOnTouchListener(View.OnTouchListener onTouchListener) {
        return this.onTouchListeners.remove(onTouchListener);
    }

    public void removeOnWillStartLoadingMapListener(OnWillStartLoadingMapListener onWillStartLoadingMapListener) {
        this.mapChangeReceiver.removeOnWillStartLoadingMapListener(onWillStartLoadingMapListener);
    }

    public void removeOnWillStartRenderingFrameListener(OnWillStartRenderingFrameListener onWillStartRenderingFrameListener) {
        this.mapChangeReceiver.removeOnWillStartRenderingFrameListener(onWillStartRenderingFrameListener);
    }

    public void removeOnWillStartRenderingMapListener(OnWillStartRenderingMapListener onWillStartRenderingMapListener) {
        this.mapChangeReceiver.removeOnWillStartRenderingMapListener(onWillStartRenderingMapListener);
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    public void setMaximumFps(int n) {
        MapRenderer mapRenderer = this.mapRenderer;
        if (mapRenderer != null) {
            mapRenderer.setMaximumFps(n);
            return;
        }
        throw new IllegalStateException("Calling MapView#setMaximumFps before mapRenderer is created.");
    }

    private static class AttributionClickListener
    implements View.OnClickListener {
        private final AttributionDialogManager defaultDialogManager;
        private UiSettings uiSettings;

        private AttributionClickListener(Context context, MapboxMap mapboxMap) {
            this.defaultDialogManager = new AttributionDialogManager(context, mapboxMap);
            this.uiSettings = mapboxMap.getUiSettings();
        }

        private AttributionDialogManager getDialogManager() {
            if (this.uiSettings.getAttributionDialogManager() != null) {
                return this.uiSettings.getAttributionDialogManager();
            }
            return this.defaultDialogManager;
        }

        public void onClick(View view) {
            this.getDialogManager().onClick(view);
        }

        public void onStop() {
            this.getDialogManager().onStop();
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final List<FocalPointChangeListener> focalPointChangeListeners = new ArrayList<FocalPointChangeListener>();

        private FocalPointInvalidator() {
        }

        void addListener(FocalPointChangeListener focalPointChangeListener) {
            this.focalPointChangeListeners.add(focalPointChangeListener);
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            Iterator<FocalPointChangeListener> iterator2 = this.focalPointChangeListeners.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onFocalPointChanged(pointF);
            }
        }
    }

    private class GesturesManagerInteractionListener
    implements MapboxMap.OnGesturesManagerInteractionListener {
        private GesturesManagerInteractionListener() {
        }

        @Override
        public void cancelAllVelocityAnimations() {
            MapView.this.mapGestureDetector.cancelAnimators();
        }

        @Override
        public AndroidGesturesManager getGesturesManager() {
            return MapView.this.mapGestureDetector.getGesturesManager();
        }

        @Override
        public void onAddFlingListener(MapboxMap.OnFlingListener onFlingListener) {
            MapView.this.mapGestureDetector.addOnFlingListener(onFlingListener);
        }

        @Override
        public void onAddMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
            MapView.this.mapGestureDetector.addOnMapClickListener(onMapClickListener);
        }

        @Override
        public void onAddMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
            MapView.this.mapGestureDetector.addOnMapLongClickListener(onMapLongClickListener);
        }

        @Override
        public void onAddMoveListener(MapboxMap.OnMoveListener onMoveListener) {
            MapView.this.mapGestureDetector.addOnMoveListener(onMoveListener);
        }

        @Override
        public void onAddRotateListener(MapboxMap.OnRotateListener onRotateListener) {
            MapView.this.mapGestureDetector.addOnRotateListener(onRotateListener);
        }

        @Override
        public void onAddScaleListener(MapboxMap.OnScaleListener onScaleListener) {
            MapView.this.mapGestureDetector.addOnScaleListener(onScaleListener);
        }

        @Override
        public void onAddShoveListener(MapboxMap.OnShoveListener onShoveListener) {
            MapView.this.mapGestureDetector.addShoveListener(onShoveListener);
        }

        @Override
        public void onRemoveFlingListener(MapboxMap.OnFlingListener onFlingListener) {
            MapView.this.mapGestureDetector.removeOnFlingListener(onFlingListener);
        }

        @Override
        public void onRemoveMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
            MapView.this.mapGestureDetector.removeOnMapClickListener(onMapClickListener);
        }

        @Override
        public void onRemoveMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
            MapView.this.mapGestureDetector.removeOnMapLongClickListener(onMapLongClickListener);
        }

        @Override
        public void onRemoveMoveListener(MapboxMap.OnMoveListener onMoveListener) {
            MapView.this.mapGestureDetector.removeOnMoveListener(onMoveListener);
        }

        @Override
        public void onRemoveRotateListener(MapboxMap.OnRotateListener onRotateListener) {
            MapView.this.mapGestureDetector.removeOnRotateListener(onRotateListener);
        }

        @Override
        public void onRemoveScaleListener(MapboxMap.OnScaleListener onScaleListener) {
            MapView.this.mapGestureDetector.removeOnScaleListener(onScaleListener);
        }

        @Override
        public void onRemoveShoveListener(MapboxMap.OnShoveListener onShoveListener) {
            MapView.this.mapGestureDetector.removeShoveListener(onShoveListener);
        }

        @Override
        public void setGesturesManager(AndroidGesturesManager androidGesturesManager, boolean bl, boolean bl2) {
            MapView.this.mapGestureDetector.setGesturesManager(MapView.this.getContext(), androidGesturesManager, bl, bl2);
        }
    }

    private class InitialRenderCallback
    implements OnDidFinishRenderingFrameListener {
        private int renderCount;

        InitialRenderCallback() {
            MapView.this.addOnDidFinishRenderingFrameListener(this);
        }

        private void onDestroy() {
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
        }

        @Override
        public void onDidFinishRenderingFrame(boolean bl) {
            if (MapView.this.mapboxMap != null && MapView.this.mapboxMap.getStyle() != null && MapView.this.mapboxMap.getStyle().isFullyLoaded()) {
                int n;
                this.renderCount = n = this.renderCount + 1;
                if (n == 3) {
                    MapView.this.setForeground(null);
                    MapView.this.removeOnDidFinishRenderingFrameListener(this);
                }
            }
        }
    }

    private class MapCallback
    implements OnDidFinishLoadingStyleListener,
    OnDidFinishRenderingFrameListener,
    OnDidFinishLoadingMapListener,
    OnCameraIsChangingListener,
    OnCameraDidChangeListener,
    OnDidFailLoadingMapListener {
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();

        MapCallback() {
            MapView.this.addOnDidFinishLoadingStyleListener(this);
            MapView.this.addOnDidFinishRenderingFrameListener(this);
            MapView.this.addOnDidFinishLoadingMapListener(this);
            MapView.this.addOnCameraIsChangingListener(this);
            MapView.this.addOnCameraDidChangeListener(this);
            MapView.this.addOnDidFailLoadingMapListener(this);
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator2 = this.onMapReadyCallbackList.iterator();
                while (iterator2.hasNext()) {
                    OnMapReadyCallback onMapReadyCallback = iterator2.next();
                    if (onMapReadyCallback != null) {
                        onMapReadyCallback.onMapReady(MapView.this.mapboxMap);
                    }
                    iterator2.remove();
                }
            }
        }

        void addOnMapReadyCallback(OnMapReadyCallback onMapReadyCallback) {
            this.onMapReadyCallbackList.add(onMapReadyCallback);
        }

        void initialised() {
            MapView.this.mapboxMap.onPreMapReady();
            this.onMapReady();
            MapView.this.mapboxMap.onPostMapReady();
        }

        @Override
        public void onCameraDidChange(boolean bl) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraIsChanging() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        void onDestroy() {
            this.onMapReadyCallbackList.clear();
            MapView.this.removeOnDidFinishLoadingStyleListener(this);
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
            MapView.this.removeOnDidFinishLoadingMapListener(this);
            MapView.this.removeOnCameraIsChangingListener(this);
            MapView.this.removeOnCameraDidChangeListener(this);
            MapView.this.removeOnDidFailLoadingMapListener(this);
        }

        @Override
        public void onDidFailLoadingMap(String string2) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onFailLoadingStyle();
            }
        }

        @Override
        public void onDidFinishLoadingMap() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onDidFinishLoadingStyle() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onFinishLoadingStyle();
            }
        }

        @Override
        public void onDidFinishRenderingFrame(boolean bl) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateFullyRendered();
            }
        }
    }

    public static interface OnCameraDidChangeListener {
        public void onCameraDidChange(boolean var1);
    }

    public static interface OnCameraIsChangingListener {
        public void onCameraIsChanging();
    }

    public static interface OnCameraWillChangeListener {
        public void onCameraWillChange(boolean var1);
    }

    public static interface OnCanRemoveUnusedStyleImageListener {
        public boolean onCanRemoveUnusedStyleImage(String var1);
    }

    public static interface OnDidBecomeIdleListener {
        public void onDidBecomeIdle();
    }

    public static interface OnDidFailLoadingMapListener {
        public void onDidFailLoadingMap(String var1);
    }

    public static interface OnDidFailLoadingTileListener {
        public void onDidFailLoadingTile(String var1);
    }

    public static interface OnDidFinishLoadingMapListener {
        public void onDidFinishLoadingMap();
    }

    public static interface OnDidFinishLoadingStyleListener {
        public void onDidFinishLoadingStyle();
    }

    public static interface OnDidFinishRenderingFrameListener {
        public void onDidFinishRenderingFrame(boolean var1);
    }

    public static interface OnDidFinishRenderingMapListener {
        public void onDidFinishRenderingMap(boolean var1);
    }

    public static interface OnSourceChangedListener {
        public void onSourceChangedListener(String var1);
    }

    public static interface OnStyleImageMissingListener {
        public void onStyleImageMissing(String var1);
    }

    public static interface OnWillStartLoadingMapListener {
        public void onWillStartLoadingMap();
    }

    public static interface OnWillStartRenderingFrameListener {
        public void onWillStartRenderingFrame();
    }

    public static interface OnWillStartRenderingMapListener {
        public void onWillStartRenderingMap();
    }
}

