/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.LatLngBoundsZoom;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.Observer;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MapboxMap {
    private static final String TAG = "Mbgl-MapboxMap";
    private AnnotationManager annotationManager;
    private final List<Style.OnStyleLoaded> awaitingStyleGetters = new ArrayList<Style.OnStyleLoaded>();
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private boolean debugActive;
    private final List<OnDeveloperAnimationListener> developerAnimationStartedListeners;
    private LocationComponent locationComponent;
    private final NativeMap nativeMapView;
    private OnFpsChangedListener onFpsChangedListener;
    private final OnGesturesManagerInteractionListener onGesturesManagerInteractionListener;
    private final Projection projection;
    private boolean started;
    private Style style;
    private Style.OnStyleLoaded styleLoadedCallback;
    private final Transform transform;
    private final UiSettings uiSettings;

    MapboxMap(NativeMap nativeMap, Transform transform, UiSettings uiSettings, Projection projection, OnGesturesManagerInteractionListener onGesturesManagerInteractionListener, CameraChangeDispatcher cameraChangeDispatcher, List<OnDeveloperAnimationListener> list) {
        this.nativeMapView = nativeMap;
        this.uiSettings = uiSettings;
        this.projection = projection;
        this.transform = transform;
        this.onGesturesManagerInteractionListener = onGesturesManagerInteractionListener;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
        this.developerAnimationStartedListeners = list;
    }

    private void notifyDeveloperAnimationListeners() {
        Iterator<OnDeveloperAnimationListener> iterator2 = this.developerAnimationStartedListeners.iterator();
        while (iterator2.hasNext()) {
            iterator2.next().onDeveloperAnimationStarted();
        }
    }

    private void setApiBaseUrl(MapboxMapOptions object) {
        if (!TextUtils.isEmpty((CharSequence)(object = ((MapboxMapOptions)object).getApiBaseUrl()))) {
            this.nativeMapView.setApiBaseUrl((String)object);
        }
    }

    private void setPrefetchesTiles(MapboxMapOptions mapboxMapOptions) {
        if (!mapboxMapOptions.getPrefetchesTiles()) {
            this.setPrefetchZoomDelta(0);
        } else {
            this.setPrefetchZoomDelta(mapboxMapOptions.getPrefetchZoomDelta());
        }
    }

    @Deprecated
    public Marker addMarker(BaseMarkerOptions baseMarkerOptions) {
        return this.annotationManager.addMarker(baseMarkerOptions, this);
    }

    @Deprecated
    public Marker addMarker(MarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @Deprecated
    public List<Marker> addMarkers(List<? extends BaseMarkerOptions> list) {
        return this.annotationManager.addMarkers(list, this);
    }

    public void addOnCameraIdleListener(OnCameraIdleListener onCameraIdleListener) {
        this.cameraChangeDispatcher.addOnCameraIdleListener(onCameraIdleListener);
    }

    public void addOnCameraMoveCancelListener(OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.cameraChangeDispatcher.addOnCameraMoveCancelListener(onCameraMoveCanceledListener);
    }

    public void addOnCameraMoveListener(OnCameraMoveListener onCameraMoveListener) {
        this.cameraChangeDispatcher.addOnCameraMoveListener(onCameraMoveListener);
    }

    public void addOnCameraMoveStartedListener(OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.cameraChangeDispatcher.addOnCameraMoveStartedListener(onCameraMoveStartedListener);
    }

    public void addOnFlingListener(OnFlingListener onFlingListener) {
        this.onGesturesManagerInteractionListener.onAddFlingListener(onFlingListener);
    }

    public void addOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.onGesturesManagerInteractionListener.onAddMapClickListener(onMapClickListener);
    }

    public void addOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.onGesturesManagerInteractionListener.onAddMapLongClickListener(onMapLongClickListener);
    }

    public void addOnMoveListener(OnMoveListener onMoveListener) {
        this.onGesturesManagerInteractionListener.onAddMoveListener(onMoveListener);
    }

    public void addOnRotateListener(OnRotateListener onRotateListener) {
        this.onGesturesManagerInteractionListener.onAddRotateListener(onRotateListener);
    }

    public void addOnScaleListener(OnScaleListener onScaleListener) {
        this.onGesturesManagerInteractionListener.onAddScaleListener(onScaleListener);
    }

    public void addOnShoveListener(OnShoveListener onShoveListener) {
        this.onGesturesManagerInteractionListener.onAddShoveListener(onShoveListener);
    }

    @Deprecated
    public Polygon addPolygon(PolygonOptions polygonOptions) {
        return this.annotationManager.addPolygon(polygonOptions, this);
    }

    @Deprecated
    public List<Polygon> addPolygons(List<PolygonOptions> list) {
        return this.annotationManager.addPolygons(list, this);
    }

    @Deprecated
    public Polyline addPolyline(PolylineOptions polylineOptions) {
        return this.annotationManager.addPolyline(polylineOptions, this);
    }

    @Deprecated
    public List<Polyline> addPolylines(List<PolylineOptions> list) {
        return this.annotationManager.addPolylines(list, this);
    }

    public final void animateCamera(CameraUpdate cameraUpdate) {
        this.animateCamera(cameraUpdate, 300, null);
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n) {
        this.animateCamera(cameraUpdate, n, null);
    }

    public final void animateCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        if (n > 0) {
            this.notifyDeveloperAnimationListeners();
            this.transform.animateCamera(this, cameraUpdate, n, cancelableCallback);
            return;
        }
        throw new IllegalArgumentException("Null duration passed into animateCamera");
    }

    public final void animateCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        this.animateCamera(cameraUpdate, 300, cancelableCallback);
    }

    public void cancelAllVelocityAnimations() {
        this.onGesturesManagerInteractionListener.cancelAllVelocityAnimations();
    }

    public void cancelTransitions() {
        this.transform.cancelTransitions();
    }

    @Deprecated
    public void clear() {
        this.annotationManager.removeAnnotations();
    }

    @Deprecated
    public void cycleDebugOptions() {
        boolean bl;
        this.debugActive = bl = this.nativeMapView.getDebug() ^ true;
        this.nativeMapView.setDebug(bl);
    }

    @Deprecated
    public void deselectMarker(Marker marker) {
        this.annotationManager.deselectMarker(marker);
    }

    @Deprecated
    public void deselectMarkers() {
        this.annotationManager.deselectMarkers();
    }

    public final void easeCamera(CameraUpdate cameraUpdate) {
        this.easeCamera(cameraUpdate, 300);
    }

    public final void easeCamera(CameraUpdate cameraUpdate, int n) {
        this.easeCamera(cameraUpdate, n, null);
    }

    public final void easeCamera(CameraUpdate cameraUpdate, int n, CancelableCallback cancelableCallback) {
        this.easeCamera(cameraUpdate, n, true, cancelableCallback);
    }

    public final void easeCamera(CameraUpdate cameraUpdate, int n, boolean bl) {
        this.easeCamera(cameraUpdate, n, bl, null);
    }

    public final void easeCamera(CameraUpdate cameraUpdate, int n, boolean bl, CancelableCallback cancelableCallback) {
        if (n > 0) {
            this.notifyDeveloperAnimationListeners();
            this.transform.easeCamera(this, cameraUpdate, n, bl, cancelableCallback);
            return;
        }
        throw new IllegalArgumentException("Null duration passed into easeCamera");
    }

    public final void easeCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        this.easeCamera(cameraUpdate, 300, cancelableCallback);
    }

    @Deprecated
    public Annotation getAnnotation(long l) {
        return this.annotationManager.getAnnotation(l);
    }

    @Deprecated
    public List<Annotation> getAnnotations() {
        return this.annotationManager.getAnnotations();
    }

    public CameraPosition getCameraForGeometry(Geometry geometry) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0});
    }

    public CameraPosition getCameraForGeometry(Geometry geometry, double d, double d2) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0}, d, d2);
    }

    public CameraPosition getCameraForGeometry(Geometry geometry, int[] nArray) {
        return this.getCameraForGeometry(geometry, nArray, this.transform.getBearing(), this.transform.getTilt());
    }

    public CameraPosition getCameraForGeometry(Geometry geometry, int[] nArray, double d, double d2) {
        return this.nativeMapView.getCameraForGeometry(geometry, nArray, d, d2);
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0});
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds, double d, double d2) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0}, d, d2);
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds, int[] nArray) {
        return this.getCameraForLatLngBounds(latLngBounds, nArray, this.transform.getRawBearing(), this.transform.getTilt());
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds latLngBounds, int[] nArray, double d, double d2) {
        return this.nativeMapView.getCameraForLatLngBounds(latLngBounds, nArray, d, d2);
    }

    public final CameraPosition getCameraPosition() {
        return this.transform.getCameraPosition();
    }

    public AndroidGesturesManager getGesturesManager() {
        return this.onGesturesManagerInteractionListener.getGesturesManager();
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    @Deprecated
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.annotationManager.getInfoWindowManager().getInfoWindowAdapter();
    }

    public LatLngBoundsZoom getLatLngBoundsZoomFromCamera(CameraPosition cameraPosition) {
        return this.nativeMapView.getLatLngBoundsZoomFromCamera(cameraPosition);
    }

    public LocationComponent getLocationComponent() {
        return this.locationComponent;
    }

    @Deprecated
    public List<Marker> getMarkers() {
        return this.annotationManager.getMarkers();
    }

    public double getMaxPitch() {
        return this.transform.getMaxPitch();
    }

    public double getMaxZoomLevel() {
        return this.transform.getMaxZoom();
    }

    public double getMinPitch() {
        return this.transform.getMinPitch();
    }

    public double getMinZoomLevel() {
        return this.transform.getMinZoom();
    }

    long getNativeMapPtr() {
        return this.nativeMapView.getNativePtr();
    }

    OnFpsChangedListener getOnFpsChangedListener() {
        return this.onFpsChangedListener;
    }

    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowClickListener();
    }

    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowCloseListener();
    }

    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowLongClickListener();
    }

    @Deprecated
    public int[] getPadding() {
        return this.projection.getContentPadding();
    }

    @Deprecated
    public List<Polygon> getPolygons() {
        return this.annotationManager.getPolygons();
    }

    @Deprecated
    public List<Polyline> getPolylines() {
        return this.annotationManager.getPolylines();
    }

    public int getPrefetchZoomDelta() {
        return this.nativeMapView.getPrefetchZoomDelta();
    }

    @Deprecated
    public boolean getPrefetchesTiles() {
        return this.nativeMapView.getPrefetchTiles();
    }

    public Projection getProjection() {
        return this.projection;
    }

    @Deprecated
    public List<Marker> getSelectedMarkers() {
        return this.annotationManager.getSelectedMarkers();
    }

    public Style getStyle() {
        Style style2 = this.style;
        if (style2 != null && style2.isFullyLoaded()) {
            return this.style;
        }
        return null;
    }

    public void getStyle(Style.OnStyleLoaded onStyleLoaded) {
        Style style2 = this.style;
        if (style2 != null && style2.isFullyLoaded()) {
            onStyleLoaded.onStyleLoaded(this.style);
        } else {
            this.awaitingStyleGetters.add(onStyleLoaded);
        }
    }

    Transform getTransform() {
        return this.transform;
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    void initialise(Context context, MapboxMapOptions mapboxMapOptions) {
        this.transform.initialise(this, mapboxMapOptions);
        this.uiSettings.initialise(context, mapboxMapOptions);
        this.setDebugActive(mapboxMapOptions.getDebugActive());
        this.setApiBaseUrl(mapboxMapOptions);
        this.setPrefetchesTiles(mapboxMapOptions);
    }

    void injectAnnotationManager(AnnotationManager annotationManager) {
        this.annotationManager = annotationManager.bind(this);
    }

    void injectLocationComponent(LocationComponent locationComponent) {
        this.locationComponent = locationComponent;
    }

    @Deprecated
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.annotationManager.getInfoWindowManager().isAllowConcurrentMultipleOpenInfoWindows();
    }

    public boolean isDebugActive() {
        return this.debugActive;
    }

    public boolean isUserAnimationInProgress() {
        return this.nativeMapView.isUserAnimationInProgress();
    }

    public final void moveCamera(CameraUpdate cameraUpdate) {
        this.moveCamera(cameraUpdate, null);
    }

    public final void moveCamera(CameraUpdate cameraUpdate, CancelableCallback cancelableCallback) {
        this.notifyDeveloperAnimationListeners();
        this.transform.moveCamera(this, cameraUpdate, cancelableCallback);
    }

    void notifyStyleLoaded() {
        if (this.nativeMapView.isDestroyed()) {
            return;
        }
        Object object = this.style;
        if (object != null) {
            ((Style)object).onDidFinishLoadingStyle();
            this.locationComponent.onFinishLoadingStyle();
            object = this.styleLoadedCallback;
            if (object != null) {
                object.onStyleLoaded(this.style);
            }
            object = this.awaitingStyleGetters.iterator();
            while (object.hasNext()) {
                object.next().onStyleLoaded(this.style);
            }
        } else {
            MapStrictMode.strictModeViolation("No style to provide.");
        }
        this.styleLoadedCallback = null;
        this.awaitingStyleGetters.clear();
    }

    void onDestroy() {
        this.locationComponent.onDestroy();
        Style style2 = this.style;
        if (style2 != null) {
            style2.clear();
        }
        this.cameraChangeDispatcher.onDestroy();
    }

    void onFailLoadingStyle() {
        this.styleLoadedCallback = null;
    }

    void onFinishLoadingStyle() {
        this.notifyStyleLoaded();
    }

    void onPostMapReady() {
        this.transform.invalidateCameraPosition();
    }

    void onPreMapReady() {
        this.transform.invalidateCameraPosition();
        this.annotationManager.reloadMarkers();
        this.annotationManager.adjustTopOffsetPixels(this);
    }

    void onRestoreInstanceState(Bundle bundle) {
        CameraPosition cameraPosition = (CameraPosition)bundle.getParcelable("mapbox_cameraPosition");
        this.uiSettings.onRestoreInstanceState(bundle);
        if (cameraPosition != null) {
            this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder(cameraPosition).build()));
        }
        this.nativeMapView.setDebug(bundle.getBoolean("mapbox_debugActive"));
    }

    void onSaveInstanceState(Bundle bundle) {
        bundle.putParcelable("mapbox_cameraPosition", (Parcelable)this.transform.getCameraPosition());
        bundle.putBoolean("mapbox_debugActive", this.isDebugActive());
        this.uiSettings.onSaveInstanceState(bundle);
    }

    void onStart() {
        this.started = true;
        this.locationComponent.onStart();
    }

    void onStop() {
        this.started = false;
        this.locationComponent.onStop();
    }

    void onUpdateFullyRendered() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.uiSettings.update(cameraPosition);
        }
    }

    void onUpdateRegionChange() {
        this.annotationManager.update();
    }

    public List<Feature> queryRenderedFeatures(PointF pointF, Expression expression, String ... stringArray) {
        return this.nativeMapView.queryRenderedFeatures(pointF, stringArray, expression);
    }

    public List<Feature> queryRenderedFeatures(PointF pointF, String ... stringArray) {
        return this.nativeMapView.queryRenderedFeatures(pointF, stringArray, null);
    }

    public List<Feature> queryRenderedFeatures(RectF rectF, Expression expression, String ... stringArray) {
        return this.nativeMapView.queryRenderedFeatures(rectF, stringArray, expression);
    }

    public List<Feature> queryRenderedFeatures(RectF rectF, String ... stringArray) {
        return this.nativeMapView.queryRenderedFeatures(rectF, stringArray, null);
    }

    @Deprecated
    public void removeAnnotation(long l) {
        this.annotationManager.removeAnnotation(l);
    }

    @Deprecated
    public void removeAnnotation(Annotation annotation) {
        this.annotationManager.removeAnnotation(annotation);
    }

    @Deprecated
    public void removeAnnotations() {
        this.annotationManager.removeAnnotations();
    }

    @Deprecated
    public void removeAnnotations(List<? extends Annotation> list) {
        this.annotationManager.removeAnnotations(list);
    }

    @Deprecated
    public void removeMarker(Marker marker) {
        this.annotationManager.removeAnnotation(marker);
    }

    public void removeOnCameraIdleListener(OnCameraIdleListener onCameraIdleListener) {
        this.cameraChangeDispatcher.removeOnCameraIdleListener(onCameraIdleListener);
    }

    public void removeOnCameraMoveCancelListener(OnCameraMoveCanceledListener onCameraMoveCanceledListener) {
        this.cameraChangeDispatcher.removeOnCameraMoveCancelListener(onCameraMoveCanceledListener);
    }

    public void removeOnCameraMoveListener(OnCameraMoveListener onCameraMoveListener) {
        this.cameraChangeDispatcher.removeOnCameraMoveListener(onCameraMoveListener);
    }

    public void removeOnCameraMoveStartedListener(OnCameraMoveStartedListener onCameraMoveStartedListener) {
        this.cameraChangeDispatcher.removeOnCameraMoveStartedListener(onCameraMoveStartedListener);
    }

    public void removeOnFlingListener(OnFlingListener onFlingListener) {
        this.onGesturesManagerInteractionListener.onRemoveFlingListener(onFlingListener);
    }

    public void removeOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.onGesturesManagerInteractionListener.onRemoveMapClickListener(onMapClickListener);
    }

    public void removeOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.onGesturesManagerInteractionListener.onRemoveMapLongClickListener(onMapLongClickListener);
    }

    public void removeOnMoveListener(OnMoveListener onMoveListener) {
        this.onGesturesManagerInteractionListener.onRemoveMoveListener(onMoveListener);
    }

    public void removeOnRotateListener(OnRotateListener onRotateListener) {
        this.onGesturesManagerInteractionListener.onRemoveRotateListener(onRotateListener);
    }

    public void removeOnScaleListener(OnScaleListener onScaleListener) {
        this.onGesturesManagerInteractionListener.onRemoveScaleListener(onScaleListener);
    }

    public void removeOnShoveListener(OnShoveListener onShoveListener) {
        this.onGesturesManagerInteractionListener.onRemoveShoveListener(onShoveListener);
    }

    @Deprecated
    public void removePolygon(Polygon polygon) {
        this.annotationManager.removeAnnotation(polygon);
    }

    @Deprecated
    public void removePolyline(Polyline polyline) {
        this.annotationManager.removeAnnotation(polyline);
    }

    public void resetNorth() {
        this.notifyDeveloperAnimationListeners();
        this.transform.resetNorth();
    }

    public void scrollBy(float f, float f2) {
        this.scrollBy(f, f2, 0L);
    }

    public void scrollBy(float f, float f2, long l) {
        this.notifyDeveloperAnimationListeners();
        this.nativeMapView.moveBy(f, f2, l);
    }

    @Deprecated
    public void selectMarker(Marker marker) {
        if (marker == null) {
            Logger.w(TAG, "marker was null, so just returning");
            return;
        }
        this.annotationManager.selectMarker(marker);
    }

    @Deprecated
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean bl) {
        this.annotationManager.getInfoWindowManager().setAllowConcurrentMultipleOpenInfoWindows(bl);
    }

    public void setCameraPosition(CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), null);
    }

    public void setDebugActive(boolean bl) {
        this.debugActive = bl;
        this.nativeMapView.setDebug(bl);
    }

    public void setFocalBearing(double d, float f, float f2, long l) {
        this.notifyDeveloperAnimationListeners();
        this.transform.setBearing(d, f, f2, l);
    }

    public void setGesturesManager(AndroidGesturesManager androidGesturesManager, boolean bl, boolean bl2) {
        this.onGesturesManagerInteractionListener.setGesturesManager(androidGesturesManager, bl, bl2);
    }

    @Deprecated
    public void setInfoWindowAdapter(InfoWindowAdapter infoWindowAdapter) {
        this.annotationManager.getInfoWindowManager().setInfoWindowAdapter(infoWindowAdapter);
    }

    public void setLatLngBoundsForCameraTarget(LatLngBounds latLngBounds) {
        this.nativeMapView.setLatLngBounds(latLngBounds);
    }

    public void setMaxPitchPreference(double d) {
        this.transform.setMaxPitch(d);
    }

    public void setMaxZoomPreference(double d) {
        this.transform.setMaxZoom(d);
    }

    public void setMinPitchPreference(double d) {
        this.transform.setMinPitch(d);
    }

    public void setMinZoomPreference(double d) {
        this.transform.setMinZoom(d);
    }

    public void setOfflineRegionDefinition(OfflineRegionDefinition offlineRegionDefinition) {
        this.setOfflineRegionDefinition(offlineRegionDefinition, null);
    }

    public void setOfflineRegionDefinition(OfflineRegionDefinition offlineRegionDefinition, Style.OnStyleLoaded onStyleLoaded) {
        double d = offlineRegionDefinition.getMinZoom();
        double d2 = offlineRegionDefinition.getMaxZoom();
        this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder().target(offlineRegionDefinition.getBounds().getCenter()).zoom(d).build()));
        this.setMinZoomPreference(d);
        this.setMaxZoomPreference(d2);
        this.setStyle(new Style.Builder().fromUri(offlineRegionDefinition.getStyleURL()), onStyleLoaded);
    }

    public void setOnFpsChangedListener(OnFpsChangedListener onFpsChangedListener) {
        this.onFpsChangedListener = onFpsChangedListener;
        this.nativeMapView.setOnFpsChangedListener(onFpsChangedListener);
    }

    public void setOnInfoWindowClickListener(OnInfoWindowClickListener onInfoWindowClickListener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowClickListener(onInfoWindowClickListener);
    }

    public void setOnInfoWindowCloseListener(OnInfoWindowCloseListener onInfoWindowCloseListener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowCloseListener(onInfoWindowCloseListener);
    }

    public void setOnInfoWindowLongClickListener(OnInfoWindowLongClickListener onInfoWindowLongClickListener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowLongClickListener(onInfoWindowLongClickListener);
    }

    @Deprecated
    public void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        this.annotationManager.setOnMarkerClickListener(onMarkerClickListener);
    }

    @Deprecated
    public void setOnPolygonClickListener(OnPolygonClickListener onPolygonClickListener) {
        this.annotationManager.setOnPolygonClickListener(onPolygonClickListener);
    }

    @Deprecated
    public void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        this.annotationManager.setOnPolylineClickListener(onPolylineClickListener);
    }

    @Deprecated
    public void setPadding(int n, int n2, int n3, int n4) {
        this.projection.setContentPadding(new int[]{n, n2, n3, n4});
        this.uiSettings.invalidate();
    }

    public void setPrefetchZoomDelta(int n) {
        this.nativeMapView.setPrefetchZoomDelta(n);
    }

    @Deprecated
    public void setPrefetchesTiles(boolean bl) {
        this.nativeMapView.setPrefetchTiles(bl);
    }

    public void setStyle(Style.Builder builder) {
        this.setStyle(builder, null);
    }

    public void setStyle(Style.Builder builder, Style.OnStyleLoaded object) {
        this.styleLoadedCallback = object;
        this.locationComponent.onStartLoadingMap();
        object = this.style;
        if (object != null) {
            ((Style)object).clear();
        }
        this.style = builder.build(this.nativeMapView);
        if (!TextUtils.isEmpty((CharSequence)builder.getUri())) {
            this.nativeMapView.setStyleUri(builder.getUri());
        } else if (!TextUtils.isEmpty((CharSequence)builder.getJson())) {
            this.nativeMapView.setStyleJson(builder.getJson());
        } else {
            this.nativeMapView.setStyleJson("{\"version\": 8,\"sources\": {},\"layers\": []}");
        }
    }

    public void setStyle(String string2) {
        this.setStyle(string2, null);
    }

    public void setStyle(String string2, Style.OnStyleLoaded onStyleLoaded) {
        this.setStyle(new Style.Builder().fromUri(string2), onStyleLoaded);
    }

    public void setUserAnimationInProgress(boolean bl) {
        this.nativeMapView.setUserAnimationInProgress(bl);
    }

    public void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        if (!this.started) {
            return;
        }
        this.nativeMapView.addSnapshotCallback(snapshotReadyCallback);
    }

    public void subscribe(Observer observer, List<String> list) {
        this.nativeMapView.subscribe(observer, list);
    }

    public void triggerRepaint() {
        this.nativeMapView.triggerRepaint();
    }

    public void unsubscribe(Observer observer) {
        this.nativeMapView.unsubscribe(observer);
    }

    public void unsubscribe(Observer observer, List<String> list) {
        this.nativeMapView.unsubscribe(observer, list);
    }

    @Deprecated
    public void updateMarker(Marker marker) {
        this.annotationManager.updateMarker(marker, this);
    }

    @Deprecated
    public void updatePolygon(Polygon polygon) {
        this.annotationManager.updatePolygon(polygon);
    }

    @Deprecated
    public void updatePolyline(Polyline polyline) {
        this.annotationManager.updatePolyline(polyline);
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    @Deprecated
    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_API_ANIMATION = 3;
        public static final int REASON_API_GESTURE = 1;
        public static final int REASON_DEVELOPER_ANIMATION = 2;

        public void onCameraMoveStarted(int var1);
    }

    public static interface OnCompassAnimationListener {
        public void onCompassAnimation();

        public void onCompassAnimationFinished();
    }

    public static interface OnDeveloperAnimationListener {
        public void onDeveloperAnimationStarted();
    }

    public static interface OnFlingListener {
        public void onFling();
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    static interface OnGesturesManagerInteractionListener {
        public void cancelAllVelocityAnimations();

        public AndroidGesturesManager getGesturesManager();

        public void onAddFlingListener(OnFlingListener var1);

        public void onAddMapClickListener(OnMapClickListener var1);

        public void onAddMapLongClickListener(OnMapLongClickListener var1);

        public void onAddMoveListener(OnMoveListener var1);

        public void onAddRotateListener(OnRotateListener var1);

        public void onAddScaleListener(OnScaleListener var1);

        public void onAddShoveListener(OnShoveListener var1);

        public void onRemoveFlingListener(OnFlingListener var1);

        public void onRemoveMapClickListener(OnMapClickListener var1);

        public void onRemoveMapLongClickListener(OnMapLongClickListener var1);

        public void onRemoveMoveListener(OnMoveListener var1);

        public void onRemoveRotateListener(OnRotateListener var1);

        public void onRemoveScaleListener(OnScaleListener var1);

        public void onRemoveShoveListener(OnShoveListener var1);

        public void setGesturesManager(AndroidGesturesManager var1, boolean var2, boolean var3);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnMapClickListener {
        public boolean onMapClick(LatLng var1);
    }

    public static interface OnMapLongClickListener {
        public boolean onMapLongClick(LatLng var1);
    }

    @Deprecated
    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMoveListener {
        public void onMove(MoveGestureDetector var1);

        public void onMoveBegin(MoveGestureDetector var1);

        public void onMoveEnd(MoveGestureDetector var1);
    }

    @Deprecated
    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    @Deprecated
    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnRotateListener {
        public void onRotate(RotateGestureDetector var1);

        public void onRotateBegin(RotateGestureDetector var1);

        public void onRotateEnd(RotateGestureDetector var1);
    }

    public static interface OnScaleListener {
        public void onScale(StandardScaleGestureDetector var1);

        public void onScaleBegin(StandardScaleGestureDetector var1);

        public void onScaleEnd(StandardScaleGestureDetector var1);
    }

    public static interface OnShoveListener {
        public void onShove(ShoveGestureDetector var1);

        public void onShoveBegin(ShoveGestureDetector var1);

        public void onShoveEnd(ShoveGestureDetector var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }
}

